/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.delegate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.delegate.RWTLaunch;
import org.eclipse.rap.ui.internal.launch.rwt.util.IOUtil;
import org.eclipse.rap.ui.internal.launch.rwt.util.TemplateParser;

class WebXmlProvider {
    private final RWTLaunchConfig config;
    private final File destination;

    WebXmlProvider(RWTLaunch launch) {
        this.config = launch.getLaunchConfig();
        this.destination = launch.getWebXmlPath();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    File provide(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("Provisioning web.xml...", 1);
        try {
            this.internalProvide();
            subMonitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        subMonitor.done();
        return this.destination;
    }

    private void internalProvide() {
        if (this.config.getUseWebXml()) {
            this.provideCustomWebXml();
        } else {
            this.provideGeneratedWebXml();
        }
    }

    private void provideCustomWebXml() {
        String source = this.config.getWebXmlLocation();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile absoluteSourcce = root.getFile(Path.fromPortableString((String)source));
        IOUtil.copy(new File(absoluteSourcce.getLocationURI()), this.destination);
    }

    private void provideGeneratedWebXml() {
        String webXmlContent = this.generateWebXmlContent();
        byte[] bytes = WebXmlProvider.getBytes(webXmlContent);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        IOUtil.copy(inputStream, this.destination);
    }

    private String generateWebXmlContent() {
        TemplateParser templateParser = new TemplateParser(this.getWebXmlTemplate());
        templateParser.registerVariable("webAppName", this.config.getName());
        templateParser.registerVariable("entryPoint", this.config.getEntryPoint());
        return templateParser.parse();
    }

    private String getWebXmlTemplate() {
        String string;
        InputStream inputStream = this.getClass().getResourceAsStream("template-web.xml");
        try {
            string = IOUtil.readContent(inputStream);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            IOUtil.closeInputStream(inputStream);
            throw throwable;
        }
        IOUtil.closeInputStream(inputStream);
        return string;
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }
}

