/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.rap.ui.internal.launch.rwt.config.BrowserMode;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.tab.HelpContextIds;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RWTLaunchTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BrowserSection
extends RWTLaunchTab {
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    private static final int MARGIN = 17;
    private Button cbOpenBrowser;
    private Button rbInternalBrowser;
    private Button rbExternalBrowser;

    public String getName() {
        return "Browser";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setText("Browser");
        group.setLayout((Layout)new GridLayout(2, false));
        this.cbOpenBrowser = this.createCheckButton((Composite)group, "Open application in");
        this.cbOpenBrowser.setLayoutData((Object)BrowserSection.newGridData(1, true));
        this.cbOpenBrowser.addSelectionListener((SelectionListener)new OpenBrowserSelectionListener());
        Link lnkBrowserPrefs = new Link((Composite)group, 0);
        lnkBrowserPrefs.setText("<a>Configure browsers...</a>");
        lnkBrowserPrefs.setLayoutData((Object)BrowserSection.newGridData(0x1000008, false));
        lnkBrowserPrefs.addSelectionListener((SelectionListener)new BrowserPrefsSelectionListener());
        this.rbInternalBrowser = this.createRadioButton((Composite)group, "Internal browser");
        this.rbInternalBrowser.setLayoutData((Object)BrowserSection.newGridData(17, 1, false, 2));
        this.rbInternalBrowser.addSelectionListener((SelectionListener)new BrowserSelectionListener());
        this.rbExternalBrowser = this.createRadioButton((Composite)group, "External browser");
        this.rbExternalBrowser.setLayoutData((Object)BrowserSection.newGridData(17, 1, false, 2));
        this.rbExternalBrowser.addSelectionListener((SelectionListener)new BrowserSelectionListener());
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), "org.eclipse.ra.ui.launch.rwt.launch_configuration_dialog_main_tab");
        this.updateEnablement();
    }

    public void initializeFrom(RWTLaunchConfig config) {
        BrowserMode browserMode = config.getBrowserMode();
        this.cbOpenBrowser.setSelection(config.getOpenBrowser());
        this.rbInternalBrowser.setSelection(browserMode == BrowserMode.INTERNAL);
        this.rbExternalBrowser.setSelection(browserMode == BrowserMode.EXTERNAL);
        this.updateEnablement();
    }

    public void performApply(RWTLaunchConfig config) {
        config.setOpenBrowser(this.cbOpenBrowser.getSelection());
        if (this.rbExternalBrowser.getSelection()) {
            config.setBrowserMode(BrowserMode.EXTERNAL);
        } else {
            config.setBrowserMode(BrowserMode.INTERNAL);
        }
    }

    private void updateEnablement() {
        boolean openBrowser = this.cbOpenBrowser.getSelection();
        this.rbInternalBrowser.setEnabled(openBrowser);
        this.rbExternalBrowser.setEnabled(openBrowser);
    }

    private void handleBrowserPrefsLink() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
        dialog.close();
    }

    private static GridData newGridData(int horizontalAlign, boolean grapHorizontal) {
        return BrowserSection.newGridData(0, horizontalAlign, grapHorizontal, 1);
    }

    private static GridData newGridData(int indent, int horizontalAlign, boolean grapHorizontal, int span) {
        GridData result = new GridData(horizontalAlign, 0x1000000, grapHorizontal, false);
        result.horizontalIndent = indent;
        result.horizontalSpan = span;
        return result;
    }

    private class BrowserPrefsSelectionListener
    extends SelectionAdapter {
        private BrowserPrefsSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BrowserSection.this.handleBrowserPrefsLink();
        }
    }

    private class BrowserSelectionListener
    extends SelectionAdapter {
        private BrowserSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BrowserSection.this.updateLaunchConfigurationDialog();
        }
    }

    private class OpenBrowserSelectionListener
    extends SelectionAdapter {
        private OpenBrowserSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            BrowserSection.this.updateLaunchConfigurationDialog();
            BrowserSection.this.updateEnablement();
        }
    }
}

