/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.internal.widgets.ListModel;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.listkit.ListThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    private final ListModel model;
    private int focusIndex;
    private transient IListAdapter listAdapter;
    private final ResizeListener resizeListener;
    private int topIndex;
    private boolean hasVScrollBar;
    private boolean hasHScrollBar;
    private BoxDimensions bufferedItemPadding;
    private int customItemHeight;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
        this.model = new ListModel((style & 4) != 0);
        this.focusIndex = -1;
        this.customItemHeight = -1;
        this.resizeListener = new ResizeListener();
        this.addControlListener(this.resizeListener);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IListAdapter.class) {
            if (this.listAdapter == null) {
                this.listAdapter = new IListAdapter(){

                    @Override
                    public void setFocusIndex(int focusIndex) {
                        List.this.setFocusIndex(focusIndex);
                    }

                    @Override
                    public Point getItemDimensions() {
                        return List.this.getItemDimensions();
                    }
                };
            }
            result = this.listAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] selectionIndices = this.model.getSelectionIndices();
        String[] result = new String[selectionIndices.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.model.getItem(selectionIndices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.model.getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return this.model.getSelectionIndices();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.model.getSelectionCount();
    }

    public void setSelection(int selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(int[] selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.model.setSelection(start, end);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(String[] selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void select(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (index >= 0 && index < this.model.getItemCount()) {
                this.model.setSelection(index);
            }
        } else {
            this.model.addSelection(index);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) != 0 && ((this.style & 4) == 0 || length <= 1)) {
            int i = 0;
            while (i < length) {
                int index = indices[i];
                this.model.addSelection(index);
                ++i;
            }
        }
    }

    public void select(int start, int end) {
        int count;
        this.checkWidget();
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && (count = this.model.getItemCount()) != 0 && start < count) {
            int startIndex = Math.max(0, start);
            int endIndex = Math.min(end, count - 1);
            if ((this.style & 4) != 0) {
                this.model.setSelection(startIndex);
            } else {
                int i = startIndex;
                while (i <= endIndex) {
                    this.model.addSelection(i);
                    ++i;
                }
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        this.model.selectAll();
        this.updateFocusIndexAfterSelectionChange();
    }

    public void deselectAll() {
        this.checkWidget();
        this.model.deselectAll();
        this.updateFocusIndexAfterSelectionChange();
    }

    public void deselect(int index) {
        this.checkWidget();
        this.removeFromSelection(index);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.model.getItemCount() - 1) {
            this.deselectAll();
        } else {
            int actualStart;
            int i = actualStart = Math.max(0, start);
            while (i <= end) {
                this.removeFromSelection(i);
                ++i;
            }
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int i = 0;
        while (i < indices.length) {
            this.removeFromSelection(indices[i]);
            ++i;
        }
    }

    private void removeFromSelection(int index) {
        if (index >= 0 && index < this.model.getItemCount()) {
            boolean found = false;
            int[] selection = this.model.getSelectionIndices();
            int i = 0;
            while (!found && i < selection.length) {
                if (index == selection[i]) {
                    int length = selection.length;
                    int[] newSel = new int[length - 1];
                    System.arraycopy(selection, 0, newSel, 0, i);
                    if (i < length - 1) {
                        System.arraycopy(selection, i + 1, newSel, i, length - i - 1);
                    }
                    selection = newSel;
                    this.model.setSelection(selection);
                    found = true;
                }
                ++i;
            }
        }
    }

    public boolean isSelected(int index) {
        boolean result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            result = index == this.getSelectionIndex();
        } else {
            int[] selectionIndices = this.getSelectionIndices();
            result = false;
            int i = 0;
            while (!result && i < selectionIndices.length) {
                if (index == selectionIndices[i]) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        int count = this.model.getItemCount();
        if (this.topIndex != topIndex && topIndex >= 0 && topIndex < count) {
            this.topIndex = topIndex;
        }
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index != -1) {
            int itemCount = this.getVisibleItemCount();
            if (index < this.topIndex) {
                this.setTopIndex(index);
            } else if (itemCount > 0 && index >= this.topIndex + itemCount) {
                this.setTopIndex(index - itemCount + 1);
            }
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        return this.focusIndex;
    }

    public void add(String string) {
        this.checkWidget();
        this.model.add(string);
        this.updateFocusIndexAfterItemChange();
        this.updateScrollBars();
    }

    public void add(String string, int index) {
        this.checkWidget();
        this.model.add(string, index);
        this.updateFocusIndexAfterItemChange();
        this.updateScrollBars();
    }

    public void remove(int index) {
        this.checkWidget();
        this.model.remove(index);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.model.remove(start, end);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        this.model.remove(indices);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void remove(String string) {
        this.checkWidget();
        this.model.remove(string);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void removeAll() {
        this.checkWidget();
        this.model.removeAll();
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.validateMarkup(new String[]{string});
        this.model.setItem(index, string);
        this.updateScrollBars();
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.validateMarkup(items);
        this.model.setItems(items);
        this.updateScrollBars();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.model.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.model.getItemCount();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.model.getItems();
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.model.indexOf(string, start);
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = this.customItemHeight;
        if (result == -1) {
            BoxDimensions itemPadding = this.getItemPadding();
            result = TextSizeUtil.getCharHeight(this.getFont()) + itemPadding.top + itemPadding.bottom;
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateScrollBars();
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.customItemHeight".equals(key)) {
            this.setCustomItemHeight(value);
        }
        if (!"org.eclipse.rap.rwt.markupEnabled".equals(key) || !MarkupUtil.isMarkupEnabledFor(this)) {
            super.setData(key, value);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = this.getMaxItemWidth();
        int height = this.getItemHeight() * this.getItemCount();
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        BoxDimensions border = this.getBorder();
        width += border.left + border.right;
        height += border.top + border.bottom;
        if ((this.style & 0x200) != 0) {
            width += this.getVerticalBar().getSize().x;
        }
        if ((this.style & 0x100) != 0) {
            height += this.getHorizontalBar().getSize().y;
        }
        return new Point(width, height);
    }

    private void setFocusIndex(int focusIndex) {
        int count = this.model.getItemCount();
        if (focusIndex == -1 || focusIndex >= 0 && focusIndex < count) {
            this.focusIndex = focusIndex;
        }
    }

    private void updateFocusIndexAfterSelectionChange() {
        this.focusIndex = -1;
        if (this.model.getItemCount() > 0) {
            this.focusIndex = this.model.getSelectionIndex() == -1 ? 0 : this.model.getSelectionIndices()[0];
        }
    }

    private void updateFocusIndexAfterItemChange() {
        if (this.model.getItemCount() == 0) {
            this.focusIndex = -1;
        } else if (this.model.getSelectionIndex() == -1) {
            this.focusIndex = this.model.getItemCount() - 1;
        }
    }

    private static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    private int getItemWidth(String item) {
        Point extent = TextSizeUtil.stringExtent(this.getFont(), item, MarkupUtil.isMarkupEnabledFor(this));
        BoxDimensions itemPadding = this.getItemPadding();
        return extent.x + itemPadding.left + itemPadding.right;
    }

    private int getMaxItemWidth() {
        int result = 0;
        String[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            int itemWidth = this.getItemWidth(items[i]);
            result = Math.max(result, itemWidth);
            ++i;
        }
        return result;
    }

    private void adjustTopIndex() {
        int count = this.model.getItemCount();
        if (count == 0) {
            this.topIndex = 0;
        } else if (this.topIndex >= count - 1) {
            this.topIndex = count - 1;
        }
    }

    final int getVisibleItemCount() {
        int clientHeight = this.getBounds().height;
        if ((this.style & 0x100) != 0) {
            clientHeight -= this.getHorizontalBar().getSize().y;
        }
        int result = 0;
        if (clientHeight >= 0) {
            int itemHeight = this.getItemHeight();
            result = clientHeight / itemHeight;
        }
        return result;
    }

    Point getItemDimensions() {
        int width = 0;
        int height = 0;
        if (this.getItemCount() > 0) {
            int availableWidth = this.getClientArea().width;
            width = (this.style & 0x100) == 0 && MarkupUtil.isMarkupEnabledFor(this) ? availableWidth : Math.max(this.getMaxItemWidth(), availableWidth);
            height = this.getItemHeight();
        }
        return new Point(width, height);
    }

    private BoxDimensions getItemPadding() {
        if (this.bufferedItemPadding == null) {
            ListThemeAdapter themeAdapter = (ListThemeAdapter)this.getAdapter(ThemeAdapter.class);
            this.bufferedItemPadding = themeAdapter.getItemPadding(this);
        }
        return this.bufferedItemPadding;
    }

    private void setCustomItemHeight(Object value) {
        if (value == null) {
            this.customItemHeight = -1;
        } else {
            int itemHeight;
            if (!(value instanceof Integer)) {
                this.error(5);
            }
            if ((itemHeight = ((Integer)value).intValue()) < 0) {
                this.error(6);
            }
            this.customItemHeight = itemHeight;
        }
    }

    private void validateMarkup(String[] items) {
        if (items != null && MarkupUtil.isMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            int i = 0;
            while (i < items.length) {
                if (items[i] != null) {
                    MarkupValidator.getInstance().validate(items[i]);
                }
                ++i;
            }
        }
    }

    boolean hasVScrollBar() {
        return (this.style & 0x200) != 0 && this.hasVScrollBar;
    }

    boolean hasHScrollBar() {
        return (this.style & 0x100) != 0 && this.hasHScrollBar;
    }

    @Override
    int getVScrollBarWidth() {
        int result = 0;
        if (this.hasVScrollBar()) {
            result = this.getVerticalBar().getSize().x;
        }
        return result;
    }

    @Override
    int getHScrollBarHeight() {
        int result = 0;
        if (this.hasHScrollBar()) {
            result = this.getHorizontalBar().getSize().y;
        }
        return result;
    }

    boolean needsVScrollBar() {
        int availableHeight = this.getClientArea().height;
        int height = this.getItemCount() * this.getItemHeight();
        return height > availableHeight;
    }

    boolean needsHScrollBar() {
        boolean result = false;
        if ((this.style & 0x100) != 0) {
            int availableWidth = this.getClientArea().width;
            int width = this.getMaxItemWidth();
            result = width > availableWidth;
        }
        return result;
    }

    void updateScrollBars() {
        ScrollBar vScroll;
        ScrollBar hScroll;
        this.hasVScrollBar = false;
        this.hasHScrollBar = this.needsHScrollBar();
        if (this.needsVScrollBar()) {
            this.hasVScrollBar = true;
            this.hasHScrollBar = this.needsHScrollBar();
        }
        if ((hScroll = this.getHorizontalBar()) != null) {
            hScroll.setVisible(this.hasHScrollBar);
        }
        if ((vScroll = this.getVerticalBar()) != null) {
            vScroll.setVisible(this.hasVScrollBar);
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        @Override
        public void controlResized(ControlEvent event) {
            List.this.updateScrollBars();
        }
    }
}

