/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.canvaskit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class GCOperationWriter {
    private final Control control;
    private boolean initialized;
    private JsonArray operations;
    private int lineWidth;
    private RGB foreground;
    private RGB background;

    GCOperationWriter(Control control) {
        this.control = control;
    }

    void initialize() {
        if (!this.initialized) {
            this.lineWidth = 1;
            this.foreground = this.control.getForeground().getRGB();
            this.background = this.control.getBackground().getRGB();
            Rectangle paintRect = this.getPaintRect();
            JsonObject parameters = new JsonObject().add("x", paintRect.x).add("y", paintRect.y).add("width", paintRect.width).add("height", paintRect.height).add("font", JsonMapping.toJson(this.control.getFont())).add("fillStyle", JsonMapping.toJson(this.background)).add("strokeStyle", JsonMapping.toJson(this.foreground));
            RemoteObjectFactory.getRemoteObject(GCOperationWriter.getGcId(this.control)).call("init", parameters);
            this.operations = new JsonArray();
            this.initialized = true;
        }
    }

    void write(GCOperation operation) {
        this.initialize();
        if (operation instanceof GCOperation.DrawLine) {
            this.drawLine((GCOperation.DrawLine)operation);
        } else if (operation instanceof GCOperation.DrawPoint) {
            this.drawPoint((GCOperation.DrawPoint)operation);
        } else if (operation instanceof GCOperation.DrawRoundRectangle) {
            this.drawRoundRectangle((GCOperation.DrawRoundRectangle)operation);
        } else if (operation instanceof GCOperation.FillGradientRectangle) {
            this.fillGradientRectangle((GCOperation.FillGradientRectangle)operation);
        } else if (operation instanceof GCOperation.DrawRectangle) {
            this.drawRectangle((GCOperation.DrawRectangle)operation);
        } else if (operation instanceof GCOperation.DrawArc) {
            this.drawArc((GCOperation.DrawArc)operation);
        } else if (operation instanceof GCOperation.DrawPolyline) {
            this.drawPolyline((GCOperation.DrawPolyline)operation);
        } else if (operation instanceof GCOperation.DrawImage) {
            this.drawImage((GCOperation.DrawImage)operation);
        } else if (operation instanceof GCOperation.DrawText) {
            this.drawText((GCOperation.DrawText)operation);
        } else if (operation instanceof GCOperation.DrawPath) {
            this.drawPath((GCOperation.DrawPath)operation);
        } else if (operation instanceof GCOperation.SetProperty) {
            this.setProperty((GCOperation.SetProperty)operation);
        } else if (operation instanceof GCOperation.SetClipping) {
            this.setClipping((GCOperation.SetClipping)operation);
        } else if (operation instanceof GCOperation.SetTransform) {
            this.setTransform((GCOperation.SetTransform)operation);
        } else {
            String name = operation.getClass().getName();
            throw new IllegalArgumentException("Unsupported GCOperation: " + name);
        }
    }

    void render() {
        if (this.operations != null) {
            if (!this.operations.isEmpty()) {
                JsonObject parameters = new JsonObject().add("operations", this.operations);
                RemoteObjectFactory.getRemoteObject(GCOperationWriter.getGcId(this.control)).call("draw", parameters);
            }
            this.operations = null;
        }
    }

    private void drawLine(GCOperation.DrawLine operation) {
        float offset = this.getOffset(false);
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("moveTo", (float)operation.x1 + offset, (float)operation.y1 + offset);
        this.addClientOperation("lineTo", (float)operation.x2 + offset, (float)operation.y2 + offset);
        this.addClientOperation("stroke", new float[0]);
    }

    private void drawPoint(GCOperation.DrawPoint operation) {
        float x = operation.x;
        float y = operation.y;
        this.addClientOperation("save", new float[0]);
        this.operations.add(new JsonArray().add("fillStyle").add(JsonMapping.toJson(this.foreground)));
        this.addClientOperation("lineWidth", 1.0f);
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("rect", x, y, 1.0f, 1.0f);
        this.addClientOperation("fill", new float[0]);
        this.addClientOperation("restore", new float[0]);
    }

    private void drawRectangle(GCOperation.DrawRectangle operation) {
        float offset = this.getOffset(operation.fill);
        float x = (float)operation.x + offset;
        float y = (float)operation.y + offset;
        float width = operation.width;
        float height = operation.height;
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("rect", x, y, width, height);
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void fillGradientRectangle(GCOperation.FillGradientRectangle operation) {
        boolean vertical = operation.vertical;
        float width = operation.width;
        float height = operation.height;
        float x1 = operation.x;
        float y1 = operation.y;
        boolean swapColors = false;
        if (width < 0.0f) {
            x1 += width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0.0f) {
            y1 += height;
            if (vertical) {
                swapColors = true;
            }
        }
        RGB startColor = swapColors ? this.background : this.foreground;
        RGB endColor = swapColors ? this.foreground : this.background;
        float x2 = vertical ? x1 : x1 + Math.abs(width);
        float y2 = vertical ? y1 + Math.abs(height) : y1;
        this.addClientOperation("save", new float[0]);
        this.addClientOperation("createLinearGradient", x1, y1, x2, y2);
        this.operations.add(new JsonArray().add("addColorStop").add(0).add(JsonMapping.toJson(startColor)));
        this.operations.add(new JsonArray().add("addColorStop").add(1).add(JsonMapping.toJson(endColor)));
        this.addClientOperation("fillStyle", "linearGradient", new float[0]);
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("rect", x1, y1, width, height);
        this.addClientOperation("fill", new float[0]);
        this.addClientOperation("restore", new float[0]);
    }

    private void drawRoundRectangle(GCOperation.DrawRoundRectangle operation) {
        float offset = this.getOffset(operation.fill);
        float x = (float)operation.x + offset;
        float y = (float)operation.y + offset;
        float w = operation.width;
        float h = operation.height;
        float rx = (float)operation.arcWidth / 2.0f + 1.0f;
        float ry = (float)operation.arcHeight / 2.0f + 1.0f;
        this.addClientOperation("beginPath", new float[0]);
        this.addClientOperation("moveTo", x, y + ry);
        this.addClientOperation("lineTo", x, y + h - ry);
        this.addClientOperation("quadraticCurveTo", x, y + h, x + rx, y + h);
        this.addClientOperation("lineTo", x + w - rx, y + h);
        this.addClientOperation("quadraticCurveTo", x + w, y + h, x + w, y + h - ry);
        this.addClientOperation("lineTo", x + w, y + ry);
        this.addClientOperation("quadraticCurveTo", x + w, y, x + w - rx, y);
        this.addClientOperation("lineTo", x + rx, y);
        this.addClientOperation("quadraticCurveTo", x, y, x, y + ry);
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void drawArc(GCOperation.DrawArc operation) {
        double factor = Math.PI / 180;
        float offset = this.getOffset(operation.fill);
        float rx = operation.width / 2;
        float ry = operation.height / 2;
        float cx = (float)operation.x + rx + offset;
        float cy = (float)operation.y + ry + offset;
        float startAngle = GCOperationWriter.round((double)operation.startAngle * factor * -1.0, 4);
        float arcAngle = GCOperationWriter.round((double)operation.arcAngle * factor * -1.0, 4);
        this.addClientOperation("save", new float[0]);
        this.addClientOperation("beginPath", new float[0]);
        this.operations.add(new JsonArray().add("ellipse").add(cx).add(cy).add(rx).add(ry).add(0).add(startAngle).add(startAngle + arcAngle).add(arcAngle < 0.0f));
        if (operation.fill) {
            this.addClientOperation("closePath", new float[0]);
        }
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
        this.addClientOperation("restore", new float[0]);
    }

    private void drawPolyline(GCOperation.DrawPolyline operation) {
        int[] points = operation.points;
        float offset = this.getOffset(operation.fill);
        this.addClientOperation("beginPath", new float[0]);
        int i = 0;
        while (i < points.length) {
            if (i == 0) {
                this.addClientOperation("moveTo", (float)points[i] + offset, (float)points[i + 1] + offset);
            } else {
                this.addClientOperation("lineTo", (float)points[i] + offset, (float)points[i + 1] + offset);
            }
            i += 2;
        }
        if (operation.close && points.length > 1) {
            this.addClientOperation("lineTo", (float)points[0] + offset, (float)points[1] + offset);
        }
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void drawImage(GCOperation.DrawImage operation) {
        String path = ImageFactory.getImagePath(operation.image);
        if (operation.simple) {
            this.addClientOperation("drawImage", path, operation.destX, operation.destY);
        } else {
            this.addClientOperation("drawImage", path, operation.srcX, operation.srcY, operation.srcWidth, operation.srcHeight, operation.destX, operation.destY, operation.destWidth, operation.destHeight);
        }
    }

    private void drawText(GCOperation.DrawText operation) {
        boolean fill = (operation.flags & 1) == 0;
        boolean drawMnemonic = (operation.flags & 8) != 0;
        boolean drawDelemiter = (operation.flags & 2) != 0;
        boolean drawTab = (operation.flags & 4) != 0;
        this.operations.add(new JsonArray().add(fill ? "fillText" : "strokeText").add(operation.text).add(drawMnemonic).add(drawDelemiter).add(drawTab).add(operation.x).add(operation.y));
    }

    private void drawPath(GCOperation.DrawPath operation) {
        this.renderPath(operation.types, operation.points);
        this.addClientOperation(operation.fill ? "fill" : "stroke", new float[0]);
    }

    private void setProperty(GCOperation.SetProperty operation) {
        JsonValue value;
        String name;
        block0 : switch (operation.id) {
            case 0: {
                name = "strokeStyle";
                this.foreground = (RGB)operation.value;
                value = JsonMapping.toJson(this.foreground);
                break;
            }
            case 1: {
                name = "fillStyle";
                this.background = (RGB)operation.value;
                value = JsonMapping.toJson(this.background);
                break;
            }
            case 2: {
                float alpha = ((Integer)operation.value).floatValue();
                float globalAlpha = GCOperationWriter.round(alpha / 255.0f, 2);
                name = "globalAlpha";
                value = JsonValue.valueOf(globalAlpha);
                break;
            }
            case 3: {
                name = "lineWidth";
                int width = (Integer)operation.value;
                width = width < 1 ? 1 : width;
                value = JsonValue.valueOf(width);
                this.lineWidth = width;
                break;
            }
            case 4: {
                name = "lineCap";
                switch ((Integer)operation.value) {
                    default: {
                        value = JsonValue.valueOf("butt");
                        break block0;
                    }
                    case 2: {
                        value = JsonValue.valueOf("round");
                        break block0;
                    }
                    case 3: 
                }
                value = JsonValue.valueOf("square");
                break;
            }
            case 5: {
                name = "lineJoin";
                switch ((Integer)operation.value) {
                    default: {
                        value = JsonValue.valueOf("bevel");
                        break block0;
                    }
                    case 1: {
                        value = JsonValue.valueOf("miter");
                        break block0;
                    }
                    case 2: 
                }
                value = JsonValue.valueOf("round");
                break;
            }
            case 6: {
                name = "font";
                value = JsonMapping.toJson((FontData)operation.value);
                break;
            }
            default: {
                String msg = "Unsupported operation id: " + operation.id;
                throw new RuntimeException(msg);
            }
        }
        this.operations.add(new JsonArray().add(name).add(value));
    }

    private void setClipping(GCOperation.SetClipping operation) {
        if (operation.isReset()) {
            this.addClientOperation("restore", new float[0]);
        } else {
            this.addClientOperation("save", new float[0]);
            if (operation.isRectangular()) {
                Rectangle rect = operation.rectangle;
                this.addClientOperation("beginPath", new float[0]);
                this.addClientOperation("rect", rect.x, rect.y, rect.width, rect.height);
            } else {
                this.renderPath(operation.types, operation.points);
            }
            this.addClientOperation("clip", new float[0]);
        }
    }

    private void setTransform(GCOperation.SetTransform operation) {
        this.addClientOperation("setTransform", operation.elements);
    }

    private void renderPath(byte[] types, float[] points) {
        this.addClientOperation("beginPath", new float[0]);
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.addClientOperation("moveTo", points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.addClientOperation("lineTo", points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.addClientOperation("bezierCurveTo", points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.addClientOperation("quadraticCurveTo", points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.addClientOperation("closePath", new float[0]);
                    break;
                }
                default: {
                    String msg = "Unsupported point type: " + types[i];
                    throw new RuntimeException(msg);
                }
            }
            ++i;
        }
    }

    private void addClientOperation(String name, float ... args) {
        JsonArray operation = new JsonArray().add(name);
        int i = 0;
        while (i < args.length) {
            operation.add(args[i]);
            ++i;
        }
        this.operations.add(operation);
    }

    private void addClientOperation(String name, String argText, float ... args) {
        JsonArray operation = new JsonArray().add(name).add(argText);
        int i = 0;
        while (i < args.length) {
            operation.add(args[i]);
            ++i;
        }
        this.operations.add(operation);
    }

    private float getOffset(boolean fill) {
        float result = 0.0f;
        if (!fill && this.lineWidth % 2 != 0) {
            result = 0.5f;
        }
        return result;
    }

    private Rectangle getPaintRect() {
        Rectangle paintRect = this.control.getAdapter(GCAdapter.class).getPaintRect();
        if (paintRect == null) {
            Point size = this.control.getSize();
            paintRect = new Rectangle(0, 0, size.x, size.y);
        }
        return paintRect;
    }

    static float round(double value, int decimals) {
        int factor = (int)Math.pow(10.0, decimals);
        return (float)Math.round((double)factor * value) / (float)factor;
    }

    static String getGcId(Widget widget) {
        return String.valueOf(WidgetUtil.getId(widget)) + ".gc";
    }
}

