/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.MetadataStoreHelper;

public class ReferenceMetadata {
    public static final String CARDINALITY_0_1 = "0..1";
    public static final String CARDINALITY_0_N = "0..n";
    public static final String CARDINALITY_1_1 = "1..1";
    public static final String CARDINALITY_1_N = "1..n";
    private static final Set<String> CARDINALITY_VALID = new TreeSet<String>();
    public static final String POLICY_STATIC = "static";
    public static final String POLICY_DYNAMIC = "dynamic";
    private static final Set<String> POLICY_VALID;
    public static final String POLICY_OPTION_RELUCTANT = "reluctant";
    public static final String POLICY_OPTION_GREEDY = "greedy";
    private static final Set<String> POLICY_OPTION_VALID;
    private static final String FIELD_STRATEGY_UPDATE = "update";
    private static final String FIELD_STRATEGY_REPLACE = "replace";
    private static final Set<String> FIELD_STRATEGY_VALID;
    public static final String FIELD_VALUE_TYPE_SERVICE = "service";
    public static final String FIELD_VALUE_TYPE_PROPERTIES = "properties";
    public static final String FIELD_VALUE_TYPE_REFERENCE = "reference";
    public static final String FIELD_VALUE_TYPE_SERVICEOBJECTS = "serviceobjects";
    public static final String FIELD_VALUE_TYPE_TUPLE = "tuple";
    private static final Set<String> FIELD_VALUE_TYPE_VALID;
    private String m_name;
    private String m_interface;
    private String m_cardinality;
    private String m_target;
    private String m_bind;
    private String m_updated;
    private String m_unbind;
    private String m_field;
    private String m_field_option;
    private String m_collection_type;
    private String m_policy;
    private String m_policy_option;
    private String m_scopeName;
    private ReferenceScope m_scope = ReferenceScope.bundle;
    private String m_parameter;
    private Integer m_parameterIndex;
    private boolean m_isStatic = true;
    private boolean m_isOptional = false;
    private boolean m_isMultiple = false;
    private boolean m_isReluctant = true;
    private boolean m_isReplace = true;
    private boolean m_validated = false;

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setInterface(String interfaceName) {
        if (this.m_validated) {
            return;
        }
        this.m_interface = interfaceName;
    }

    public void setCardinality(String cardinality) {
        if (this.m_validated) {
            return;
        }
        this.m_cardinality = cardinality;
        this.m_isOptional = CARDINALITY_0_1.equals(cardinality) || CARDINALITY_0_N.equals(cardinality);
        this.m_isMultiple = CARDINALITY_0_N.equals(cardinality) || CARDINALITY_1_N.equals(cardinality);
    }

    public void setPolicy(String policy) {
        if (this.m_validated) {
            return;
        }
        this.m_policy = policy;
        this.m_isStatic = POLICY_STATIC.equals(policy);
    }

    public void setPolicyOption(String policyOption) {
        if (this.m_validated) {
            return;
        }
        this.m_policy_option = policyOption;
        this.m_isReluctant = POLICY_OPTION_RELUCTANT.equals(policyOption);
    }

    public void setTarget(String target) {
        if (this.m_validated) {
            return;
        }
        this.m_target = target == null || target.length() == 0 ? null : target;
    }

    public void setBind(String bind) {
        if (this.m_validated) {
            return;
        }
        this.m_bind = bind;
    }

    public void setUpdated(String updated) {
        if (this.m_validated) {
            return;
        }
        this.m_updated = updated;
    }

    public void setUnbind(String unbind) {
        if (this.m_validated) {
            return;
        }
        this.m_unbind = unbind;
    }

    public void setField(String field) {
        if (this.m_validated) {
            return;
        }
        this.m_field = field;
    }

    public void setFieldOption(String strategy) {
        if (this.m_validated) {
            return;
        }
        this.m_field_option = strategy;
        this.m_isReplace = FIELD_STRATEGY_REPLACE.equals(strategy);
    }

    public void setFieldCollectionType(String valuetype) {
        if (this.m_validated) {
            return;
        }
        this.m_collection_type = valuetype;
    }

    public void setScope(String scopeName) {
        if (this.m_validated) {
            return;
        }
        this.m_scopeName = scopeName;
    }

    public void setParameter(String val) {
        if (this.m_validated) {
            return;
        }
        this.m_parameter = val;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public String getCardinality() {
        return this.m_cardinality;
    }

    public String getPolicy() {
        return this.m_policy;
    }

    public String getPolicyOption() {
        return this.m_policy_option;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getBind() {
        return this.m_bind;
    }

    public String getUpdated() {
        return this.m_updated;
    }

    public String getUnbind() {
        return this.m_unbind;
    }

    public String getField() {
        return this.m_field;
    }

    public String getFieldOption() {
        return this.m_field_option;
    }

    public String getFieldCollectionType() {
        return this.m_collection_type;
    }

    public Integer getParameterIndex() {
        return this.m_parameterIndex;
    }

    public String getParameterCollectionType() {
        return this.m_collection_type;
    }

    public boolean isStatic() {
        return this.m_isStatic;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isMultiple() {
        return this.m_isMultiple;
    }

    public boolean isReluctant() {
        return this.m_isReluctant;
    }

    public boolean isReplace() {
        return this.m_isReplace;
    }

    public String getTargetPropertyName() {
        return this.getName() + ".target";
    }

    public String getMinCardinalityName() {
        return this.getName() + ".cardinality.minimum";
    }

    public ReferenceScope getScope() {
        return this.m_scope;
    }

    void validate(ComponentMetadata componentMetadata) {
        DSVersion dsVersion = componentMetadata.getDSVersion();
        if (this.m_name == null) {
            if (!dsVersion.isDS11()) {
                throw componentMetadata.validationFailure("A name must be declared for the reference");
            }
            this.setName(this.getInterface());
        }
        if (this.m_interface == null) {
            throw componentMetadata.validationFailure("An interface must be declared for the reference");
        }
        if (this.m_cardinality == null) {
            this.setCardinality(CARDINALITY_1_1);
        } else if (!CARDINALITY_VALID.contains(this.m_cardinality)) {
            throw componentMetadata.validationFailure("Cardinality must be one of " + CARDINALITY_VALID);
        }
        if (this.m_policy == null) {
            this.setPolicy(POLICY_STATIC);
        } else if (!POLICY_VALID.contains(this.m_policy)) {
            throw componentMetadata.validationFailure("Policy must be one of " + POLICY_VALID);
        }
        if (this.m_policy_option == null) {
            this.setPolicyOption(POLICY_OPTION_RELUCTANT);
        } else {
            if (!POLICY_OPTION_VALID.contains(this.m_policy_option)) {
                throw componentMetadata.validationFailure("Policy option must be one of " + POLICY_OPTION_VALID);
            }
            if (!dsVersion.isDS12() && !POLICY_OPTION_RELUCTANT.equals(this.m_policy_option)) {
                throw componentMetadata.validationFailure("Policy option must be reluctant for DS < 1.2");
            }
        }
        if (this.m_scopeName != null) {
            if (!dsVersion.isDS13()) {
                throw componentMetadata.validationFailure("reference scope can be set only for DS >= 1.3");
            }
            try {
                this.m_scope = ReferenceScope.valueOf(this.m_scopeName);
            }
            catch (IllegalArgumentException e) {
                throw componentMetadata.validationFailure("reference scope must be 'bundle' or 'prototype' not " + this.m_scopeName);
            }
        }
        if (this.m_updated != null && !dsVersion.isDS12() && dsVersion != DSVersion.DS11Felix) {
            throw componentMetadata.validationFailure("updated method declaration requires DS 1.2 or later namespace ");
        }
        if (this.m_field != null) {
            if (!dsVersion.isDS13()) {
                throw componentMetadata.validationFailure("Field reference requires DS >= 1.3");
            }
            if (this.m_field_option == null) {
                this.setFieldOption(FIELD_STRATEGY_REPLACE);
            } else if (!FIELD_STRATEGY_VALID.contains(this.m_field_option)) {
                throw componentMetadata.validationFailure("Field strategy must be one of " + FIELD_STRATEGY_VALID);
            }
            if (!this.m_isMultiple && this.m_field_option.equals(FIELD_STRATEGY_UPDATE)) {
                throw componentMetadata.validationFailure("Field strategy update not allowed for unary field references.");
            }
            if (!this.m_isMultiple) {
                if (this.m_collection_type != null) {
                    this.m_collection_type = null;
                }
            } else if (this.m_collection_type == null) {
                this.setFieldCollectionType(FIELD_VALUE_TYPE_SERVICE);
            } else if (!FIELD_VALUE_TYPE_VALID.contains(this.m_collection_type)) {
                throw componentMetadata.validationFailure("Field value type must be one of " + FIELD_VALUE_TYPE_VALID);
            }
        }
        if (this.m_parameter != null) {
            if (!dsVersion.isDS14()) {
                throw componentMetadata.validationFailure("Reference parameter requires DS >= 1.4");
            }
            try {
                this.m_parameterIndex = Integer.valueOf(this.m_parameter);
            }
            catch (NumberFormatException nfe) {
                throw componentMetadata.validationFailure("Reference parameter is not a number: " + this.m_parameter);
            }
            if (this.m_parameterIndex < 0) {
                throw componentMetadata.validationFailure("Reference parameter value must be zero or higher: " + this.m_parameter);
            }
            if (!this.m_isMultiple) {
                if (this.m_collection_type != null) {
                    this.m_collection_type = null;
                }
            } else if (this.m_collection_type == null) {
                this.setFieldCollectionType(FIELD_VALUE_TYPE_SERVICE);
            } else if (!FIELD_VALUE_TYPE_VALID.contains(this.m_collection_type)) {
                throw componentMetadata.validationFailure("Collection value type must be one of " + FIELD_VALUE_TYPE_VALID);
            }
        }
        this.m_validated = true;
    }

    public String getDebugInfo() {
        return this.getName() + "interface=" + this.getInterface() + ", filter=" + this.getTarget() + ", policy=" + this.getPolicy() + ", cardinality=" + this.getCardinality() + ", bind=" + this.getBind() + ", unbind=" + this.getUnbind() + ", updated=" + this.getUpdated() + ", field=" + this.getField() + ", field-option=" + this.getFieldOption() + ", collection-type=" + this.getFieldCollectionType() + ", parameter=" + this.getParameterIndex();
    }

    void collectStrings(Set<String> strings) {
        MetadataStoreHelper.addString(this.m_bind, strings);
        MetadataStoreHelper.addString(this.m_cardinality, strings);
        MetadataStoreHelper.addString(this.m_collection_type, strings);
        MetadataStoreHelper.addString(this.m_field, strings);
        MetadataStoreHelper.addString(this.m_field_option, strings);
        MetadataStoreHelper.addString(this.m_interface, strings);
        MetadataStoreHelper.addString(this.m_name, strings);
        MetadataStoreHelper.addString(this.m_parameter, strings);
        MetadataStoreHelper.addString(this.m_policy, strings);
        MetadataStoreHelper.addString(this.m_policy_option, strings);
        MetadataStoreHelper.addString(this.m_scopeName, strings);
        MetadataStoreHelper.addString(this.m_scope.toString(), strings);
        MetadataStoreHelper.addString(this.m_target, strings);
        MetadataStoreHelper.addString(this.m_unbind, strings);
        MetadataStoreHelper.addString(this.m_updated, strings);
    }

    void store(DataOutputStream out, MetadataStoreHelper.MetaDataWriter metaDataWriter) throws IOException {
        metaDataWriter.writeString(this.m_bind, out);
        metaDataWriter.writeString(this.m_cardinality, out);
        metaDataWriter.writeString(this.m_collection_type, out);
        metaDataWriter.writeString(this.m_field, out);
        metaDataWriter.writeString(this.m_field_option, out);
        metaDataWriter.writeString(this.m_interface, out);
        out.writeBoolean(this.m_isMultiple);
        out.writeBoolean(this.m_isOptional);
        out.writeBoolean(this.m_isReluctant);
        out.writeBoolean(this.m_isReplace);
        out.writeBoolean(this.m_isStatic);
        metaDataWriter.writeString(this.m_name, out);
        metaDataWriter.writeString(this.m_parameter, out);
        out.writeBoolean(this.m_parameterIndex != null);
        if (this.m_parameterIndex != null) {
            out.writeInt(this.m_parameterIndex);
        }
        metaDataWriter.writeString(this.m_policy, out);
        metaDataWriter.writeString(this.m_policy_option, out);
        metaDataWriter.writeString(this.m_scopeName, out);
        metaDataWriter.writeString(this.m_scope.toString(), out);
        metaDataWriter.writeString(this.m_target, out);
        metaDataWriter.writeString(this.m_unbind, out);
        metaDataWriter.writeString(this.m_updated, out);
    }

    static ReferenceMetadata load(DataInputStream in, MetadataStoreHelper.MetaDataReader metaDataReader) throws IOException {
        ReferenceMetadata result = new ReferenceMetadata();
        result.m_bind = metaDataReader.readString(in);
        result.m_cardinality = metaDataReader.readString(in);
        result.m_collection_type = metaDataReader.readString(in);
        result.m_field = metaDataReader.readString(in);
        result.m_field_option = metaDataReader.readString(in);
        result.m_interface = metaDataReader.readString(in);
        result.m_isMultiple = in.readBoolean();
        result.m_isOptional = in.readBoolean();
        result.m_isReluctant = in.readBoolean();
        result.m_isReplace = in.readBoolean();
        result.m_isStatic = in.readBoolean();
        result.m_name = metaDataReader.readString(in);
        result.m_parameter = metaDataReader.readString(in);
        if (in.readBoolean()) {
            result.m_parameterIndex = in.readInt();
        }
        result.m_policy = metaDataReader.readString(in);
        result.m_policy_option = metaDataReader.readString(in);
        result.m_scopeName = metaDataReader.readString(in);
        result.m_scope = ReferenceScope.valueOf(metaDataReader.readString(in));
        result.m_target = metaDataReader.readString(in);
        result.m_unbind = metaDataReader.readString(in);
        result.m_updated = metaDataReader.readString(in);
        result.m_validated = true;
        return result;
    }

    static {
        CARDINALITY_VALID.add(CARDINALITY_0_1);
        CARDINALITY_VALID.add(CARDINALITY_0_N);
        CARDINALITY_VALID.add(CARDINALITY_1_1);
        CARDINALITY_VALID.add(CARDINALITY_1_N);
        POLICY_VALID = new TreeSet<String>();
        POLICY_VALID.add(POLICY_DYNAMIC);
        POLICY_VALID.add(POLICY_STATIC);
        POLICY_OPTION_VALID = new TreeSet<String>();
        POLICY_OPTION_VALID.add(POLICY_OPTION_RELUCTANT);
        POLICY_OPTION_VALID.add(POLICY_OPTION_GREEDY);
        FIELD_STRATEGY_VALID = new TreeSet<String>();
        FIELD_STRATEGY_VALID.add(FIELD_STRATEGY_REPLACE);
        FIELD_STRATEGY_VALID.add(FIELD_STRATEGY_UPDATE);
        FIELD_VALUE_TYPE_VALID = new TreeSet<String>();
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_PROPERTIES);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_REFERENCE);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_SERVICE);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_SERVICEOBJECTS);
        FIELD_VALUE_TYPE_VALID.add(FIELD_VALUE_TYPE_TUPLE);
    }

    public static enum ReferenceScope {
        bundle,
        prototype,
        prototype_required;

    }
}

