/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageSerializer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.InternalImage;
import org.eclipse.swt.internal.graphics.InternalImageFactory;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public class Image
extends Resource
implements Drawable {
    public final InternalImage internalImage;

    private Image(Device device, InternalImage internalImage) {
        super(device);
        this.internalImage = internalImage;
    }

    public Image(Device device, InputStream stream) {
        super(Image.checkDevice(device));
        if (stream == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(stream);
    }

    public Image(Device device, String fileName) {
        super(Image.checkDevice(device));
        if (fileName == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(fileName);
    }

    public Image(Device device, Image srcImage, int flag) {
        super(Image.checkDevice(device));
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = srcImage.getBounds();
        switch (flag) {
            case 0: {
                this.internalImage = srcImage.internalImage;
                break;
            }
            case 1: {
                ImageData data = srcImage.getImageData();
                PaletteData palette = data.palette;
                RGB[] rgbs = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                newData.alpha = data.alpha;
                newData.alphaData = data.alphaData;
                newData.maskData = data.maskData;
                newData.maskPad = data.maskPad;
                if (data.transparentPixel != -1) {
                    newData.transparentPixel = 0;
                }
                int[] scanline = new int[rect.width];
                int[] maskScanline = null;
                ImageData mask = null;
                if (data.maskData != null) {
                    mask = data.getTransparencyMask();
                }
                if (mask != null) {
                    maskScanline = new int[rect.width];
                }
                int redMask = palette.redMask;
                int greenMask = palette.greenMask;
                int blueMask = palette.blueMask;
                int redShift = palette.redShift;
                int greenShift = palette.greenShift;
                int blueShift = palette.blueShift;
                int y = 0;
                while (y < rect.height) {
                    int offset = y * newData.bytesPerLine;
                    data.getPixels(0, y, rect.width, scanline, 0);
                    if (mask != null) {
                        mask.getPixels(0, y, rect.width, maskScanline, 0);
                    }
                    int x = 0;
                    while (x < rect.width) {
                        int pixel = scanline[x];
                        if (!(data.transparentPixel != -1 && pixel == data.transparentPixel || mask != null && maskScanline[x] == 0)) {
                            int blue;
                            int green;
                            int red;
                            if (palette.isDirect) {
                                red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                            } else {
                                red = palette.colors[pixel].red;
                                green = palette.colors[pixel].green;
                                blue = palette.colors[pixel].blue;
                            }
                            int intensity = red * red + green * green + blue * blue;
                            newData.data[offset] = intensity < 98304 ? 1 : 2;
                        }
                        ++offset;
                        ++x;
                    }
                    ++y;
                }
                this.internalImage = Image.findInternalImage(newData);
                break;
            }
            case 2: {
                ImageData data = srcImage.getImageData();
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    int i = 0;
                    while (i < rgbs.length) {
                        if (data.transparentPixel != i) {
                            int intensity;
                            RGB color = rgbs[i];
                            int red = color.red;
                            int green = color.green;
                            int blue = color.blue;
                            color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                            color.red = color.blue;
                        }
                        ++i;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    int i = 0;
                    while (i < rgbs.length) {
                        rgbs[i] = new RGB(i, i, i);
                        ++i;
                    }
                    newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                    newData.alpha = data.alpha;
                    newData.alphaData = data.alphaData;
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    if (data.transparentPixel != -1) {
                        newData.transparentPixel = 254;
                    }
                    int[] scanline = new int[rect.width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    int y = 0;
                    while (y < rect.height) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, rect.width, scanline, 0);
                        int x = 0;
                        while (x < rect.width) {
                            int pixel = scanline[x];
                            if (pixel != data.transparentPixel) {
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                int intensity = red + red + green + green + green + green + green + blue >> 3;
                                if (newData.transparentPixel == intensity) {
                                    intensity = 255;
                                }
                                newData.data[offset] = (byte)intensity;
                            } else {
                                newData.data[offset] = -2;
                            }
                            ++offset;
                            ++x;
                        }
                        ++y;
                    }
                }
                this.internalImage = Image.findInternalImage(newData);
                break;
            }
            default: {
                this.internalImage = null;
                SWT.error(5);
            }
        }
    }

    public Image(Device device, ImageData imageData) {
        super(Image.checkDevice(device));
        if (imageData == null) {
            SWT.error(4);
        }
        this.internalImage = Image.findInternalImage(imageData);
    }

    public Image(Device device, int width, int height) {
        super(Image.checkDevice(device));
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        Color white = device.getSystemColor(1);
        PaletteData palette = new PaletteData(white.getRGB());
        ImageData imageData = new ImageData(width, height, 8, palette);
        this.internalImage = Image.findInternalImage(imageData);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.internalImage.getBounds();
    }

    public ImageData getImageData() {
        ImageData result;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.device != null) {
            ApplicationContextImpl applicationContext = this.getApplicationContext();
            result = applicationContext.getImageDataFactory().findImageData(this.internalImage);
        } else {
            result = this.internalImage.getImageData();
        }
        return result;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.device == null) {
            throw new NotSerializableException(this.getClass().getName());
        }
        new ImageSerializer(this).writeObject(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        new ImageSerializer(this).readObject(stream);
    }

    private ApplicationContextImpl getApplicationContext() {
        Display display = (Display)this.device;
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return (ApplicationContextImpl)adapter.getUISession().getApplicationContext();
    }

    private static InternalImage findInternalImage(ImageData imageData) {
        return Image.getInternalImageFactory().findInternalImage(imageData);
    }

    private static InternalImage findInternalImage(InputStream stream) {
        return Image.getInternalImageFactory().findInternalImage(stream);
    }

    private static InternalImage findInternalImage(String fileName) {
        return Image.getInternalImageFactory().findInternalImage(fileName);
    }

    private static InternalImageFactory getInternalImageFactory() {
        return ContextProvider.getApplicationContext().getInternalImageFactory();
    }
}

