/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.ContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.widgets.Display;

final class UIThread
extends Thread
implements IUIThreadHolder,
ISessionShutdownAdapter {
    private ServiceContext serviceContext;
    private UISession uiSession;
    private Runnable shutdownCallback;
    private volatile boolean uiThreadTerminating;

    public UIThread(Runnable runnable) {
        super(runnable);
    }

    @Override
    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    @Override
    public void updateServiceContext() {
        if (ContextProvider.hasContext()) {
            ContextProvider.releaseContextHolder();
        }
        ContextProvider.setContext(this.serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchThread() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.checkAndReportTerminatedUIThread();
            lock.notifyAll();
            boolean done = false;
            while (!done) {
                try {
                    lock.wait();
                    done = true;
                }
                catch (InterruptedException e) {
                    this.handleInterruptInSwitchThread(e);
                }
            }
        }
    }

    private void checkAndReportTerminatedUIThread() {
        if (!this.getThread().isAlive()) {
            String msg = "Thread '" + Thread.currentThread() + "' is waiting for already terminated UIThread";
            ServletLog.log("", new RuntimeException(msg));
        }
    }

    private void handleInterruptInSwitchThread(InterruptedException e) throws UIThreadTerminatedError {
        Thread.interrupted();
        if (this.uiThreadTerminating) {
            this.updateServiceContext();
            CurrentPhase.set(PhaseId.PROCESS_ACTION);
            this.uiThreadTerminating = false;
            throw new UIThreadTerminatedError();
        }
        if (Thread.currentThread() != this.getThread()) {
            String msg = "Received InterruptedException on request thread";
            ServletLog.log(msg, e);
        }
    }

    @Override
    public void run() {
        super.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateThread() {
        ServiceContext serviceContext = ContextUtil.createFakeContext(this.uiSession);
        this.setServiceContext(serviceContext);
        this.uiThreadTerminating = true;
        Object object = this.getLock();
        synchronized (object) {
            this.getThread().interrupt();
        }
        try {
            this.getThread().join();
        }
        catch (InterruptedException e) {
            String msg = "Received InterruptedException while terminating UIThread";
            ServletLog.log(msg, e);
        }
        this.uiThreadTerminating = false;
    }

    @Override
    public Thread getThread() {
        return this;
    }

    @Override
    public Object getLock() {
        return this;
    }

    @Override
    public void setUISession(UISession uiSession) {
        this.uiSession = uiSession;
    }

    @Override
    public void setShutdownCallback(Runnable shutdownCallback) {
        this.shutdownCallback = shutdownCallback;
    }

    @Override
    public void interceptShutdown() {
        this.terminateThread();
    }

    @Override
    public void processShutdown() {
        this.updateServiceContext();
        try {
            CurrentPhase.set(PhaseId.PROCESS_ACTION);
            Display display = LifeCycleUtil.getSessionDisplay(this.uiSession);
            if (this.isApplicationContextActive() && display != null) {
                display.dispose();
            }
            this.shutdownCallback.run();
        }
        finally {
            ContextProvider.disposeContext();
        }
    }

    private boolean isApplicationContextActive() {
        ApplicationContextImpl applicationContext = ((UISessionImpl)this.uiSession).getApplicationContext();
        return applicationContext != null && applicationContext.isActive();
    }

    static final class UIThreadTerminatedError
    extends ThreadDeath {
        private static final long serialVersionUID = 1L;

        UIThreadTerminatedError() {
        }
    }
}

