/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.resource.Resource;

public interface Context
extends Attributes,
Decorator,
Executor {
    public String getContextPath();

    public ClassLoader getClassLoader();

    public Resource getBaseResource();

    public Request.Handler getErrorHandler();

    public List<String> getVirtualHosts();

    public MimeTypes getMimeTypes();

    @Override
    public void execute(Runnable var1);

    public void run(Runnable var1);

    public void run(Runnable var1, Request var2);

    default public String getPathInContext(String canonicallyEncodedPath) {
        return Context.getPathInContext(this.getContextPath(), canonicallyEncodedPath);
    }

    public File getTempDirectory();

    public static String getPathInContext(String encodedContextPath, String encodedPath) {
        if (encodedContextPath.length() == 0 || "/".equals(encodedContextPath)) {
            return encodedPath;
        }
        if (encodedContextPath.length() > encodedPath.length() || !encodedPath.startsWith(encodedContextPath)) {
            return null;
        }
        if (encodedPath.length() == encodedContextPath.length()) {
            return "";
        }
        if (encodedPath.charAt(encodedContextPath.length()) != '/') {
            return null;
        }
        return encodedPath.substring(encodedContextPath.length());
    }
}

