/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.util.ResourceBundle;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.osgi.service.log.LogService;

public class BundleTranslationProvider
extends TranslationService {
    @Inject
    ResourceBundleProvider provider;
    @Inject
    @Optional
    LogService logService;

    @Override
    public String translate(String key, String contributorURI) {
        if (this.provider == null) {
            return key;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundleForUri(contributorURI, this.locale, this.provider);
            return this.getResourceString(key, resourceBundle);
        }
        catch (Exception e) {
            if (this.logService != null) {
                this.logService.log(1, "Error retrieving the translation for key=" + key + " and contributorURI=" + contributorURI, (Throwable)e);
            }
            return key;
        }
    }
}

