/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.canvaskit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.widgets.canvaskit.CanvasOperationHandler;
import org.eclipse.swt.internal.widgets.canvaskit.GCOperationWriter;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public final class CanvasLCA
extends WidgetLCA<Canvas> {
    public static final CanvasLCA INSTANCE = new CanvasLCA();
    private static final String TYPE = "rwt.widgets.Canvas";
    private static final String TYPE_GC = "rwt.widgets.GC";
    private static final String[] ALLOWED_STYLES = new String[]{"NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_CLIENT_AREA = "clientArea";

    @Override
    public void preserveValues(Canvas canvas) {
        WidgetLCAUtil.preserveBackgroundGradient(canvas);
        WidgetLCAUtil.preserveRoundedBorder(canvas);
        WidgetLCAUtil.preserveProperty((Widget)canvas, PROP_CLIENT_AREA, canvas.getClientArea());
    }

    @Override
    public void renderInitialization(Canvas canvas) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(canvas, TYPE);
        remoteObject.setHandler(new CanvasOperationHandler(canvas));
        remoteObject.set("parent", WidgetUtil.getId(canvas.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(canvas, ALLOWED_STYLES)));
        RemoteObject remoteObjectForGC = RemoteObjectFactory.createRemoteObject(GCOperationWriter.getGcId(canvas), TYPE_GC);
        remoteObjectForGC.set("parent", WidgetUtil.getId(canvas));
    }

    @Override
    public void renderChanges(Canvas canvas) throws IOException {
        ControlLCAUtil.renderChanges(canvas);
        WidgetLCAUtil.renderBackgroundGradient(canvas);
        WidgetLCAUtil.renderRoundedBorder(canvas);
        WidgetLCAUtil.renderCustomVariant(canvas);
        CanvasLCA.renderClientArea(canvas);
        CanvasLCA.writeGCOperations(canvas);
        WidgetLCAUtil.renderClientListeners(canvas);
    }

    private static void writeGCOperations(Canvas canvas) {
        GCAdapter adapter = canvas.getAdapter(GCAdapter.class);
        GCOperation[] operations = adapter.getTrimmedGCOperations();
        if (operations.length > 0 || adapter.getForceRedraw()) {
            GCOperationWriter operationWriter = new GCOperationWriter(canvas);
            operationWriter.initialize();
            int i = 0;
            while (i < operations.length) {
                operationWriter.write(operations[i]);
                ++i;
            }
            operationWriter.render();
        }
        adapter.clearGCOperations();
        adapter.setForceRedraw(false);
    }

    public static void renderClientArea(Canvas canvas) {
        WidgetLCAUtil.renderProperty((Widget)canvas, PROP_CLIENT_AREA, canvas.getClientArea(), null);
    }

    private CanvasLCA() {
    }
}

