/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanListProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanMapProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanSetProperty;
import org.eclipse.core.internal.databinding.beans.AnonymousBeanValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanListProperty;
import org.eclipse.core.internal.databinding.beans.BeanListPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanMapProperty;
import org.eclipse.core.internal.databinding.beans.BeanMapPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanSetProperty;
import org.eclipse.core.internal.databinding.beans.BeanSetPropertyDecorator;
import org.eclipse.core.internal.databinding.beans.BeanValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanValuePropertyDecorator;

public class BeanProperties {
    public static IBeanValueProperty value(String propertyName) {
        return BeanProperties.value(null, propertyName, null);
    }

    public static IBeanValueProperty value(String propertyName, Class valueType) {
        return BeanProperties.value(null, propertyName, valueType);
    }

    public static IBeanValueProperty value(Class beanClass, String propertyName) {
        return BeanProperties.value(beanClass, propertyName, null);
    }

    public static IBeanValueProperty value(Class beanClass, String propertyName, Class valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        String[] propertyNames = BeanProperties.split(propertyName);
        if (propertyNames.length > 1) {
            valueType = null;
        }
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanValueProperty(propertyNames[0], valueType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyNames[0]);
            property = new BeanValueProperty(propertyDescriptor, valueType);
        }
        IBeanValueProperty beanProperty = new BeanValuePropertyDecorator((IValueProperty)property, propertyDescriptor);
        int i = 1;
        while (i < propertyNames.length) {
            beanProperty = beanProperty.value(propertyNames[i]);
            ++i;
        }
        return beanProperty;
    }

    private static String[] split(String propertyName) {
        int index;
        if (propertyName.indexOf(46) == -1) {
            return new String[]{propertyName};
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        while ((index = propertyName.indexOf(46)) != -1) {
            propertyNames.add(propertyName.substring(0, index));
            propertyName = propertyName.substring(index + 1);
        }
        propertyNames.add(propertyName);
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    public static IBeanValueProperty[] values(Class beanClass, String ... propertyNames) {
        IBeanValueProperty[] properties = new IBeanValueProperty[propertyNames.length];
        int i = 0;
        while (i < properties.length) {
            properties[i] = BeanProperties.value(beanClass, propertyNames[i], null);
            ++i;
        }
        return properties;
    }

    public static IBeanValueProperty[] values(String ... propertyNames) {
        return BeanProperties.values(null, propertyNames);
    }

    public static IBeanSetProperty set(String propertyName) {
        return BeanProperties.set(null, propertyName, null);
    }

    public static IBeanSetProperty set(String propertyName, Class elementType) {
        return BeanProperties.set(null, propertyName, elementType);
    }

    public static IBeanSetProperty set(Class beanClass, String propertyName) {
        return BeanProperties.set(beanClass, propertyName, null);
    }

    public static IBeanSetProperty set(Class beanClass, String propertyName, Class elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanSetProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanSetProperty(propertyDescriptor, elementType);
        }
        return new BeanSetPropertyDecorator((ISetProperty)property, propertyDescriptor);
    }

    public static IBeanListProperty list(String propertyName) {
        return BeanProperties.list(null, propertyName, null);
    }

    public static IBeanListProperty list(String propertyName, Class elementType) {
        return BeanProperties.list(null, propertyName, elementType);
    }

    public static IBeanListProperty list(Class beanClass, String propertyName) {
        return BeanProperties.list(beanClass, propertyName, null);
    }

    public static IBeanListProperty list(Class beanClass, String propertyName, Class elementType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanListProperty(propertyName, elementType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanListProperty(propertyDescriptor, elementType);
        }
        return new BeanListPropertyDecorator((IListProperty)property, propertyDescriptor);
    }

    public static IBeanMapProperty map(String propertyName) {
        return BeanProperties.map(null, propertyName, null, null);
    }

    public static IBeanMapProperty map(String propertyName, Class keyType, Class valueType) {
        return BeanProperties.map(null, propertyName, keyType, valueType);
    }

    public static IBeanMapProperty map(Class beanClass, String propertyName) {
        return BeanProperties.map(beanClass, propertyName, null, null);
    }

    public static IBeanMapProperty map(Class beanClass, String propertyName, Class keyType, Class valueType) {
        Object property;
        PropertyDescriptor propertyDescriptor;
        if (beanClass == null) {
            propertyDescriptor = null;
            property = new AnonymousBeanMapProperty(propertyName, keyType, valueType);
        } else {
            propertyDescriptor = BeanPropertyHelper.getPropertyDescriptor(beanClass, propertyName);
            property = new BeanMapProperty(propertyDescriptor, keyType, valueType);
        }
        return new BeanMapPropertyDecorator((IMapProperty)property, propertyDescriptor);
    }
}

