/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.util.BooleanPlus;
import org.eclipse.equinox.http.servlet.internal.util.ServiceProperties;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;

public class ContextFilterTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Filter, AtomicReference<FilterRegistration>> {
    private ContextController contextController;

    public ContextFilterTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<FilterRegistration> addingService(ServiceReference<Filter> serviceReference) {
        AtomicReference<FilterRegistration> result = new AtomicReference<FilterRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            if (!this.contextController.matches(serviceReference)) {
                if (this.httpServiceRuntime.isDefaultContext(this.contextController) && !this.httpServiceRuntime.matchesAnyContext(serviceReference)) {
                    throw new HttpWhiteboardFailureException("Doesn't match any contexts. " + serviceReference, 1);
                }
                return result;
            }
            this.httpServiceRuntime.removeFailedFilterDTO(serviceReference);
            result.set(this.contextController.addFilterRegistration(serviceReference));
        }
        catch (HttpWhiteboardFailureException hwfe) {
            this.httpServiceRuntime.log(hwfe.getMessage(), hwfe);
            this.recordFailedFilterDTO(serviceReference, hwfe.getFailureReason());
        }
        catch (Exception e) {
            this.httpServiceRuntime.log(e.getMessage(), e);
            this.recordFailedFilterDTO(serviceReference, 4);
        }
        return result;
    }

    public void modifiedService(ServiceReference<Filter> serviceReference, AtomicReference<FilterRegistration> filterReference) {
        this.removedService(serviceReference, filterReference);
        Object added = this.addingService((ServiceReference)serviceReference);
        filterReference.set((FilterRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Filter> serviceReference, AtomicReference<FilterRegistration> filterReference) {
        FilterRegistration registration = filterReference.get();
        if (registration != null) {
            registration.destroy();
        }
        this.contextController.getHttpServiceRuntime().removeFailedFilterDTO(serviceReference);
    }

    private void recordFailedFilterDTO(ServiceReference<Filter> serviceReference, int failureReason) {
        FailedFilterDTO failedFilterDTO = new FailedFilterDTO();
        failedFilterDTO.asyncSupported = BooleanPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.asyncSupported"), false);
        failedFilterDTO.dispatcher = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.dispatcher")).toArray(new String[0]);
        failedFilterDTO.failureReason = failureReason;
        failedFilterDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "filter.init.");
        failedFilterDTO.name = (String)serviceReference.getProperty("osgi.http.whiteboard.filter.name");
        failedFilterDTO.patterns = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.pattern")).toArray(new String[0]);
        failedFilterDTO.regexs = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.regex")).toArray(new String[0]);
        failedFilterDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedFilterDTO.servletContextId = this.contextController.getServiceId();
        failedFilterDTO.servletNames = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.servlet")).toArray(new String[0]);
        this.contextController.getHttpServiceRuntime().recordFailedFilterDTO(serviceReference, failedFilterDTO);
    }
}

