/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrencyTestUtil {
    public static void runInThread(final Runnable runnable) throws Throwable {
        final AtomicReference exception = new AtomicReference();
        Runnable exceptionGuard = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    exception.set(throwable);
                }
            }
        };
        Thread thread = new Thread(exceptionGuard);
        thread.setDaemon(true);
        thread.start();
        thread.join();
        if (exception.get() != null) {
            throw (Throwable)exception.get();
        }
    }

    public static Thread[] startThreads(int threadCount, Runnable runnable) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < threadCount) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.start();
            threads.add(thread);
            Thread.yield();
            ++i;
        }
        Thread[] result = new Thread[threads.size()];
        threads.toArray(result);
        return result;
    }

    public static void joinThreads(Thread[] threads) throws InterruptedException {
        int i = 0;
        while (i < threads.length) {
            Thread thread = threads[i];
            thread.join();
            ++i;
        }
    }
}

