/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.internal.widgets.Decorator;
import org.eclipse.swt.internal.widgets.ICompositeAdapter;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.ItemProvider;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public class WidgetTreeUtil {
    public static void accept(Widget root, WidgetTreeVisitor visitor) {
        if (visitor.visit(root)) {
            if (root instanceof Composite) {
                Composite composite = (Composite)root;
                WidgetTreeUtil.handleMenus(composite, visitor);
                WidgetTreeUtil.handleDragDrop(root, visitor);
                WidgetTreeUtil.handleDecorator(root, visitor);
                WidgetTreeUtil.handleItems(root, visitor);
                WidgetTreeUtil.handleScrollBars(root, visitor);
                WidgetTreeUtil.handleChildren(composite, visitor);
                WidgetTreeUtil.handleToolTips(root, visitor);
            } else {
                WidgetTreeUtil.handleDragDrop(root, visitor);
                WidgetTreeUtil.handleDecorator(root, visitor);
                WidgetTreeUtil.handleItems(root, visitor);
                WidgetTreeUtil.handleScrollBars(root, visitor);
            }
        }
    }

    private static void handleMenus(Composite composite, WidgetTreeVisitor visitor) {
        MenuHolder menuHolder = composite.getAdapter(MenuHolder.class);
        if (menuHolder != null) {
            for (Menu menu : menuHolder) {
                WidgetTreeUtil.accept(menu, visitor);
            }
        }
    }

    private static void handleDragDrop(Widget widget, WidgetTreeVisitor visitor) {
        if (widget instanceof Control) {
            Widget dropTarget;
            Widget dragSource = (Widget)widget.getData("DragSource");
            if (dragSource != null) {
                visitor.visit(dragSource);
            }
            if ((dropTarget = (Widget)widget.getData("DropTarget")) != null) {
                visitor.visit(dropTarget);
            }
        }
    }

    private static void handleDecorator(Widget root, WidgetTreeVisitor visitor) {
        Decorator[] decorators;
        Decorator[] decoratorArray = decorators = Decorator.getDecorators(root);
        int n = decorators.length;
        int n2 = 0;
        while (n2 < n) {
            Decorator decorator = decoratorArray[n2];
            visitor.visit(decorator);
            ++n2;
        }
    }

    private static void handleItems(Widget root, WidgetTreeVisitor visitor) {
        ItemProvider itemProvider = root.getAdapter(ItemProvider.class);
        if (itemProvider != null) {
            itemProvider.provideItems(visitor);
        } else {
            IItemHolderAdapter itemHolder = root.getAdapter(IItemHolderAdapter.class);
            if (itemHolder != null) {
                Item[] itemArray = itemHolder.getItems();
                int n = itemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    WidgetTreeUtil.accept(item, visitor);
                    ++n2;
                }
            }
        }
    }

    private static void handleScrollBars(Widget root, WidgetTreeVisitor visitor) {
        if (root instanceof Scrollable) {
            ScrollBar verticalBar;
            Scrollable scrollable = (Scrollable)root;
            ScrollBar horizontalBar = scrollable.getHorizontalBar();
            if (horizontalBar != null && horizontalBar.getParent() == scrollable) {
                WidgetTreeUtil.accept(horizontalBar, visitor);
            }
            if ((verticalBar = scrollable.getVerticalBar()) != null && verticalBar.getParent() == scrollable) {
                WidgetTreeUtil.accept(verticalBar, visitor);
            }
        }
    }

    private static void handleChildren(Composite composite, WidgetTreeVisitor visitor) {
        ICompositeAdapter adapter = composite.getAdapter(ICompositeAdapter.class);
        for (Control child : adapter.getChildren()) {
            WidgetTreeUtil.accept(child, visitor);
        }
    }

    private static void handleToolTips(Widget root, WidgetTreeVisitor visitor) {
        IShellAdapter adapter = root.getAdapter(IShellAdapter.class);
        if (adapter != null) {
            ToolTip[] toolTips;
            ToolTip[] toolTipArray = toolTips = adapter.getToolTips();
            int n = toolTips.length;
            int n2 = 0;
            while (n2 < n) {
                ToolTip toolTip = toolTipArray[n2];
                visitor.visit(toolTip);
                ++n2;
            }
        }
    }
}

