/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.AdaptableForwarder;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.PropertyPageNode;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RegistryPageContributor
implements IPropertyPageContributor,
IAdaptable,
IPluginContribution {
    private static final String CHILD_ENABLED_WHEN = "enabledWhen";
    private String pageId;
    private Collection subPages = new ArrayList();
    private boolean adaptable = false;
    private IConfigurationElement pageElement;
    private SoftReference filterProperties;
    private Expression enablementExpression;

    public RegistryPageContributor(String pageId, IConfigurationElement element) {
        this.pageId = pageId;
        this.pageElement = element;
        this.adaptable = Boolean.valueOf(this.pageElement.getAttribute("adaptable"));
        this.initializeEnablement(element);
    }

    @Override
    public PreferenceNode contributePropertyPage(PropertyPageManager mng, Object element) {
        PropertyPageNode node = new PropertyPageNode(this, element);
        if ("org.eclipse.rap.ui.propertypages.info.file".equals(node.getId())) {
            node.setPriority(-1);
        }
        return node;
    }

    public IWorkbenchPropertyPage createPage(Object element) throws CoreException {
        IWorkbenchPropertyPage ppage = null;
        ppage = (IWorkbenchPropertyPage)WorkbenchPlugin.createExtension(this.pageElement, "class");
        ppage.setTitle(this.getPageName());
        Object adapted = element;
        if (this.adaptable && (adapted = this.getAdaptedElement(element)) == null) {
            String message = "Error adapting selection to Property page " + this.pageId + " is being ignored";
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, message, null));
        }
        if (adapted instanceof IAdaptable) {
            ppage.setElement((IAdaptable)adapted);
        } else {
            ppage.setElement(new AdaptableForwarder(adapted));
        }
        return ppage;
    }

    private Object getAdaptedElement(Object element) {
        Object adapted = LegacyResourceSupport.getAdapter(element, this.getObjectClass());
        if (adapted != null) {
            return adapted;
        }
        return null;
    }

    public String getObjectClass() {
        return this.pageElement.getAttribute("objectClass");
    }

    public ImageDescriptor getPageIcon() {
        String iconName = this.pageElement.getAttribute("icon");
        if (iconName == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin(this.pageElement.getNamespaceIdentifier(), iconName);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPageName() {
        return this.pageElement.getAttribute("name");
    }

    @Override
    public boolean isApplicableTo(Object object) {
        if (this.failsEnablement(object)) {
            return false;
        }
        String nameFilter = this.pageElement.getAttribute("nameFilter");
        if (nameFilter != null) {
            String elementName;
            String objectName = object.toString();
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)Util.getAdapter(object, IWorkbenchAdapter.class);
            if (adapter != null && (elementName = adapter.getLabel(object)) != null) {
                objectName = elementName;
            }
            if (!SelectionEnabler.verifyNameMatch(objectName, nameFilter)) {
                return false;
            }
        }
        if (this.getFilterProperties() == null) {
            return true;
        }
        IActionFilter filter = null;
        Object adaptedObject = LegacyResourceSupport.getAdaptedResource(object);
        if (adaptedObject != null) {
            object = adaptedObject;
        }
        if ((filter = (IActionFilter)Util.getAdapter(object, IActionFilter.class)) != null) {
            return this.testCustom(object, filter);
        }
        return true;
    }

    private boolean failsEnablement(Object object) {
        if (this.enablementExpression == null) {
            return false;
        }
        try {
            EvaluationContext context = new EvaluationContext(null, object);
            context.setAllowPluginActivation(true);
            return this.enablementExpression.evaluate((IEvaluationContext)context).equals(EvaluationResult.FALSE);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(e);
            return false;
        }
    }

    protected void initializeEnablement(IConfigurationElement definingElement) {
        IConfigurationElement[] elements = definingElement.getChildren(CHILD_ENABLED_WHEN);
        if (elements.length == 0) {
            return;
        }
        try {
            IConfigurationElement[] enablement = elements[0].getChildren();
            if (enablement.length == 0) {
                return;
            }
            this.enablementExpression = ExpressionConverter.getDefault().perform(enablement[0]);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(e);
        }
    }

    private boolean testCustom(Object object, IActionFilter filter) {
        Map filterProperties = this.getFilterProperties();
        if (filterProperties == null) {
            return false;
        }
        for (String key : filterProperties.keySet()) {
            String value;
            if (filter.testAttribute(object, key, value = (String)filterProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canAdapt() {
        return this.adaptable;
    }

    public String getCategory() {
        return this.pageElement.getAttribute("category");
    }

    public Collection getSubPages() {
        return this.subPages;
    }

    public void addSubPage(RegistryPageContributor child) {
        this.subPages.add(child);
    }

    private Map getFilterProperties() {
        if (this.filterProperties == null || this.filterProperties.get() == null) {
            HashMap map = new HashMap();
            this.filterProperties = new SoftReference(map);
            IConfigurationElement[] children = this.pageElement.getChildren();
            int i = 0;
            while (i < children.length) {
                this.processChildElement(map, children[i]);
                ++i;
            }
        }
        return (Map)this.filterProperties.get();
    }

    public Object getChild(String id) {
        for (RegistryPageContributor next : this.subPages) {
            if (!next.getPageId().equals(id)) continue;
            return next;
        }
        return null;
    }

    private void processChildElement(Map map, IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("filter")) {
            String key = element.getAttribute("name");
            String value = element.getAttribute("value");
            if (key == null || value == null) {
                return;
            }
            map.put(key, value);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IConfigurationElement.class)) {
            return this.getConfigurationElement();
        }
        return null;
    }

    IConfigurationElement getConfigurationElement() {
        return this.pageElement;
    }

    @Override
    public String getLocalId() {
        return this.pageId;
    }

    @Override
    public String getPluginId() {
        return this.pageElement.getContributor().getName();
    }
}

