/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.WindowSelectionService;
import org.eclipse.ui.internal.WorkbenchPage;

public class WWinPartService
implements IPartService {
    private PartService partService = new PartService("org.eclipse.rap.ui/listeners/IWorkbenchWindow.IPartListener", "org.eclipse.rap.ui/listeners/IWorkbenchWindow.IPartListener2");
    private WindowSelectionService selectionService;
    private IWorkbenchPage activePage;
    private IPartListener2 partListner = new WWinListener();

    public WWinPartService(IWorkbenchWindow window) {
        this.selectionService = new WindowSelectionService(window);
    }

    @Override
    public void addPartListener(IPartListener l) {
        this.partService.addPartListener(l);
    }

    @Override
    public void addPartListener(IPartListener2 l) {
        this.partService.addPartListener(l);
    }

    @Override
    public void removePartListener(IPartListener l) {
        this.partService.removePartListener(l);
    }

    @Override
    public void removePartListener(IPartListener2 l) {
        this.partService.removePartListener(l);
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.partService.getActivePart();
    }

    private void updateActivePart() {
        IWorkbenchPartReference activeRef = null;
        IWorkbenchPart activePart = null;
        if (this.activePage != null) {
            activePart = this.activePage.getActivePart();
            activeRef = this.activePage.getActivePartReference();
        }
        this.selectionService.setActivePart(activePart);
        this.partService.setActivePart(activeRef);
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        return this.partService.getActivePartReference();
    }

    ISelectionService getSelectionService() {
        return this.selectionService;
    }

    void pageActivated(IWorkbenchPage newPage) {
        if (newPage == this.activePage) {
            return;
        }
        if (newPage != null) {
            IWorkbenchPartReference[] refs = ((WorkbenchPage)newPage).getOpenParts();
            int i = 0;
            while (i < refs.length) {
                IWorkbenchPartReference reference = refs[i];
                this.partService.firePartOpened(reference);
                IWorkbenchPart part = reference.getPart(false);
                if (part != null && newPage.isPartVisible(part)) {
                    this.partService.firePartVisible(reference);
                }
                ++i;
            }
            this.partService.setActivePart(newPage.getActivePartReference());
            this.selectionService.setActivePart(newPage.getActivePart());
        } else {
            this.partService.setActivePart(null);
            this.selectionService.setActivePart(null);
        }
        this.reset();
        this.activePage = newPage;
        if (newPage != null) {
            newPage.addPartListener(this.partListner);
        }
    }

    void pageClosed(IWorkbenchPage page) {
        if (page == this.activePage) {
            this.reset();
        }
    }

    void pageOpened(IWorkbenchPage page) {
        this.pageActivated(page);
    }

    private void reset() {
        IWorkbenchPage tempPage = this.activePage;
        this.activePage = null;
        if (tempPage != null) {
            WorkbenchPage page = (WorkbenchPage)tempPage;
            IWorkbenchPartReference[] refs = page.getOpenParts();
            int i = 0;
            while (i < refs.length) {
                IWorkbenchPartReference reference = refs[i];
                if (page.isPartVisible(reference)) {
                    this.partService.firePartHidden(reference);
                }
                this.partService.firePartClosed(reference);
                ++i;
            }
            tempPage.removePartListener(this.partListner);
        }
    }

    private class WWinListener
    implements IPartListener2,
    IPageChangedListener {
        private WWinListener() {
        }

        @Override
        public void partActivated(IWorkbenchPartReference ref) {
            WWinPartService.this.updateActivePart();
        }

        @Override
        public void partBroughtToTop(IWorkbenchPartReference ref) {
            WWinPartService.this.partService.firePartBroughtToTop(ref);
        }

        @Override
        public void partClosed(IWorkbenchPartReference ref) {
            WWinPartService.this.partService.firePartClosed(ref);
        }

        @Override
        public void partDeactivated(IWorkbenchPartReference ref) {
            WWinPartService.this.updateActivePart();
        }

        @Override
        public void partOpened(IWorkbenchPartReference ref) {
            WWinPartService.this.partService.firePartOpened(ref);
        }

        @Override
        public void partHidden(IWorkbenchPartReference ref) {
            WWinPartService.this.partService.firePartHidden(ref);
        }

        @Override
        public void partVisible(IWorkbenchPartReference ref) {
            WWinPartService.this.partService.firePartVisible(ref);
        }

        @Override
        public void partInputChanged(IWorkbenchPartReference ref) {
            WWinPartService.this.partService.firePartInputChanged(ref);
        }

        public void pageChanged(PageChangedEvent event) {
            WWinPartService.this.partService.firePageChanged(event);
        }
    }
}

