/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.Elements;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableViewerExample
implements IExamplePage {
    private static final int NUMBER = 0;
    private static final int SYMBOL = 1;
    private static final int NAME = 2;
    private static final int SERIES = 3;
    private static final int GROUP = 4;
    private static final int PERIOD = 5;
    private TableViewer viewer;
    private Label lblSelection;
    private final ElementsFilter viewerFilter = new ElementsFilter();
    private final ElementsLabelProvider labelProvider = new ElementsLabelProvider();
    private List elements;
    private Text txtFilter;
    private Label lblHelp;
    private TableViewerColumn nrColumn;
    private TableViewerColumn symColumn;
    private TableViewerColumn nameColumn;
    private TableViewerColumn seriesColumn;
    private TableViewerColumn groupColumn;
    private TableViewerColumn periodColumn;
    private static Color[] seriesColors;

    public void createControl(Composite parent) {
        this.initColors(parent.getDisplay());
        parent.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)true, (boolean)true));
        parent.setLayoutData((Object)ExampleUtil.createFillData());
        this.createTextFilter(parent);
        this.createViewer(parent);
        this.createLabelSelection(parent);
        this.createLabelHelp(parent);
        this.viewer.getTable().forceFocus();
        this.handleSelection(true);
    }

    private void initColors(Display display) {
        Color[] colorArray = new Color[11];
        colorArray[1] = new Color((Device)display, 239, 41, 41);
        colorArray[2] = new Color((Device)display, 233, 185, 110);
        colorArray[3] = new Color((Device)display, 252, 233, 79);
        colorArray[4] = new Color((Device)display, 114, 159, 207);
        colorArray[5] = new Color((Device)display, 173, 127, 168);
        colorArray[6] = new Color((Device)display, 173, 127, 168);
        colorArray[7] = new Color((Device)display, 252, 175, 62);
        colorArray[8] = new Color((Device)display, 238, 238, 236);
        colorArray[9] = new Color((Device)display, 156, 159, 153);
        colorArray[10] = new Color((Device)display, 138, 226, 52);
        seriesColors = colorArray;
    }

    private void createTextFilter(Composite parent) {
        this.txtFilter = new Text(parent, 2048);
        GridData gridData = ExampleUtil.createHorzFillData();
        this.txtFilter.setLayoutData((Object)gridData);
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                TableViewerExample.this.viewerFilter.setText(text.getText());
                TableViewerExample.this.viewer.refresh();
                TableViewerExample.this.updateLabel();
            }
        });
        this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 27 || e.keyCode == 0x1000002) {
                    TableViewerExample.this.handleSelection(e.keyCode == 0x1000002);
                    TableViewerExample.this.viewer.getTable().forceFocus();
                }
            }
        });
        this.txtFilter.setData("org.eclipse.rap.rwt.activeKeys", (Object)new String[]{"ENTER", "ESCAPE", "ARROW_DOWN"});
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 2048);
        GridData tableLayoutData = ExampleUtil.createFillData();
        tableLayoutData.heightHint = 500;
        this.viewer.getTable().setLayoutData((Object)tableLayoutData);
        this.elements = Elements.getElements();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ElementsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ElementsLabelProvider());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.nrColumn = this.createColumn("Nr.", 50, 0);
        this.symColumn = this.createColumn("Sym.", 50, 1);
        this.nameColumn = this.createColumn("Name", 140, 2);
        this.seriesColumn = this.createColumn("Series", 180, 3);
        this.groupColumn = this.createColumn("Group", 50, 4);
        this.periodColumn = this.createColumn("Period", 50, 5);
        this.viewer.setInput((Object)this.elements);
        this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewerExample.this.updateLabel();
            }
        });
        this.addViewerKeyboardControl();
    }

    private void createLabelSelection(Composite parent) {
        Composite selBorder = new Composite(parent, 2048);
        selBorder.setLayout((Layout)ExampleUtil.createFillLayout((boolean)true));
        GridData gridData = ExampleUtil.createFillData();
        gridData.minimumHeight = 25;
        selBorder.setLayoutData((Object)gridData);
        this.lblSelection = new Label(selBorder, 0);
    }

    private void createLabelHelp(Composite parent) {
        this.lblHelp = new Label(parent, 64);
        GridData labelHelpLayoutData = ExampleUtil.createHorzFillData();
        this.lblHelp.setLayoutData((Object)labelHelpLayoutData);
        String helpContent = "Shortcuts: [CTRL+F] - Filter | ";
        helpContent = String.valueOf(helpContent) + "Sort by: [CTRL+R] - Number, [CTRL+Y] - Symbol, [CTRL+N] - Name, ";
        helpContent = String.valueOf(helpContent) + "[CTRL+S] - Series, [CTRL+G] - Group, [CTRL+E] - Period";
        this.lblHelp.setText(helpContent);
        this.lblHelp.setForeground(new Color((Device)this.lblHelp.getDisplay(), 150, 150, 150));
        FontData[] font = this.lblHelp.getFont().getFontData();
        int i = 0;
        while (i < font.length) {
            font[i].setHeight(font[i].getHeight() - 4);
            ++i;
        }
        this.lblHelp.setFont(new Font((Device)this.lblHelp.getDisplay(), font));
    }

    private void addViewerKeyboardControl() {
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144) {
                    switch (e.character) {
                        case 'f': {
                            TableViewerExample.this.txtFilter.forceFocus();
                            break;
                        }
                        case 'r': {
                            TableViewerExample.this.sortByColumn(TableViewerExample.this.nrColumn.getColumn(), 0, true);
                            break;
                        }
                        case 'n': {
                            TableViewerExample.this.sortByColumn(TableViewerExample.this.nameColumn.getColumn(), 2, true);
                            break;
                        }
                        case 'y': {
                            TableViewerExample.this.sortByColumn(TableViewerExample.this.symColumn.getColumn(), 1, true);
                            break;
                        }
                        case 's': {
                            TableViewerExample.this.sortByColumn(TableViewerExample.this.seriesColumn.getColumn(), 3, true);
                            break;
                        }
                        case 'g': {
                            TableViewerExample.this.sortByColumn(TableViewerExample.this.groupColumn.getColumn(), 4, true);
                            break;
                        }
                        case 'e': {
                            TableViewerExample.this.sortByColumn(TableViewerExample.this.periodColumn.getColumn(), 5, true);
                        }
                    }
                }
            }
        });
        String[] shortcuts = new String[]{"CTRL+F", "CTRL+N", "CTRL+R", "CTRL+Y", "CTRL+S", "CTRL+G", "CTRL+E"};
        this.viewer.getTable().setData("org.eclipse.rap.rwt.activeKeys", (Object)shortcuts);
        this.viewer.getTable().setData("org.eclipse.rap.rwt.cancelKeys", (Object)shortcuts);
    }

    private void handleSelection(boolean reset) {
        if (this.viewer.getTable().getItemCount() > 0) {
            if (reset || this.viewer.getSelection().isEmpty()) {
                this.viewer.getTable().select(0);
            }
            int index = this.viewer.getTable().getSelectionIndex();
            this.viewer.getTable().setSelection(index);
        }
        this.updateLabel();
    }

    private void updateLabel() {
        StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
        Elements.Element firstElement = (Elements.Element)sel.getFirstElement();
        if (firstElement != null) {
            this.lblSelection.setText(String.valueOf(firstElement.name) + " (" + firstElement.symbol + ")");
        } else {
            this.lblSelection.setText("");
        }
    }

    private TableViewerColumn createColumn(String text, int width, final int sortProperty) {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)this.labelProvider);
        TableColumn column = result.getColumn();
        column.setText(text);
        column.setWidth(width);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableViewerExample.this.sortByColumn((TableColumn)event.widget, sortProperty, false);
            }
        });
        return result;
    }

    private void sortByColumn(TableColumn column, int sortProperty, boolean reset) {
        int sortDirection = TableViewerExample.updateSortDirection(column);
        TableViewerExample.sort(this.viewer, sortProperty, sortDirection == 1024);
        this.handleSelection(false);
    }

    private static int updateSortDirection(TableColumn column) {
        Table table = column.getParent();
        if (column == table.getSortColumn()) {
            if (table.getSortDirection() == 128) {
                table.setSortDirection(1024);
            } else {
                table.setSortDirection(128);
            }
        } else {
            table.setSortColumn(column);
            table.setSortDirection(1024);
        }
        return table.getSortDirection();
    }

    private static void sort(TableViewer viewer, int property, boolean ascending) {
        if ((viewer.getControl().getStyle() & 0x10000000) != 0) {
            List input = (List)viewer.getInput();
            Collections.sort(input, new ElementComparator(property, ascending));
            viewer.refresh();
        } else {
            viewer.setComparator((ViewerComparator)new ElementComparator(property, ascending));
        }
    }

    private static final class ElementComparator
    extends ViewerComparator
    implements Comparator {
        private final boolean ascending;
        private final int property;

        public ElementComparator(int property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public int compare(Viewer viewer, Object object1, Object object2) {
            return this.compare(object1, object2);
        }

        public boolean isSorterProperty(Object elem, String property) {
            return true;
        }

        public int compare(Object object1, Object object2) {
            Elements.Element element1 = (Elements.Element)object1;
            Elements.Element element2 = (Elements.Element)object2;
            int result = 0;
            if (this.property == 2) {
                result = element1.name.compareTo(element2.name);
            } else if (this.property == 0) {
                result = ElementComparator.compare(element1.number, element2.number);
            } else if (this.property == 4) {
                result = ElementComparator.compare(element1.group, element2.group);
            } else if (this.property == 5) {
                result = ElementComparator.compare(element1.period, element2.period);
            } else if (this.property == 1) {
                result = element1.symbol.compareTo(element2.symbol);
            } else if (this.property == 3) {
                result = ElementComparator.compare(element1.series, element2.series);
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        private static int compare(int number1, int number2) {
            int result = number1 < number2 ? -1 : (number1 > number2 ? 1 : 0);
            return result;
        }
    }

    private static final class ElementsContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private ElementsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.elements = new Object[0];
            } else {
                List elementsList = (List)newInput;
                this.elements = elementsList.toArray();
            }
        }

        public void dispose() {
        }
    }

    private static final class ElementsFilter
    extends ViewerFilter {
        private String text;

        private ElementsFilter() {
        }

        public void setText(String string) {
            this.text = string;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = true;
            Elements.Element chemElement = (Elements.Element)element;
            if (this.text != null && this.text.length() > 0) {
                String lowerCaseText = this.text.toLowerCase();
                String elementName = chemElement.name.toLowerCase();
                boolean bl = result = elementName.indexOf(lowerCaseText) != -1;
                if (!result) {
                    String elementSymbol = chemElement.symbol.toLowerCase();
                    boolean bl2 = result = elementSymbol.indexOf(lowerCaseText) != -1;
                }
                if (!result) {
                    String elementSeries = chemElement.getSeriesName().toLowerCase();
                    result = elementSeries.indexOf(lowerCaseText) != -1;
                }
            }
            return result;
        }

        public boolean isFilterProperty(Object element, String prop) {
            return true;
        }
    }

    private static final class ElementsLabelProvider
    extends CellLabelProvider {
        private ElementsLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Elements.Element element = (Elements.Element)cell.getElement();
            int columnIndex = cell.getColumnIndex();
            switch (columnIndex) {
                case 0: {
                    cell.setText(String.valueOf(element.number));
                    break;
                }
                case 4: {
                    cell.setText(String.valueOf(element.group));
                    break;
                }
                case 5: {
                    cell.setText(String.valueOf(element.period));
                    break;
                }
                case 2: {
                    cell.setText(element.name);
                    break;
                }
                case 1: {
                    cell.setText(element.symbol);
                    break;
                }
                case 3: {
                    cell.setText(element.getSeriesName());
                    cell.setBackground(seriesColors[element.series]);
                }
            }
        }

        public String getToolTipText(Object object) {
            Elements.Element element = (Elements.Element)object;
            return String.valueOf(element.symbol) + ": " + element.name + ", " + element.getSeriesName();
        }
    }
}

