/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;

public abstract class AbstractWorkingSet
implements IAdaptable,
IWorkingSet {
    protected static final String FACTORY_ID = "org.eclipse.ui.internal.WorkingSetFactory";
    static final String TAG_AGGREGATE = "aggregate";
    private String name;
    protected ArrayList elements;
    private IWorkingSetManager manager;
    protected IMemento workingSetMemento;
    private String label;
    private String uniqueId;
    private static int counter;
    private boolean labelBoundToName;

    public AbstractWorkingSet(String name, String label) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        this.name = name;
        this.label = label;
        this.labelBoundToName = Util.equals(name, label);
        this.uniqueId = Long.toString(System.currentTimeMillis()) + "_" + counter++;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkingSet.class || adapter == IPersistableElement.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        IWorkingSet wSet;
        Assert.isNotNull((Object)newName, (String)"Working set name must not be null");
        if (this.manager != null && (wSet = this.manager.getWorkingSet(newName)) != this) {
            Assert.isTrue((wSet == null ? 1 : 0) != 0, (String)"working set with same name already registered");
        }
        this.name = newName;
        this.fireWorkingSetChanged("workingSetNameChange", null);
        if (this.labelBoundToName) {
            this.setLabel(newName);
        }
    }

    public void connect(IWorkingSetManager manager) {
        Assert.isTrue((this.manager == null ? 1 : 0) != 0, (String)"A working set can only be connected to one manager");
        this.manager = manager;
    }

    public void disconnect() {
        this.manager = null;
    }

    protected void fireWorkingSetChanged(String property, Object oldValue) {
        AbstractWorkingSetManager receiver = this.manager != null ? (AbstractWorkingSetManager)this.manager : (AbstractWorkingSetManager)WorkbenchPlugin.getDefault().getWorkingSetManager();
        receiver.workingSetChanged(this, property, oldValue);
    }

    protected void internalSetElements(IAdaptable[] newElements) {
        Assert.isNotNull((Object)newElements, (String)"Working set elements array must not be null");
        this.elements = new ArrayList(newElements.length);
        int i = 0;
        while (i < newElements.length) {
            this.elements.add(newElements[i]);
            ++i;
        }
    }

    @Override
    public IAdaptable[] getElements() {
        ArrayList list = this.getElementsArray();
        return list.toArray(new IAdaptable[list.size()]);
    }

    protected ArrayList getElementsArray() {
        if (this.elements == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.elements;
    }

    abstract void restoreWorkingSet();

    protected IWorkingSetManager getManager() {
        return this.manager;
    }

    @Override
    public String getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label == null ? this.getName() : label;
        this.labelBoundToName = Util.equals(label, this.name);
        this.fireWorkingSetChanged("workingSetLabelChange", null);
    }

    @Override
    public boolean isEmpty() {
        return this.getElementsArray().isEmpty();
    }

    @Override
    public final ImageDescriptor getImage() {
        return this.getImageDescriptor();
    }

    String getUniqueId() {
        return this.uniqueId;
    }

    void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }
}

