/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.events;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class EventUtil {
    private static final String ATTR_LAST_EVENT_TIME = EventUtil.class.getName() + "#lastEventTime";

    public static int getLastEventTime() {
        Long eventTime;
        if (ContextProvider.hasContext()) {
            ServiceStore serviceStore = ContextProvider.getContext().getServiceStore();
            eventTime = (Long)serviceStore.getAttribute(ATTR_LAST_EVENT_TIME);
            eventTime = eventTime == null ? Long.valueOf(System.currentTimeMillis()) : Long.valueOf(eventTime + 1L);
            serviceStore.setAttribute(ATTR_LAST_EVENT_TIME, eventTime);
        } else {
            eventTime = System.currentTimeMillis();
        }
        return (int)(eventTime % Integer.MAX_VALUE);
    }

    public static boolean allowProcessing(Event event) {
        boolean result;
        if (event.widget.isDisposed()) {
            result = false;
        } else {
            switch (event.type) {
                case 9: 
                case 10: 
                case 11: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 36: 
                case 5021: 
                case 5022: {
                    result = true;
                    break;
                }
                default: {
                    result = EventUtil.isAccessible(event.widget);
                }
            }
        }
        return result;
    }

    public static boolean isAccessible(Widget widget) {
        boolean result;
        boolean bl = result = !widget.isDisposed();
        if (result) {
            if (widget instanceof Control) {
                result = EventUtil.isAccessible((Control)widget);
            } else if (widget instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)widget;
                result = EventUtil.isAccessible(menuItem);
            } else if (widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)widget;
                result = EventUtil.isAccessible(toolItem);
            } else if (widget instanceof Menu) {
                Menu menu = (Menu)widget;
                result = EventUtil.isAccessible(menu);
            }
        }
        return result;
    }

    private static boolean isAccessible(Control control) {
        return control.getEnabled() && control.getVisible() && EventUtil.isShellAccessible(control.getShell());
    }

    private static boolean isAccessible(Menu menu) {
        return menu.getEnabled() && EventUtil.isShellAccessible(menu.getShell());
    }

    private static boolean isAccessible(MenuItem menuItem) {
        return menuItem.getEnabled() && EventUtil.isShellAccessible(menuItem.getParent().getShell());
    }

    private static boolean isAccessible(ToolItem toolItem) {
        return toolItem.getEnabled() && EventUtil.isShellAccessible(toolItem.getParent().getShell());
    }

    private static boolean isShellAccessible(Shell shell) {
        Shell modalShell = null;
        Shell activeShell = shell.getDisplay().getActiveShell();
        if (activeShell != null && activeShell.isVisible() && EventUtil.isModal(activeShell)) {
            modalShell = activeShell;
        }
        return modalShell == null || shell == modalShell;
    }

    private static boolean isModal(Shell shell) {
        return (shell.getStyle() & 0x10000) != 0;
    }

    private EventUtil() {
    }
}

