/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.res.StringManager;

public class MapperListener
extends LifecycleMBeanBase
implements ContainerListener,
LifecycleListener {
    private static final Log log = LogFactory.getLog(MapperListener.class);
    private Mapper mapper = null;
    private Connector connector = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    private String domain = null;

    public MapperListener(Mapper mapper, Connector connector) {
        this.mapper = mapper;
        this.connector = connector;
    }

    public String getConnectorName() {
        return this.connector.toString();
    }

    @Override
    public void startInternal() throws LifecycleException {
        Container[] conHosts;
        this.setState(LifecycleState.STARTING);
        this.findDefaultHost();
        Engine engine = (Engine)this.connector.getService().getContainer();
        this.addListeners(engine);
        Container[] containerArray = conHosts = engine.findChildren();
        int n = conHosts.length;
        int n2 = 0;
        while (n2 < n) {
            Container conHost = containerArray[n2];
            Host host = (Host)conHost;
            if (!LifecycleState.NEW.equals((Object)host.getState())) {
                this.registerHost(host);
            }
            ++n2;
        }
    }

    @Override
    public void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected String getDomainInternal() {
        return this.connector.getDomainInternal();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.connector.createObjectNameKeyProperties("Mapper");
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        if (event.getType() == "addChild") {
            Container child = (Container)event.getData();
            this.addListeners(child);
            if (child.getState().isAvailable()) {
                if (child instanceof Host) {
                    this.registerHost((Host)child);
                } else if (child instanceof Context) {
                    this.registerContext((Context)child);
                } else if (child instanceof Wrapper) {
                    this.registerWrapper((Wrapper)child);
                }
            }
        } else if (event.getType() == "removeChild") {
            Container child = (Container)event.getData();
            this.removeListeners(child);
        } else if (event.getType() == "addAlias") {
            this.mapper.addHostAlias(((Host)event.getSource()).getName(), event.getData().toString());
        } else if (event.getType() == "removeAlias") {
            this.mapper.removeHostAlias(event.getData().toString());
        } else if (event.getType() == "addMapping") {
            Wrapper wrapper = (Wrapper)event.getSource();
            Context context = (Context)wrapper.getParent();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String version = ((Context)wrapper.getParent()).getWebappVersion();
            String hostName = context.getParent().getName();
            String wrapperName = wrapper.getName();
            String mapping = (String)event.getData();
            boolean jspWildCard = "jsp".equals(wrapperName) && mapping.endsWith("/*");
            this.mapper.addWrapper(hostName, contextPath, version, mapping, wrapper, jspWildCard, context.isResourceOnlyServlet(wrapperName));
        } else if (event.getType() == "removeMapping") {
            Wrapper wrapper = (Wrapper)event.getSource();
            String contextPath = ((Context)wrapper.getParent()).getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String version = ((Context)wrapper.getParent()).getWebappVersion();
            String hostName = wrapper.getParent().getParent().getName();
            String mapping = (String)event.getData();
            this.mapper.removeWrapper(hostName, contextPath, version, mapping);
        } else if (event.getType() == "addWelcomeFile") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String welcomeFile = (String)event.getData();
            this.mapper.addWelcomeFile(hostName, contextPath, context.getWebappVersion(), welcomeFile);
        } else if (event.getType() == "removeWelcomeFile") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String welcomeFile = (String)event.getData();
            this.mapper.removeWelcomeFile(hostName, contextPath, context.getWebappVersion(), welcomeFile);
        } else if (event.getType() == "clearWelcomeFiles") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            this.mapper.clearWelcomeFiles(hostName, contextPath, context.getWebappVersion());
        }
    }

    private void findDefaultHost() {
        Engine engine = (Engine)this.connector.getService().getContainer();
        String defaultHost = engine.getDefaultHost();
        boolean found = false;
        if (defaultHost != null && defaultHost.length() > 0) {
            Container[] containers;
            Container[] containerArray = containers = engine.findChildren();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                String[] aliases;
                Container container = containerArray[n2];
                Host host = (Host)container;
                if (defaultHost.equalsIgnoreCase(host.getName())) {
                    found = true;
                    break;
                }
                String[] stringArray = aliases = host.findAliases();
                int n3 = aliases.length;
                int n4 = 0;
                while (n4 < n3) {
                    String alias = stringArray[n4];
                    if (defaultHost.equalsIgnoreCase(alias)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (found) {
            this.mapper.setDefaultHostName(defaultHost);
        } else {
            log.warn(sm.getString("mapperListener.unknownDefaultHost", defaultHost, this.connector));
        }
    }

    private void registerHost(Host host) {
        String[] aliases = host.findAliases();
        this.mapper.addHost(host.getName(), aliases, host);
        Container[] containerArray = host.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container container = containerArray[n2];
            if (container.getState().isAvailable()) {
                this.registerContext((Context)container);
            }
            ++n2;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("mapperListener.registerHost", host.getName(), this.domain, this.connector));
        }
    }

    private void unregisterHost(Host host) {
        String hostname = host.getName();
        this.mapper.removeHost(hostname);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("mapperListener.unregisterHost", hostname, this.domain, this.connector));
        }
    }

    private void unregisterWrapper(Wrapper wrapper) {
        String[] mappings;
        String contextPath = ((Context)wrapper.getParent()).getPath();
        String wrapperName = wrapper.getName();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String version = ((Context)wrapper.getParent()).getWebappVersion();
        String hostName = wrapper.getParent().getParent().getName();
        String[] stringArray = mappings = wrapper.findMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            this.mapper.removeWrapper(hostName, contextPath, version, mapping);
            ++n2;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("mapperListener.unregisterWrapper", wrapperName, contextPath, this.connector));
        }
    }

    private void registerContext(Context context) {
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        Container host = context.getParent();
        DirContext resources = context.getResources();
        String[] welcomeFiles = context.findWelcomeFiles();
        this.mapper.addContextVersion(host.getName(), host, contextPath, context.getWebappVersion(), context, welcomeFiles, resources);
        Container[] containerArray = context.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container container = containerArray[n2];
            this.registerWrapper((Wrapper)container);
            ++n2;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("mapperListener.registerContext", contextPath, this.connector));
        }
    }

    private void unregisterContext(Context context) {
        if (context.getPaused()) {
            return;
        }
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String hostName = context.getParent().getName();
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("mapperListener.unregisterContext", contextPath, this.connector));
        }
        this.mapper.removeContextVersion(hostName, contextPath, context.getWebappVersion());
    }

    private void registerWrapper(Wrapper wrapper) {
        String[] mappings;
        String wrapperName = wrapper.getName();
        Context context = (Context)wrapper.getParent();
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String version = ((Context)wrapper.getParent()).getWebappVersion();
        String hostName = context.getParent().getName();
        String[] stringArray = mappings = wrapper.findMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            boolean jspWildCard = wrapperName.equals("jsp") && mapping.endsWith("/*");
            this.mapper.addWrapper(hostName, contextPath, version, mapping, wrapper, jspWildCard, context.isResourceOnlyServlet(wrapperName));
            ++n2;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("mapperListener.registerWrapper", wrapperName, contextPath, this.connector));
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            Object obj = event.getSource();
            if (obj instanceof Wrapper) {
                this.registerWrapper((Wrapper)obj);
            } else if (obj instanceof Context) {
                this.registerContext((Context)obj);
            } else if (obj instanceof Host) {
                this.registerHost((Host)obj);
            }
        } else if (event.getType() == "before_stop") {
            Object obj = event.getSource();
            if (obj instanceof Wrapper) {
                this.unregisterWrapper((Wrapper)obj);
            } else if (obj instanceof Context) {
                this.unregisterContext((Context)obj);
            } else if (obj instanceof Host) {
                this.unregisterHost((Host)obj);
            }
        }
    }

    private void addListeners(Container container) {
        container.addContainerListener(this);
        container.addLifecycleListener(this);
        Container[] containerArray = container.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container child = containerArray[n2];
            this.addListeners(child);
            ++n2;
        }
    }

    private void removeListeners(Container container) {
        container.removeContainerListener(this);
        container.removeLifecycleListener(this);
        Container[] containerArray = container.findChildren();
        int n = containerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Container child = containerArray[n2];
            this.removeListeners(child);
            ++n2;
        }
    }
}

