/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.io.File;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.supplemental.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadEvent;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadHandler;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadListener;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ProgressCollector;
import org.eclipse.swt.internal.widgets.ValidationHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class UploadPanel
extends Composite
implements FileUploadListener {
    private static final long serialVersionUID = 1L;
    public static final int COMPACT = 1;
    public static final int FULL = 2;
    public static final int REMOVEABLE = 4;
    public static final int PROGRESS = 8;
    private final int panelStyle;
    private final FileUploadHandler handler;
    private ValidationHandler validationHandler;
    private ProgressCollector progressCollector;
    private FileUpload browseButton;
    private Text fileText;
    private ProgressBar progressBar;
    private Label progressLabel;
    private Button removeButton;
    private boolean inProgress;
    private File uploadedFile;
    private String contentType;
    private boolean autoUpload;
    private Image deleteImage;

    public UploadPanel(Composite parent, int style) {
        super(parent, UploadPanel.checkStyle(style));
        this.panelStyle = style;
        DiskFileUploadReceiver receiver = new DiskFileUploadReceiver();
        this.handler = new FileUploadHandler((FileUploadReceiver)receiver);
        this.createChildren();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.browseButton.addSelectionListener(listener);
    }

    public void setValidationHandler(ValidationHandler validationHandler) {
        this.validationHandler = validationHandler;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        super.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.fileText.setEnabled(enabled);
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enabled);
        }
    }

    public boolean isFinished() {
        return false;
    }

    public String getSelectedFilename() {
        this.checkWidget();
        return this.fileText.getText();
    }

    public String getContentType() {
        return this.contentType;
    }

    public File getUploadedFile() {
        return this.uploadedFile;
    }

    public void startUpload() {
        this.checkWidget();
        this.inProgress = true;
        String url = this.handler.getUploadUrl();
        this.handler.addUploadListener((FileUploadListener)this);
        this.browseButton.submit(url);
    }

    public void dispose() {
        this.handler.removeUploadListener((FileUploadListener)this);
        this.handler.dispose();
        super.dispose();
    }

    public void setProgressCollector(ProgressCollector progressCollector) {
        this.progressCollector = progressCollector;
    }

    public void setAutoUpload(boolean autoUpload) {
        this.autoUpload = autoUpload;
    }

    public boolean isStarted() {
        return this.inProgress;
    }

    static int checkStyle(int style) {
        int mask = 15;
        return style & mask;
    }

    private boolean hasStyle(int testStyle) {
        return (this.panelStyle & testStyle) != 0;
    }

    private void createChildren() {
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.browseButton = new FileUpload((Composite)this, 0);
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("Select a file");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String filename = UploadPanel.this.browseButton.getFileName();
                UploadPanel.this.fileText.setText(filename);
                UploadPanel.this.validate();
                if (UploadPanel.this.autoUpload) {
                    UploadPanel.this.startUpload();
                }
            }
        });
        this.fileText = new Text((Composite)this, 2048);
        this.fileText.setToolTipText("Selected file");
        this.fileText.setEditable(false);
        if (this.hasStyle(8)) {
            this.progressBar = new ProgressBar((Composite)this, 65792);
            this.progressBar.setToolTipText("Upload progress");
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressLabel = new Label((Composite)this, 0);
            this.progressLabel.setText(String.valueOf(this.progressBar.getSelection()) + "%");
        }
        if (this.hasStyle(4)) {
            this.removeButton = new Button((Composite)this, 8);
            Image removeIcon = Display.getCurrent().getSystemImage(256);
            this.removeButton.setImage(removeIcon);
            if (this.deleteImage == null) {
                this.deleteImage = Graphics.getImage((String)"resources/delete_obj.gif", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            this.removeButton.setImage(this.deleteImage);
            this.removeButton.setToolTipText("Remove file");
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (UploadPanel.this.progressCollector != null) {
                        UploadPanel.this.progressCollector.updateProgress(UploadPanel.this.handler, 0);
                    }
                    UploadPanel.this.dispose();
                }
            });
        }
        this.layoutChildren();
    }

    private void layoutChildren() {
        this.checkWidget();
        if (this.hasStyle(1)) {
            this.browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
            GridData textLayoutData = new GridData(4, 4, true, false);
            textLayoutData.minimumWidth = 186;
            this.fileText.setLayoutData((Object)textLayoutData);
            if (this.progressBar != null) {
                GridData progressLayoutData = new GridData(4, 4, false, false);
                progressLayoutData.minimumWidth = 48;
                progressLayoutData.widthHint = 128;
                this.progressBar.setLayoutData((Object)progressLayoutData);
                GridData lblLayoutData = new GridData(4, 4, false, false);
                float avgCharWidth = TextSizeUtil.getAvgCharWidth((Font)this.progressLabel.getFont());
                lblLayoutData.minimumWidth = (int)avgCharWidth * 6;
                lblLayoutData.widthHint = (int)avgCharWidth * 6;
                this.progressLabel.setLayoutData((Object)lblLayoutData);
            }
            if (this.removeButton != null) {
                this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
            }
        } else {
            this.browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
            GridData textLayoutData = new GridData(4, 4, true, false);
            textLayoutData.minimumWidth = 186;
            textLayoutData.horizontalSpan = 4;
            this.fileText.setLayoutData((Object)textLayoutData);
            if (this.progressBar != null) {
                GridData progressLayoutData = new GridData(4, 4, true, false);
                progressLayoutData.horizontalSpan = 4;
                this.progressBar.setLayoutData((Object)progressLayoutData);
                GridData lblLayoutData = new GridData(4, 4, false, false);
                float avgCharWidth = TextSizeUtil.getAvgCharWidth((Font)this.progressLabel.getFont());
                lblLayoutData.minimumWidth = (int)avgCharWidth * 6;
                lblLayoutData.widthHint = (int)avgCharWidth * 6;
                this.progressLabel.setLayoutData((Object)lblLayoutData);
            }
            if (this.removeButton != null) {
                this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
            }
        }
    }

    public void validate() {
        if (this.validationHandler == null || this.validationHandler.validate(this.fileText.getText())) {
            this.fileText.setToolTipText("Selected file");
            this.fileText.setBackground(null);
        } else {
            this.fileText.setToolTipText("Warning: Selected file does not match filter");
            this.fileText.setBackground(Display.getCurrent().getSystemColor(7));
            this.validationHandler.updateEnablement();
        }
    }

    public void uploadProgress(final FileUploadEvent uploadEvent) {
        this.browseButton.getDisplay().asyncExec(new Runnable(){

            public void run() {
                double fraction = (double)uploadEvent.getBytesRead() / (double)uploadEvent.getContentLength();
                int percent = (int)Math.floor(fraction * 100.0);
                if (UploadPanel.this.progressBar != null && !UploadPanel.this.progressBar.isDisposed()) {
                    UploadPanel.this.progressBar.setSelection(percent);
                    UploadPanel.this.progressBar.setToolTipText("Upload progress: " + percent + "%");
                    UploadPanel.this.progressLabel.setText(String.valueOf(percent) + "%");
                }
                if (UploadPanel.this.progressCollector != null && percent < 100) {
                    UploadPanel.this.progressCollector.updateProgress(UploadPanel.this.handler, percent);
                }
            }
        });
    }

    public void uploadFinished(FileUploadEvent uploadEvent) {
        DiskFileUploadReceiver receiver = (DiskFileUploadReceiver)this.handler.getReceiver();
        this.uploadedFile = receiver.getTargetFile();
        this.contentType = uploadEvent.getContentType();
        this.browseButton.getDisplay().asyncExec(new Runnable(){

            public void run() {
                int percent = 100;
                if (UploadPanel.this.progressBar != null && !UploadPanel.this.progressBar.isDisposed()) {
                    UploadPanel.this.progressBar.setSelection(percent);
                    UploadPanel.this.progressBar.setToolTipText("Upload progress: " + percent + "%");
                    UploadPanel.this.progressLabel.setText(String.valueOf(percent) + "%");
                }
                if (UploadPanel.this.progressCollector != null) {
                    UploadPanel.this.progressCollector.updateProgress(UploadPanel.this.handler, percent);
                }
            }
        });
    }

    public void uploadFailed(final FileUploadEvent uploadEvent) {
        this.uploadedFile = null;
        this.contentType = null;
        this.browseButton.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (UploadPanel.this.progressBar != null && !UploadPanel.this.progressBar.isDisposed()) {
                    UploadPanel.this.progressBar.setState(1);
                    UploadPanel.this.progressBar.setToolTipText(uploadEvent.getException().getMessage());
                }
            }
        });
    }
}

