/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import org.eclipse.gef.commands.CompoundCommand;

public abstract class Command {
    private String label;
    private String debugLabel;

    public Command() {
    }

    public Command(String label) {
        this.setLabel(label);
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public Command chain(Command command) {
        if (command == null) {
            return this;
        }
        class ChainedCompoundCommand
        extends CompoundCommand {
            ChainedCompoundCommand() {
            }

            public Command chain(Command c) {
                this.add(c);
                return this;
            }
        }
        ChainedCompoundCommand result = new ChainedCompoundCommand();
        result.setDebugLabel("Chained Commands");
        result.add(this);
        result.add(command);
        return result;
    }

    public void dispose() {
    }

    public void execute() {
    }

    public String getDebugLabel() {
        return String.valueOf(this.debugLabel) + ' ' + this.getLabel();
    }

    public String getLabel() {
        return this.label;
    }

    public void redo() {
        this.execute();
    }

    public void setDebugLabel(String label) {
        this.debugLabel = label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void undo() {
    }
}

