/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Stack;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;

public class CommandStack {
    public static final int POST_EXECUTE = 8;
    public static final int POST_REDO = 16;
    public static final int POST_UNDO = 32;
    public static final int POST_MASK = new Integer(56);
    public static final int PRE_EXECUTE = 1;
    public static final int PRE_REDO = 2;
    public static final int PRE_UNDO = 4;
    public static final int PRE_MASK = new Integer(7);
    private List eventListeners = new ArrayList();
    protected List listeners = new ArrayList();
    private Stack redoable = new Stack();
    private int saveLocation = 0;
    private Stack undoable = new Stack();
    private int undoLimit = 0;

    public void addCommandStackEventListener(CommandStackEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public boolean canRedo() {
        if (this.redoable.size() == 0) {
            return false;
        }
        return ((Command)this.redoable.peek()).canRedo();
    }

    public boolean canUndo() {
        if (this.undoable.size() == 0) {
            return false;
        }
        return ((Command)this.undoable.peek()).canUndo();
    }

    public void dispose() {
        this.flushUndo();
        this.flushRedo();
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.flushRedo();
        this.notifyListeners(command, 1);
        try {
            command.execute();
            if (this.getUndoLimit() > 0) {
                while (this.undoable.size() >= this.getUndoLimit()) {
                    ((Command)this.undoable.remove(0)).dispose();
                    if (this.saveLocation <= -1) continue;
                    --this.saveLocation;
                }
            }
            if (this.saveLocation > this.undoable.size()) {
                this.saveLocation = -1;
            }
            this.undoable.push(command);
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 8);
        }
    }

    public void flush() {
        this.flushRedo();
        this.flushUndo();
        this.saveLocation = 0;
        this.notifyListeners();
    }

    private void flushRedo() {
        while (!this.redoable.isEmpty()) {
            ((Command)this.redoable.pop()).dispose();
        }
    }

    private void flushUndo() {
        while (!this.undoable.isEmpty()) {
            ((Command)this.undoable.pop()).dispose();
        }
    }

    public Object[] getCommands() {
        ArrayList commands = new ArrayList(this.undoable);
        int i = this.redoable.size() - 1;
        while (i >= 0) {
            commands.add(this.redoable.get(i));
            --i;
        }
        return commands.toArray();
    }

    public Command getRedoCommand() {
        return this.redoable.isEmpty() ? null : (Command)this.redoable.peek();
    }

    public Command getUndoCommand() {
        return this.undoable.isEmpty() ? null : (Command)this.undoable.peek();
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public boolean isDirty() {
        return this.undoable.size() != this.saveLocation;
    }

    public void markSaveLocation() {
        this.saveLocation = this.undoable.size();
        this.notifyListeners();
    }

    protected void notifyListeners() {
        EventObject event = new EventObject(this);
        int i = 0;
        while (i < this.listeners.size()) {
            ((CommandStackListener)this.listeners.get(i)).commandStackChanged(event);
            ++i;
        }
    }

    protected void notifyListeners(Command command, int state) {
        CommandStackEvent event = new CommandStackEvent(this, command, state);
        int i = 0;
        while (i < this.eventListeners.size()) {
            ((CommandStackEventListener)this.eventListeners.get(i)).stackChanged(event);
            ++i;
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = (Command)this.redoable.pop();
        this.notifyListeners(command, 2);
        try {
            command.redo();
            this.undoable.push(command);
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 16);
        }
    }

    public void removeCommandStackEventListener(CommandStackEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    public void setUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        Command command = (Command)this.undoable.pop();
        this.notifyListeners(command, 4);
        try {
            command.undo();
            this.redoable.push(command);
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 32);
        }
    }
}

