/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart.basic;

import org.eclipse.rap.addons.chart.NvChart;
import org.eclipse.rap.addons.chart.basic.DataGroup;
import org.eclipse.rap.addons.chart.basic.DataItem;
import org.eclipse.rap.addons.chart.basic.DataItem2D;
import org.eclipse.rap.addons.chart.internal.ColorUtil;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.swt.widgets.Composite;

public class LineChart
extends NvChart {
    private String xAxisLabel = "";
    private String yAxisLabel = "";
    private String xAxisFormat = "d";
    private String yAxisFormat = "d";
    private boolean interactive = true;
    private String interpolate = "linear";
    private boolean area;
    private boolean useInteractiveGuideline;
    private boolean useVoronoi = true;
    private boolean padData = true;

    public LineChart(Composite parent, int style) {
        super(parent, style, "nv-line");
        this.requireJs(this.registerResource("chart/nv/nv-line.js"));
    }

    public void setXAxisLabel(String label) {
        this.checkWidget();
        if (label != null && !label.equals(this.xAxisLabel)) {
            this.xAxisLabel = label;
            this.setOption("xAxis.axisLabel", label);
        }
    }

    public String getXAxisLabel() {
        this.checkWidget();
        return this.xAxisLabel;
    }

    public void setYAxisLabel(String label) {
        this.checkWidget();
        if (label != null && !label.equals(this.yAxisLabel)) {
            this.yAxisLabel = label;
            this.setOption("yAxis.axisLabel", label);
        }
    }

    public String getYAxisLabel() {
        this.checkWidget();
        return this.yAxisLabel;
    }

    public void setXAxisFormat(String format) {
        this.checkWidget();
        if (format != null && !format.equals(this.xAxisFormat)) {
            this.xAxisFormat = format;
            this.setOption("xAxisFormat", format);
        }
    }

    public String getXAxisFormat() {
        this.checkWidget();
        return this.xAxisFormat;
    }

    public void setYAxisFormat(String format) {
        this.checkWidget();
        if (format != null && !format.equals(this.yAxisFormat)) {
            this.yAxisFormat = format;
            this.setOption("yAxisFormat", format);
        }
    }

    public String getYAxisFormat() {
        this.checkWidget();
        return this.yAxisFormat;
    }

    public void setInteractive(boolean interactive) {
        this.checkWidget();
        if (this.interactive != interactive) {
            this.interactive = interactive;
            this.setOption("interactive", interactive);
        }
    }

    public boolean isInteractive() {
        this.checkWidget();
        return this.interactive;
    }

    public void setInterpolate(String interpolate) {
        this.checkWidget();
        if (interpolate != null && !interpolate.equals(this.interpolate)) {
            this.interpolate = interpolate;
            this.setOption("interpolate", interpolate);
        }
    }

    public String getInterpolate() {
        this.checkWidget();
        return this.interpolate;
    }

    public void setArea(boolean area) {
        this.checkWidget();
        if (this.area != area) {
            this.area = area;
            this.setOption("isArea", area);
        }
    }

    public boolean getArea() {
        this.checkWidget();
        return this.area;
    }

    public void setUseInteractiveGuideline(boolean useInteractiveGuideline) {
        this.checkWidget();
        if (this.useInteractiveGuideline != useInteractiveGuideline) {
            this.useInteractiveGuideline = useInteractiveGuideline;
            this.setOption("useInteractiveGuideline", useInteractiveGuideline);
        }
    }

    public boolean getUseInteractiveGuideline() {
        this.checkWidget();
        return this.useInteractiveGuideline;
    }

    public void setUseVoronoi(boolean useVoronoi) {
        this.checkWidget();
        if (this.useVoronoi != useVoronoi) {
            this.useVoronoi = useVoronoi;
            this.setOption("useVoronoi", useVoronoi);
        }
    }

    public boolean getUseVoronoi() {
        this.checkWidget();
        return this.useVoronoi;
    }

    public void setPadData(boolean padData) {
        this.checkWidget();
        if (this.padData != padData) {
            this.padData = padData;
            this.setOption("padData", padData);
        }
    }

    public boolean getPadData() {
        this.checkWidget();
        return this.padData;
    }

    public void setItems(DataGroup ... items) {
        JsonArray values = new JsonArray();
        DataGroup[] dataGroupArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            DataGroup item = dataGroupArray[n2];
            values.add((JsonValue)LineChart.toJson(item));
            ++n2;
        }
        this.setItems((JsonValue)values);
    }

    private static JsonObject toJson(DataGroup group) {
        JsonArray values = new JsonArray();
        int i = 0;
        while (i < group.items.length) {
            DataItem item = group.items[i];
            if (item instanceof DataItem2D) {
                DataItem2D item2d = (DataItem2D)item;
                values.add((JsonValue)new JsonObject().add("x", item2d.getX()).add("y", item2d.getY()));
            } else {
                values.add((JsonValue)new JsonObject().add("x", i).add("y", item.getValue()));
            }
            ++i;
        }
        JsonObject json = new JsonObject().add("values", (JsonValue)values);
        if (group.text != null) {
            json.add("key", group.text);
        }
        if (group.color != null) {
            json.add("color", ColorUtil.toHtmlString(group.color));
        }
        return json;
    }
}

