/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error((int)22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = Clipboard.class.getName();
        if (!validName.equals(name)) {
            DND.error((int)43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error((int)24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error((int)22);
        }
        if (display.isDisposed()) {
            DND.error((int)24);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error((int)22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error((int)4);
        }
        if (!(transfer instanceof TextTransfer)) {
            return null;
        }
        return this.display.getData("TextTransfer");
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error((int)5);
        }
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i] instanceof TextTransfer && data[i] instanceof String) {
                this.display.setData("TextTransfer", data[i]);
                return;
            }
            ++i;
        }
    }

    public TransferData[] getAvailableTypes() {
        this.checkWidget();
        return new TransferData[0];
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        return new String[0];
    }
}

