/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.events.ActivateListener;
import org.eclipse.swt.internal.events.SetDataEvent;
import org.eclipse.swt.internal.events.SetDataListener;
import org.eclipse.swt.internal.events.ShowEvent;
import org.eclipse.swt.internal.events.ShowListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public final class UntypedEventAdapter
implements SerializableCompatibility,
ControlListener,
DisposeListener,
SelectionListener,
FocusListener,
TreeListener,
ShellListener,
MenuListener,
ModifyListener,
SetDataListener,
VerifyListener,
MouseListener,
KeyListener,
TraverseListener,
ShowListener,
ActivateListener,
HelpListener,
DragDetectListener,
MenuDetectListener,
ArmListener {
    private final List<Entry> listeners = new ArrayList<Entry>();

    public void controlMoved(ControlEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(10, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void controlResized(ControlEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(11, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void widgetDisposed(DisposeEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(12, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void widgetDefaultSelected(SelectionEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(14, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void widgetSelected(SelectionEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(13, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void focusGained(FocusEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(15, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void focusLost(FocusEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(16, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void treeCollapsed(TreeEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(18, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void treeExpanded(TreeEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(17, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void shellActivated(ShellEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(26, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void shellClosed(ShellEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(21, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
        typedEvent.doit = event.doit;
    }

    public void shellDeactivated(ShellEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(27, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void menuHidden(MenuEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(23, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void menuShown(MenuEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(22, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void modifyText(ModifyEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(24, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void verifyText(VerifyEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(25, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void update(SetDataEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(36, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void mouseDown(MouseEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(3, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void mouseUp(MouseEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(4, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void mouseDoubleClick(MouseEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(8, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void keyPressed(KeyEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(1, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
        typedEvent.doit = event.doit;
    }

    public void keyReleased(KeyEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(2, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void keyTraversed(TraverseEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(31, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
        typedEvent.doit = event.doit;
    }

    public void controlShown(ShowEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(22, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void controlHidden(ShowEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(23, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void activated(ActivateEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(26, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void deactivated(ActivateEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(27, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void helpRequested(HelpEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(28, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void dragDetected(DragDetectEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(29, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void menuDetected(MenuDetectEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(35, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void widgetArmed(ArmEvent typedEvent) {
        Event event = UntypedEventAdapter.createEvent(30, typedEvent.getSource());
        UntypedEventAdapter.copyFields(typedEvent, event);
        this.dispatchEvent(event);
    }

    public void addListener(Widget widget, int eventType, Listener listener) {
        boolean validEventType = true;
        switch (eventType) {
            case 10: 
            case 11: {
                ControlEvent.addListener(widget, this);
                break;
            }
            case 12: {
                DisposeEvent.addListener(widget, this);
                break;
            }
            case 13: 
            case 14: {
                SelectionEvent.addListener(widget, this);
                break;
            }
            case 15: 
            case 16: {
                FocusEvent.addListener(widget, this);
                break;
            }
            case 17: 
            case 18: {
                TreeEvent.addListener((Adaptable)widget, this);
                break;
            }
            case 26: 
            case 27: {
                if (widget instanceof Shell) {
                    ShellEvent.addListener(widget, this);
                    break;
                }
                ActivateEvent.addListener(widget, this);
                break;
            }
            case 21: {
                ShellEvent.addListener(widget, this);
                break;
            }
            case 23: {
                if (widget instanceof Control) {
                    ShowEvent.addListener(widget, this);
                    break;
                }
                MenuEvent.addListener(widget, this);
                break;
            }
            case 22: {
                if (widget instanceof Control) {
                    ShowEvent.addListener(widget, this);
                    break;
                }
                MenuEvent.addListener(widget, this);
                break;
            }
            case 35: {
                MenuDetectEvent.addListener(widget, this);
                break;
            }
            case 24: {
                ModifyEvent.addListener(widget, this);
                break;
            }
            case 25: {
                VerifyEvent.addListener((Adaptable)widget, this);
                break;
            }
            case 36: {
                SetDataEvent.addListener(widget, this);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                MouseEvent.addListener(widget, this);
                break;
            }
            case 1: 
            case 2: {
                KeyEvent.addListener(widget, this);
                break;
            }
            case 31: {
                TraverseEvent.addListener((Adaptable)widget, this);
                break;
            }
            case 28: {
                HelpEvent.addListener(widget, this);
                break;
            }
            case 29: {
                DragDetectEvent.addListener((Adaptable)widget, this);
                break;
            }
            case 30: {
                ArmEvent.addListener(widget, this);
                break;
            }
            default: {
                validEventType = false;
            }
        }
        if (validEventType) {
            this.addListener(eventType, listener);
        }
    }

    void addListener(int eventType, Listener listener) {
        this.listeners.add(new Entry(eventType, listener));
    }

    public void removeListener(Widget widget, int eventType, Listener listener) {
        boolean validEventType = true;
        switch (eventType) {
            case 10: 
            case 11: {
                ControlEvent.removeListener(widget, this);
                break;
            }
            case 12: {
                DisposeEvent.removeListener(widget, this);
                break;
            }
            case 13: 
            case 14: {
                SelectionEvent.removeListener(widget, this);
                break;
            }
            case 15: 
            case 16: {
                FocusEvent.removeListener(widget, this);
                break;
            }
            case 17: 
            case 18: {
                TreeEvent.removeListener((Adaptable)widget, this);
                break;
            }
            case 26: 
            case 27: {
                if (widget instanceof Shell) {
                    ShellEvent.removeListener(widget, this);
                    break;
                }
                ActivateEvent.removeListener(widget, this);
                break;
            }
            case 21: {
                ShellEvent.removeListener(widget, this);
                break;
            }
            case 23: {
                if (widget instanceof Control) {
                    ShowEvent.removeListener(widget, this);
                    break;
                }
                MenuEvent.removeListener(widget, this);
                break;
            }
            case 22: {
                if (widget instanceof Control) {
                    ShowEvent.removeListener(widget, this);
                    break;
                }
                MenuEvent.removeListener(widget, this);
                break;
            }
            case 35: {
                MenuDetectEvent.removeListener(widget, this);
                break;
            }
            case 24: {
                ModifyEvent.removeListener(widget, this);
                break;
            }
            case 25: {
                VerifyEvent.removeListener((Adaptable)widget, this);
                break;
            }
            case 36: {
                SetDataEvent.removeListener(widget, this);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                MouseEvent.removeListener(widget, this);
                break;
            }
            case 1: 
            case 2: {
                KeyEvent.removeListener(widget, this);
                break;
            }
            case 31: {
                TraverseEvent.removeListener((Adaptable)widget, this);
                break;
            }
            case 28: {
                HelpEvent.removeListener(widget, this);
                break;
            }
            case 29: {
                DragDetectEvent.removeListener((Adaptable)widget, this);
                break;
            }
            case 30: {
                ArmEvent.removeListener(widget, this);
                break;
            }
            default: {
                validEventType = false;
            }
        }
        if (validEventType) {
            this.removeListener(eventType, listener);
        }
    }

    void removeListener(int eventType, Listener listener) {
        Entry[] entries = this.getEntries();
        boolean found = false;
        int i = 0;
        while (!found && i < entries.length) {
            boolean bl = found = entries[i].listener == listener;
            if (found) {
                this.listeners.remove(entries[i]);
            }
            ++i;
        }
    }

    public Listener[] getListeners(int eventType) {
        Entry[] entries = this.getEntries();
        ArrayList<Listener> result = new ArrayList<Listener>();
        int i = 0;
        while (i < entries.length) {
            Entry entry = entries[i];
            if (entry.eventType == eventType) {
                result.add(entry.listener);
            }
            ++i;
        }
        return result.toArray(new Listener[result.size()]);
    }

    public boolean hasUntypedListener(int eventType) {
        boolean result = false;
        Entry[] entries = this.getEntries();
        int i = 0;
        while (!result && i < entries.length) {
            Entry entry = entries[i];
            if (entry.eventType == eventType) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static boolean hasTypedListener(Widget widget, int eventType) {
        boolean result = false;
        switch (eventType) {
            case 10: 
            case 11: {
                result = ControlEvent.hasListener(widget);
                break;
            }
            case 12: {
                result = DisposeEvent.hasListener(widget);
                break;
            }
            case 13: 
            case 14: {
                result = SelectionEvent.hasListener(widget);
                break;
            }
            case 15: 
            case 16: {
                result = FocusEvent.hasListener(widget);
                break;
            }
            case 17: 
            case 18: {
                result = TreeEvent.hasListener(widget);
                break;
            }
            case 26: 
            case 27: {
                if (widget instanceof Shell) {
                    result = ShellEvent.hasListener(widget);
                    break;
                }
                result = ActivateEvent.hasListener(widget);
                break;
            }
            case 21: {
                result = ShellEvent.hasListener(widget);
                break;
            }
            case 22: 
            case 23: {
                if (widget instanceof Control) {
                    result = ShowEvent.hasListener(widget);
                    break;
                }
                result = MenuEvent.hasListener(widget);
                break;
            }
            case 35: {
                result = MenuDetectEvent.hasListener(widget);
                break;
            }
            case 24: {
                result = ModifyEvent.hasListener(widget);
                break;
            }
            case 25: {
                result = VerifyEvent.hasListener(widget);
                break;
            }
            case 36: {
                result = SetDataEvent.hasListener(widget);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                result = MouseEvent.hasListener(widget);
                break;
            }
            case 1: 
            case 2: {
                result = KeyEvent.hasListener(widget);
                break;
            }
            case 31: {
                result = TraverseEvent.hasListener(widget);
                break;
            }
            case 28: {
                result = HelpEvent.hasListener(widget);
                break;
            }
            case 29: {
                result = DragDetectEvent.hasListener(widget);
                break;
            }
            case 30: {
                result = ArmEvent.hasListener(widget);
            }
        }
        return result;
    }

    public static void notifyListeners(int eventType, Event event) {
        TypedEvent typedEvent = null;
        switch (eventType) {
            case 10: 
            case 11: {
                typedEvent = new ControlEvent(event);
                break;
            }
            case 12: {
                typedEvent = new DisposeEvent(event);
                break;
            }
            case 13: 
            case 14: {
                typedEvent = new SelectionEvent(event);
                break;
            }
            case 15: 
            case 16: {
                typedEvent = new FocusEvent(event);
                break;
            }
            case 17: 
            case 18: {
                if (event.widget instanceof Tree) {
                    typedEvent = new TreeEvent(event);
                    break;
                }
                typedEvent = new ExpandEvent(event);
                break;
            }
            case 26: 
            case 27: {
                if (event.widget instanceof Shell) {
                    typedEvent = new ShellEvent(event);
                    break;
                }
                typedEvent = new ActivateEvent(event);
                break;
            }
            case 21: {
                typedEvent = new ShellEvent(event);
                break;
            }
            case 22: 
            case 23: {
                if (event.widget instanceof Control) {
                    typedEvent = new ShowEvent(event);
                    break;
                }
                typedEvent = new MenuEvent(event);
                break;
            }
            case 35: {
                typedEvent = new MenuDetectEvent(event);
                break;
            }
            case 24: {
                typedEvent = new ModifyEvent(event);
                break;
            }
            case 25: {
                typedEvent = new VerifyEvent(event);
                break;
            }
            case 36: {
                typedEvent = new SetDataEvent(event);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                typedEvent = new MouseEvent(event);
                break;
            }
            case 1: 
            case 2: {
                typedEvent = new KeyEvent(event);
                break;
            }
            case 31: {
                typedEvent = new TraverseEvent(event);
                break;
            }
            case 28: {
                typedEvent = new HelpEvent(event);
                break;
            }
            case 29: {
                typedEvent = new DragDetectEvent(event);
                break;
            }
            case 30: {
                typedEvent = new ArmEvent(event);
            }
        }
        if (typedEvent != null) {
            typedEvent.processEvent();
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    private void dispatchEvent(Event event) {
        int eventType = event.type;
        Entry[] entries = this.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].eventType == eventType) {
                entries[i].listener.handleEvent(event);
            }
            ++i;
        }
    }

    private Entry[] getEntries() {
        return this.listeners.toArray(new Entry[this.listeners.size()]);
    }

    private static Event createEvent(int eventType, Object source) {
        Widget widget = (Widget)source;
        Event result = new Event();
        result.type = eventType;
        result.widget = widget;
        result.display = widget.getDisplay();
        return result;
    }

    private static void copyFields(TypedEvent from, Event to) {
        to.display = from.display;
        to.widget = from.widget;
        to.data = from.data;
    }

    private static void copyFields(SelectionEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.detail = from.detail;
        to.doit = from.doit;
        to.x = from.x;
        to.y = from.y;
        to.width = from.width;
        to.height = from.height;
        to.item = from.item;
        to.text = from.text;
        to.stateMask = from.stateMask;
    }

    private static void copyFields(TreeEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.detail = from.detail;
        to.doit = from.doit;
        to.x = from.x;
        to.y = from.y;
        to.height = from.height;
        to.width = from.width;
        to.item = from.item;
        to.text = from.text;
    }

    private static void copyFields(VerifyEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.start = from.start;
        to.end = from.end;
        to.doit = from.doit;
        to.text = from.text;
    }

    private static void copyFields(SetDataEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.index = from.index;
        to.item = from.item;
    }

    private static void copyFields(MouseEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.button = from.button;
        to.time = from.time;
        to.x = from.x;
        to.y = from.y;
        to.stateMask = from.stateMask;
    }

    private static void copyFields(ShellEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.doit = from.doit;
    }

    private static void copyFields(KeyEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.character = from.character;
        to.keyCode = from.keyCode;
        to.stateMask = from.stateMask;
        to.doit = from.doit;
    }

    private static void copyFields(TraverseEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.character = from.character;
        to.keyCode = from.keyCode;
        to.stateMask = from.stateMask;
        to.detail = from.detail;
        to.doit = from.doit;
    }

    private static void copyFields(MenuDetectEvent from, Event to) {
        UntypedEventAdapter.copyFields((TypedEvent)from, to);
        to.x = from.x;
        to.y = from.y;
        to.doit = from.doit;
    }

    private static final class Entry
    implements SerializableCompatibility {
        final int eventType;
        final Listener listener;

        private Entry(int eventType, Listener listener) {
            this.eventType = eventType;
            this.listener = listener;
        }
    }
}

