/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;

public class HostHeaderCustomizer
implements HttpConfiguration.Customizer {
    private final String serverName;
    private final int serverPort;

    public HostHeaderCustomizer() {
        this(null, 0);
    }

    public HostHeaderCustomizer(String serverName) {
        this(serverName, 0);
    }

    public HostHeaderCustomizer(String serverName, int serverPort) {
        this.serverName = serverName;
        this.serverPort = serverPort;
    }

    @Override
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        if (request.getConnectionMetaData().getHttpVersion() == HttpVersion.HTTP_1_1 || request.getHeaders().contains(HttpHeader.HOST)) {
            return request;
        }
        String host = this.serverName == null ? Request.getServerName(request) : this.serverName;
        int port = URIUtil.normalizePortForScheme((String)request.getHttpURI().getScheme(), (int)(this.serverPort == 0 ? Request.getServerPort(request) : this.serverPort));
        final HttpURI uri = this.serverName != null || this.serverPort > 0 ? HttpURI.build((HttpURI)request.getHttpURI()).authority(host, port).asImmutable() : request.getHttpURI();
        HttpFields original = request.getHeaders();
        HttpFields.Mutable builder = HttpFields.build((int)(original.size() + 1));
        builder.add((HttpField)new HostPortHttpField(host, port));
        builder.add(request.getHeaders());
        final HttpFields headers = builder.asImmutable();
        return new Request.Wrapper(request){

            @Override
            public HttpURI getHttpURI() {
                return uri;
            }

            @Override
            public HttpFields getHeaders() {
                return headers;
            }
        };
    }
}

