/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.eventlistprofiler.EventListenerProfiler;
import org.eclipse.scout.commons.eventlistprofiler.IEventListenerSnapshot;
import org.eclipse.scout.commons.eventlistprofiler.IEventListenerSource;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class BasicPropertySupport
implements IEventListenerSource {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicPropertySupport.class);
    public static final int DEFAULT_INT_VALUE = 0;
    public static final int DEFAULT_DOUBLE_VALUE = 0;
    public static final Integer DEFAULT_INT = new Integer(0);
    public static final Double DEFAULT_DOUBLE = new Double(0.0);
    public static final long DEFAULT_LONG_VALUE = 0L;
    public static final Long DEFAULT_LONG = new Long(0L);
    private static final Boolean DEFAULT_BOOL = new Boolean(false);
    private HashMap<String, Object> m_props = new HashMap();
    private Object m_source;
    private Object m_listenerLock = new Object();
    private ArrayList<Object> m_listeners;
    private HashMap<String, ArrayList<Object>> m_childListeners;
    private int m_propertiesChanging;
    private ArrayList<PropertyChangeEvent> m_propertyEventBuffer;

    public BasicPropertySupport(Object sourceBean) {
        this.m_source = sourceBean;
        if (EventListenerProfiler.getInstance().isEnabled()) {
            EventListenerProfiler.getInstance().registerSourceAsWeakReference(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpListenerList(IEventListenerSnapshot snapshot) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_listeners != null) {
                for (Object object2 : this.m_listeners) {
                    if (object2 instanceof WeakReference) {
                        snapshot.add(PropertyChangeListener.class, null, ((WeakReference)object2).get());
                        continue;
                    }
                    snapshot.add(PropertyChangeListener.class, null, object2);
                }
            }
            if (this.m_childListeners != null) {
                for (Map.Entry entry : this.m_childListeners.entrySet()) {
                    String context = (String)entry.getKey();
                    for (Object o : (ArrayList)entry.getValue()) {
                        if (o instanceof WeakReference) {
                            snapshot.add(PropertyChangeListener.class, context, ((WeakReference)o).get());
                            continue;
                        }
                        snapshot.add(PropertyChangeListener.class, context, o);
                    }
                }
            }
        }
    }

    public boolean isPropertiesChanging() {
        return this.m_propertiesChanging > 0;
    }

    public void setPropertiesChanging(boolean b) {
        if (b) {
            ++this.m_propertiesChanging;
        } else if (this.m_propertiesChanging > 0) {
            --this.m_propertiesChanging;
            if (this.m_propertiesChanging == 0) {
                this.processChangeBuffer();
            }
        }
    }

    public void clearProperties() {
        this.m_props.clear();
    }

    public Map<String, Object> getPropertiesMap() {
        int i = 0;
        while (i < 10) {
            try {
                return new HashMap<String, Object>(this.m_props);
            }
            catch (ConcurrentModificationException cme) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(null, cme);
                }
                ++i;
            }
        }
        return new HashMap<String, Object>(this.m_props);
    }

    public void putPropertiesMap(Map<String, Object> map) {
        this.m_props.putAll(map);
    }

    public boolean hasProperty(String name) {
        return this.m_props.containsKey(name);
    }

    public void setPropertyInt(String name, int i) {
        this.setProperty(name, new Integer(i), DEFAULT_INT);
    }

    public int getPropertyInt(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.intValue() : 0;
    }

    public void setPropertyDouble(String name, double d) {
        this.setProperty(name, new Double(d), DEFAULT_DOUBLE);
    }

    public double getPropertyDouble(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.doubleValue() : 0.0;
    }

    public void setPropertyLong(String name, long i) {
        this.setProperty(name, new Long(i), DEFAULT_LONG);
    }

    public long getPropertyLong(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.longValue() : DEFAULT_LONG.longValue();
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.setProperty(name, new Boolean(b), DEFAULT_BOOL);
    }

    public boolean getPropertyBool(String name) {
        Boolean b = (Boolean)this.getProperty(name);
        return b != null ? b.booleanValue() : DEFAULT_BOOL.booleanValue();
    }

    public void setPropertyString(String name, String s) {
        this.setProperty(name, s);
    }

    public void setPropertyStringAlwaysFire(String name, String s) {
        this.setPropertyAlwaysFire(name, s);
    }

    public String getPropertyString(String name) {
        String s = (String)this.getProperty(name);
        return s;
    }

    public Object getProperty(String name) {
        return this.m_props.get(name);
    }

    public boolean setProperty(String name, Object newValue) {
        return this.setProperty(name, newValue, null);
    }

    public boolean setPropertyNoFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        return !CompareUtility.equals(oldValue, newValue);
    }

    public boolean setProperty(String name, Object newValue, Object defaultOldValueWhenNull) {
        Object oldValue = this.m_props.get(name);
        if (oldValue == null) {
            oldValue = defaultOldValueWhenNull;
        }
        this.m_props.put(name, newValue);
        if (CompareUtility.equals(oldValue, newValue)) {
            return false;
        }
        this.firePropertyChangeImpl(name, oldValue, newValue);
        return true;
    }

    public void setPropertyAlwaysFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        this.firePropertyChangeImpl(name, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_listeners == null) {
                    this.m_listeners = new ArrayList();
                }
                if (listener instanceof WeakEventListener) {
                    this.m_listeners.add(new WeakReference<PropertyChangeListener>(listener));
                } else {
                    this.m_listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            Object object = this.m_listenerLock;
            synchronized (object) {
                this.removeFromListNoLock(this.m_listeners, listener);
                if (this.m_childListeners != null) {
                    for (ArrayList<Object> childList : this.m_childListeners.values()) {
                        this.removeFromListNoLock(childList, listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            ArrayList<Object> children;
            if (this.m_childListeners == null) {
                this.m_childListeners = new HashMap();
            }
            if ((children = this.m_childListeners.get(propertyName)) == null) {
                children = new ArrayList();
                this.m_childListeners.put(propertyName, children);
            }
            children.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            ArrayList<Object> childList;
            if (this.m_childListeners != null && (childList = this.m_childListeners.get(propertyName)) != null) {
                this.removeFromListNoLock(childList, listener);
            }
        }
    }

    private void removeFromListNoLock(ArrayList listeners, PropertyChangeListener listener) {
        if (listeners == null) {
            return;
        }
        if (listener instanceof WeakEventListener) {
            int i = 0;
            int n = listeners.size();
            while (i < n) {
                Object o = listeners.get(i);
                if (o instanceof WeakReference && ((WeakReference)o).get() == listener) {
                    listeners.remove(i);
                    break;
                }
                ++i;
            }
        } else {
            listeners.remove(listener);
        }
        if (listeners.size() == 0) {
            listeners.trimToSize();
        }
    }

    public void firePropertyChange(PropertyChangeEvent e) {
        this.firePropertyChangeImpl(e);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (CompareUtility.equals(oldValue, newValue)) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    private void firePropertyChangeImpl(String propertyName, Object oldValue, Object newValue) {
        ArrayList<Object> l = this.m_listeners;
        HashMap<String, ArrayList<Object>> m = this.m_childListeners;
        if (l != null && l.size() > 0 || m != null && m.size() > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.m_source, propertyName, oldValue, newValue);
            this.firePropertyChangeImpl(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeImpl(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        if (this.isPropertiesChanging()) {
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_propertyEventBuffer == null) {
                    this.m_propertyEventBuffer = new ArrayList();
                }
                this.m_propertyEventBuffer.add(e);
            }
        }
        ArrayList<PropertyChangeListener> targets = new ArrayList<PropertyChangeListener>(4);
        Object object = this.m_listenerLock;
        synchronized (object) {
            ArrayList<Object> childListeners;
            String propertyName;
            if (this.m_listeners != null) {
                for (Object o : this.m_listeners) {
                    if (o instanceof WeakReference) {
                        o = ((WeakReference)o).get();
                    }
                    if (o == null) continue;
                    targets.add((PropertyChangeListener)o);
                }
            }
            if ((propertyName = e.getPropertyName()) != null && this.m_childListeners != null && (childListeners = this.m_childListeners.get(propertyName)) != null) {
                for (Object o : childListeners) {
                    if (o instanceof WeakReference) {
                        o = ((WeakReference)o).get();
                    }
                    if (o == null) continue;
                    targets.add((PropertyChangeListener)o);
                }
            }
        }
        if (targets.size() > 0) {
            for (PropertyChangeListener listener : targets) {
                listener.propertyChange(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangeBuffer() {
        PropertyChangeEvent[] a = null;
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_propertyEventBuffer != null) {
                a = this.m_propertyEventBuffer.toArray(new PropertyChangeEvent[this.m_propertyEventBuffer.size()]);
            }
            this.m_propertyEventBuffer = null;
        }
        if (a != null && a.length > 0) {
            LinkedList<PropertyChangeEvent> coalesceList = new LinkedList<PropertyChangeEvent>();
            HashSet<String> names = new HashSet<String>();
            int i = a.length - 1;
            while (i >= 0) {
                if (!names.contains(a[i].getPropertyName())) {
                    coalesceList.add(0, a[i]);
                    names.add(a[i].getPropertyName());
                }
                --i;
            }
            for (PropertyChangeEvent e : coalesceList) {
                this.firePropertyChangeImpl(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String propertyName) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            ArrayList<Object> l0 = this.m_listeners;
            ArrayList<Object> l1 = null;
            if (propertyName != null) {
                l1 = this.m_childListeners.get(propertyName);
            }
            int count = (l0 != null ? l0.size() : 0) + (l1 != null ? l1.size() : 0);
            return count > 0;
        }
    }
}

