/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal;

import java.util.HashSet;
import java.util.logging.LogRecord;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.JavaLogUtility;

public abstract class AbstractScoutLogger
implements IScoutLogger {
    protected void log(int level, String format, Object[] args, Throwable t) {
        if (!this.isLoggable(level)) {
            return;
        }
        LogRecord record = JavaLogUtility.buildLogRecord(AbstractScoutLogger.class, JavaLogUtility.scoutToJavaLevel(level), format, args);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        this.logImpl(record);
    }

    protected abstract void logImpl(LogRecord var1);

    protected StackTraceElement getCallerLine(Class wrapperClass) {
        try {
            StackTraceElement[] trace = new Exception().getStackTrace();
            int traceIndex = 0;
            HashSet<String> ignoredPackagePrefixes = new HashSet<String>();
            ignoredPackagePrefixes.add(IScoutLogger.class.getPackage().getName());
            if (wrapperClass != null) {
                ignoredPackagePrefixes.add(wrapperClass.getPackage().getName());
            }
            while (traceIndex < trace.length) {
                boolean found = true;
                for (String prefix : ignoredPackagePrefixes) {
                    if (!trace[traceIndex].getClassName().startsWith(prefix)) continue;
                    found = false;
                    break;
                }
                if (found) break;
                ++traceIndex;
            }
            if (traceIndex >= trace.length) {
                traceIndex = trace.length - 1;
            }
            return trace[traceIndex];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void debug(String msg) {
        this.log(4, msg, null, null);
    }

    @Override
    public void debug(String format, Object arg) {
        this.log(4, format, new Object[]{arg}, null);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.log(4, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void debug(String format, Object[] argArray) {
        this.log(4, format, argArray, null);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(4, msg, null, t);
    }

    @Override
    public void error(String msg) {
        this.log(1, msg, null, null);
    }

    @Override
    public void error(String format, Object arg) {
        this.log(1, format, new Object[]{arg}, null);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.log(1, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void error(String format, Object[] argArray) {
        this.log(1, format, argArray, null);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(1, msg, null, t);
    }

    @Override
    public void info(String msg) {
        this.log(3, msg, null, null);
    }

    @Override
    public void info(String format, Object arg) {
        this.log(3, format, new Object[]{arg}, null);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.log(3, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void info(String format, Object[] argArray) {
        this.log(3, format, argArray, null);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(3, msg, null, t);
    }

    @Override
    public void trace(String msg) {
        this.log(4, msg, null, null);
    }

    @Override
    public void trace(String format, Object arg) {
        this.log(4, format, new Object[]{arg}, null);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.log(4, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void trace(String format, Object[] argArray) {
        this.log(4, format, argArray, null);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(4, msg, null, t);
    }

    @Override
    public void warn(String msg) {
        this.log(2, msg, null, null);
    }

    @Override
    public void warn(String format, Object arg) {
        this.log(2, format, new Object[]{arg}, null);
    }

    @Override
    public void warn(String format, Object[] argArray) {
        this.log(2, format, argArray, null);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.log(2, format, new Object[]{arg1, arg2}, null);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(2, msg, null, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(5);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(4);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(3);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(2);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLoggable(1);
    }

    @Override
    public boolean isLoggable(int level) {
        return this.getLevel() >= level;
    }
}

