/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.nls;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.scout.commons.nls.NlsLocale;
import org.eclipse.scout.commons.nls.NlsResourceBundleCache;
import org.eclipse.scout.commons.nls.NlsUtility;

public abstract class DynamicNls {
    private ArrayList<NlsResourceBundleCache> m_resourceBundles = new ArrayList();

    protected void registerResourceBundle(String resourceBundleName, Class<?> wrapperClass) {
        this.m_resourceBundles.add(0, new NlsResourceBundleCache(resourceBundleName, wrapperClass));
        NlsUtility.dynamicBindFields(wrapperClass);
    }

    public final String getText(String key, String ... messageArguments) {
        return this.getText((Locale)null, key, messageArguments);
    }

    public final String getText(Locale locale, String key, String ... messageArguments) {
        if (key == null) {
            return null;
        }
        String text = this.getTextInternal(locale, key);
        return NlsUtility.bindText(text, messageArguments);
    }

    protected Locale getDefaultLocale() {
        return NlsLocale.getDefault().getLocale();
    }

    protected String getTextInternal(Locale locale, String key) {
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        for (NlsResourceBundleCache c : this.m_resourceBundles) {
            try {
                return c.getResourceBundle(locale).getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return "{undefined text " + key + "}";
    }

    public Map<String, String> getTextMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        for (NlsResourceBundleCache c : this.m_resourceBundles) {
            try {
                ResourceBundle r = c.getResourceBundle(locale);
                Enumeration<String> en = r.getKeys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement();
                    String text = r.getString(key);
                    if (map.containsKey(key)) continue;
                    map.put(key, text);
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return map;
    }
}

