/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.icon;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IIconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractIconProviderService
extends AbstractService
implements IIconProviderService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractIconProviderService.class);
    private String m_folderName = "resources/icons";
    private String m_iconExtensions = "png,gif,jpg";
    private String[] m_iconExtensionsArray;
    private int m_ranking;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        Object rankingProp = registration.getReference().getProperty("service.ranking");
        if (rankingProp instanceof Integer) {
            this.m_ranking = (Integer)rankingProp;
        }
    }

    @Override
    public int getRanking() {
        return this.m_ranking;
    }

    protected synchronized String[] getIconExtensionsArray() {
        if (this.m_iconExtensionsArray == null) {
            ArrayList<String> fileExtensions = new ArrayList<String>();
            if (this.getIconExtensions() != null) {
                StringTokenizer tokenizer = new StringTokenizer(this.getIconExtensions(), ",;");
                while (tokenizer.hasMoreTokens()) {
                    String t = tokenizer.nextToken().trim();
                    if (t.length() <= 0) continue;
                    fileExtensions.add(t);
                }
            }
            this.m_iconExtensionsArray = fileExtensions.toArray(new String[fileExtensions.size()]);
        }
        return this.m_iconExtensionsArray;
    }

    @Override
    public IconSpec getIconSpec(String iconName) {
        String name = iconName;
        if (StringUtility.isNullOrEmpty((String)name)) {
            return null;
        }
        if (!(name = name.replaceAll("\\A[\\/\\\\]*", "")).startsWith(this.getFolderName())) {
            name = String.valueOf(this.getFolderName()) + "/" + iconName;
        }
        String[] fqns = new String[this.getIconExtensionsArray().length + 1];
        String[] iconNames = new String[this.getIconExtensionsArray().length + 1];
        fqns[0] = name;
        iconNames[0] = iconName;
        int i = 1;
        while (i < fqns.length) {
            fqns[i] = String.valueOf(name) + "." + this.getIconExtensionsArray()[i - 1];
            iconNames[i] = String.valueOf(iconName) + "." + this.getIconExtensionsArray()[i - 1];
            ++i;
        }
        IconSpec spec = null;
        spec = this.findIconSpec(fqns, iconNames);
        return spec;
    }

    protected IconSpec findIconSpec(String[] fqns, String[] iconNames) {
        if (fqns != null && fqns.length > 0) {
            int i = 0;
            while (i < fqns.length) {
                URL url;
                String fqn = fqns[i];
                String iconName = "";
                if (iconNames != null && iconNames.length > i) {
                    iconName = iconNames[i];
                }
                if ((url = this.findResource(fqn)) != null) {
                    try {
                        IconSpec iconSpec = new IconSpec();
                        byte[] content = IOUtility.getContent((InputStream)url.openStream(), (boolean)true);
                        if (content != null) {
                            iconSpec.setContent(content);
                        }
                        iconSpec.setName(iconName);
                        return iconSpec;
                    }
                    catch (Exception e) {
                        LOG.error("could not read input stream from url '" + url + "'.", (Throwable)e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected abstract URL findResource(String var1);

    public void setFolderName(String folderName) {
        this.m_folderName = folderName;
    }

    public String getFolderName() {
        return this.m_folderName;
    }

    public void setIconExtensions(String iconExtensions) {
        this.m_iconExtensions = iconExtensions;
        this.m_iconExtensionsArray = null;
    }

    public String getIconExtensions() {
        return this.m_iconExtensions;
    }
}

