/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.menus;

import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class ResetColumnsMenu
extends AbstractMenu {
    private final ITable m_table;

    public ResetColumnsMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"ResetTableColumns", (String[])new String[0]);
    }

    @Order(value=0.0)
    public class ResetAllMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ResetTableColumnsAll", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            try {
                ResetColumnsMenu.this.m_table.setTableChanging(true);
                ResetColumnsMenu.this.m_table.resetDisplayableColumns();
                ITableColumnFilterManager m = ResetColumnsMenu.this.m_table.getColumnFilterManager();
                if (m != null) {
                    m.reset();
                }
            }
            finally {
                ResetColumnsMenu.this.m_table.setTableChanging(false);
            }
        }
    }

    @Order(value=10.0)
    public class ResetColumnFiltersMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ResetTableColumnFilter", (String[])new String[0]);
        }

        @Override
        protected void execPrepareAction() throws ProcessingException {
            this.setVisible(ResetColumnsMenu.this.m_table.getColumnFilterManager() != null);
        }

        @Override
        protected void execAction() throws ProcessingException {
            try {
                ResetColumnsMenu.this.m_table.setTableChanging(true);
                ITableColumnFilterManager m = ResetColumnsMenu.this.m_table.getColumnFilterManager();
                if (m != null) {
                    m.reset();
                }
            }
            finally {
                ResetColumnsMenu.this.m_table.setTableChanging(false);
            }
        }
    }

    @Order(value=40.0)
    public class ResetOrderMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ResetTableColumnsOrder", (String[])new String[0]);
        }

        @Override
        protected void execAction() {
            try {
                ResetColumnsMenu.this.m_table.setTableChanging(true);
                ResetColumnsMenu.this.m_table.resetColumnOrder();
            }
            finally {
                ResetColumnsMenu.this.m_table.setTableChanging(false);
            }
        }
    }

    @Order(value=30.0)
    public class ResetSortingMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ResetTableColumnsSorting", (String[])new String[0]);
        }

        @Override
        protected void execAction() {
            try {
                ResetColumnsMenu.this.m_table.setTableChanging(true);
                ResetColumnsMenu.this.m_table.resetColumnSortOrder();
            }
            finally {
                ResetColumnsMenu.this.m_table.setTableChanging(false);
            }
        }
    }

    @Order(value=50.0)
    public class ResetVisibilityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ResetTableColumnsVisibility", (String[])new String[0]);
        }

        @Override
        protected void execAction() {
            try {
                ResetColumnsMenu.this.m_table.setTableChanging(true);
                ResetColumnsMenu.this.m_table.resetColumnVisibilities();
            }
            finally {
                ResetColumnsMenu.this.m_table.setTableChanging(false);
            }
        }
    }

    @Order(value=20.0)
    public class ResetWidthsMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ResetTableColumnsWidth", (String[])new String[0]);
        }

        @Override
        protected void execAction() {
            try {
                ResetColumnsMenu.this.m_table.setTableChanging(true);
                ResetColumnsMenu.this.m_table.resetColumnWidths();
            }
            finally {
                ResetColumnsMenu.this.m_table.setTableChanging(false);
            }
        }
    }

    @Order(value=5.0)
    public class Separator1Menu
    extends MenuSeparator {
    }
}

