/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.JavaTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkFolderForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.view.IPublishBookmarkCommand;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.AbstractIcons;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.security.PublishUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.TablePageState;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractBookmarkTreeField
extends AbstractTreeField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBookmarkTreeField.class);
    private BookmarkFolder m_bookmarkRootFolder;
    private IPublishBookmarkCommand m_publishBookmarkCommand;

    public BookmarkFolder getBookmarkRootFolder() {
        return this.m_bookmarkRootFolder;
    }

    public void setBookmarkRootFolder(BookmarkFolder bookmarkRootFolder) {
        this.m_bookmarkRootFolder = bookmarkRootFolder;
    }

    private static boolean isBookmarkNode(ITreeNode node) {
        return node instanceof BookmarkNode;
    }

    private static boolean isFolderNode(ITreeNode node) {
        return node instanceof FolderNode;
    }

    public void injectPublishBookmarkCommand(IPublishBookmarkCommand command) {
        this.m_publishBookmarkCommand = command;
    }

    private BookmarkFolder getParentBookmarkFolder(ITreeNode node) {
        BookmarkFolder folder = this.getBookmarkRootFolder();
        ITreeNode parentNode = node.getParentNode();
        if (AbstractBookmarkTreeField.isFolderNode(parentNode)) {
            folder = (BookmarkFolder)parentNode.getCell().getValue();
        }
        return folder;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @Override
    protected int getConfiguredGridH() {
        return 8;
    }

    @Override
    protected boolean getConfiguredAutoLoad() {
        return false;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    protected abstract Permission getDeletePermission();

    protected abstract Permission getUpdatePermission();

    public void populateTree() {
        block5: {
            try {
                try {
                    this.getTree().setTreeChanging(true);
                    this.getTree().removeAllChildNodes(this.getTree().getRootNode());
                    this.populateFolderContentRec(this.getTree().getRootNode(), this.getBookmarkRootFolder());
                }
                catch (ProcessingException e) {
                    LOG.error(null, (Throwable)e);
                    this.getTree().setTreeChanging(false);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.getTree().setTreeChanging(false);
                throw throwable;
            }
            this.getTree().setTreeChanging(false);
        }
        this.getTree().expandAll(this.getTree().getRootNode());
    }

    private void populateFolderContentRec(ITreeNode parent, BookmarkFolder newParent) throws ProcessingException {
        AbstractTreeNode newNode;
        for (BookmarkFolder newFolder : newParent.getFolders()) {
            newNode = new FolderNode();
            newNode.getCellForUpdate().setValue(newFolder);
            this.getTree().addChildNode(parent, newNode);
            this.populateFolderContentRec(newNode, newFolder);
        }
        for (Bookmark b : newParent.getBookmarks()) {
            newNode = new BookmarkNode();
            newNode.getCellForUpdate().setValue(b);
            this.getTree().addChildNode(parent, newNode);
        }
    }

    private void rebuildBookmarkModel() throws ProcessingException {
        this.getTree().visitTree(new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                BookmarkFolder bmFolder = null;
                if (node == AbstractBookmarkTreeField.this.getTree().getRootNode()) {
                    bmFolder = AbstractBookmarkTreeField.this.getBookmarkRootFolder();
                } else if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    bmFolder = (BookmarkFolder)node.getCell().getValue();
                }
                if (bmFolder != null) {
                    ITreeNode n;
                    bmFolder.getFolders().clear();
                    bmFolder.getBookmarks().clear();
                    ArrayList<BookmarkFolder> folderList = new ArrayList<BookmarkFolder>();
                    ITreeNode[] iTreeNodeArray = node.getChildNodes();
                    int n2 = iTreeNodeArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        n = iTreeNodeArray[n3];
                        if (AbstractBookmarkTreeField.isFolderNode(n)) {
                            BookmarkFolder f = (BookmarkFolder)n.getCell().getValue();
                            folderList.add(f);
                        }
                        ++n3;
                    }
                    Collections.sort(folderList, new Comparator<BookmarkFolder>(){

                        @Override
                        public int compare(BookmarkFolder f1, BookmarkFolder f2) {
                            return StringUtility.compareIgnoreCase((String)f1.getTitle(), (String)f2.getTitle());
                        }
                    });
                    bmFolder.getFolders().addAll(folderList);
                    iTreeNodeArray = node.getChildNodes();
                    n2 = iTreeNodeArray.length;
                    n3 = 0;
                    while (n3 < n2) {
                        n = iTreeNodeArray[n3];
                        if (AbstractBookmarkTreeField.isBookmarkNode(n)) {
                            bmFolder.getBookmarks().add((Bookmark)n.getCell().getValue());
                        }
                        ++n3;
                    }
                }
                return true;
            }
        });
        ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).storeBookmarks();
    }

    private void refreshBookmarkModel() throws ProcessingException {
        this.getTree().visitTree(new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                BookmarkFolder bmFolder = null;
                if (node == AbstractBookmarkTreeField.this.getTree().getRootNode()) {
                    bmFolder = AbstractBookmarkTreeField.this.getBookmarkRootFolder();
                } else if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    bmFolder = (BookmarkFolder)node.getCell().getValue();
                }
                if (bmFolder != null) {
                    bmFolder.getFolders().clear();
                    bmFolder.getBookmarks().clear();
                    ITreeNode[] iTreeNodeArray = node.getChildNodes();
                    int n = iTreeNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITreeNode n3 = iTreeNodeArray[n2];
                        if (AbstractBookmarkTreeField.isFolderNode(n3)) {
                            bmFolder.getFolders().add((BookmarkFolder)n3.getCell().getValue());
                        } else if (AbstractBookmarkTreeField.isBookmarkNode(n3)) {
                            bmFolder.getBookmarks().add((Bookmark)n3.getCell().getValue());
                        }
                        ++n2;
                    }
                }
                return true;
            }
        });
        ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).storeBookmarks();
    }

    private class BookmarkNode
    extends AbstractTreeNode {
        private BookmarkNode() {
        }

        @Override
        protected boolean getConfiguredLeaf() {
            return true;
        }

        @Override
        protected void execDecorateCell(Cell cell) {
            Bookmark bm = (Bookmark)cell.getValue();
            if (bm != null) {
                if (bm.getKeyStroke() != null) {
                    cell.setText(String.valueOf(bm.getTitle()) + " [" + bm.getKeyStroke() + "]");
                } else {
                    cell.setText(bm.getTitle());
                }
                cell.setTooltipText(bm.getText());
                cell.setIconId(AbstractIcons.Bookmark);
            }
        }

        @Order(value=90.0)
        public class ApplyToSearchMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksApplyToCurrentSearch", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                IForm searchForm;
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                Boolean success = null;
                if (desktop != null && (searchForm = desktop.getPageSearchForm()) != null) {
                    for (AbstractPageState state : bm.getPath()) {
                        if (!(state instanceof TablePageState)) continue;
                        TablePageState tablePageState = (TablePageState)state;
                        try {
                            searchForm.setXML(tablePageState.getSearchFormState());
                            searchForm.doSaveWithoutMarkerChange();
                            success = true;
                            break;
                        }
                        catch (ProcessingException processingException) {
                            success = false;
                        }
                    }
                }
                if (success != null && !success.booleanValue()) {
                    MessageBox.showOkMessage(null, null, ScoutTexts.get((String)"ApplyBookmarkToSearchFailedMessage", (String[])new String[0]));
                }
            }
        }

        @Order(value=60.0)
        public class DeleteMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"DeleteBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredMultiSelectionAction() {
                return true;
            }

            @Override
            protected void execPrepareAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getDeletePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<ITreeNode> filteredNodes = new ArrayList<ITreeNode>();
                ITree tree = BookmarkNode.this.getTree();
                ITreeNode[] iTreeNodeArray = tree.getSelectedNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode node = iTreeNodeArray[n2];
                    if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                        items.add(node.getCell().getText());
                        filteredNodes.add(node);
                    }
                    ++n2;
                }
                if (items.size() <= 1 || MessageBox.showDeleteConfirmationMessage(items.toArray(new String[0]))) {
                    for (ITreeNode node : filteredNodes) {
                        tree.removeNode(node);
                    }
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
            }
        }

        @Order(value=50.0)
        public class EditMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"EditBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                BookmarkForm form = new BookmarkForm();
                form.setBookmarkRootFolder(AbstractBookmarkTreeField.this.getBookmarkRootFolder());
                form.getTitleField().setValue(bm.getTitle());
                form.getKeyStrokeField().setValue(bm.getKeyStroke());
                form.getDescriptionField().setValue(bm.getText());
                BookmarkFolder oldBmFolder = AbstractBookmarkTreeField.this.getParentBookmarkFolder(BookmarkNode.this);
                if (oldBmFolder != form.getBookmarkRootFolder()) {
                    form.getFolderField().setValue(oldBmFolder);
                }
                form.startModify();
                form.waitFor();
                if (form.isFormStored()) {
                    BookmarkFolder newBmFolder;
                    ITree tree = BookmarkNode.this.getTree();
                    bm.setTitle((String)form.getTitleField().getValue());
                    bm.setKeyStroke((String)form.getKeyStrokeField().getValue());
                    BookmarkFolder bookmarkFolder = newBmFolder = form.getFolderField().getValue() != null ? (BookmarkFolder)form.getFolderField().getValue() : form.getBookmarkRootFolder();
                    if (!CompareUtility.equals((Object)oldBmFolder, (Object)newBmFolder)) {
                        final AtomicReference<ITreeNode> newContainerNode = new AtomicReference<ITreeNode>(BookmarkNode.this.getTree().getRootNode());
                        tree.visitTree(new ITreeVisitor(){

                            @Override
                            public boolean visit(ITreeNode n) {
                                if (AbstractBookmarkTreeField.isFolderNode(n) && newBmFolder.equals(n.getCell().getValue())) {
                                    newContainerNode.set(n);
                                    return false;
                                }
                                return true;
                            }
                        });
                        tree.removeNode(node);
                        tree.addChildNode(newContainerNode.get(), node);
                        AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                    } else {
                        tree.updateNode(node);
                        AbstractBookmarkTreeField.this.refreshBookmarkModel();
                    }
                }
            }
        }

        @Order(value=40.0)
        public class OpenMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"ActivateBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(bm, false);
            }
        }

        @Order(value=80.0)
        public class PublishMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksPublishMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                this.setVisiblePermission((Permission)new PublishUserBookmarkPermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                if (AbstractBookmarkTreeField.this.m_publishBookmarkCommand != null) {
                    BookmarkNode node = BookmarkNode.this;
                    Bookmark bm = (Bookmark)node.getCell().getValue();
                    BookmarkFolder spoolFolder = new BookmarkFolder();
                    spoolFolder.getBookmarks().add(bm);
                    AbstractBookmarkTreeField.this.m_publishBookmarkCommand.publishBookmark(spoolFolder);
                }
            }
        }

        @Order(value=70.0)
        public class SeparatorMenu1
        extends MenuSeparator {
        }
    }

    private class FolderNode
    extends AbstractTreeNode {
        private FolderNode() {
        }

        @Override
        protected void execDecorateCell(Cell cell) {
            BookmarkFolder bmFolder = (BookmarkFolder)this.getCell().getValue();
            String title = bmFolder.getTitle();
            if ("[INBOX]".equals(title)) {
                title = ScoutTexts.get((String)"GlobalBookmarks", (String[])new String[0]);
            }
            cell.setText(title);
            cell.setIconId(AbstractIcons.Folder);
        }

        @Order(value=40.0)
        public class DeleteMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"DeleteFolderMenu", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredMultiSelectionAction() {
                return true;
            }

            @Override
            protected void execPrepareAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getDeletePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                ITree tree = FolderNode.this.getTree();
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<ITreeNode> filteredNodes = new ArrayList<ITreeNode>();
                ITreeNode[] iTreeNodeArray = tree.getSelectedNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode node = iTreeNodeArray[n2];
                    if (AbstractBookmarkTreeField.isFolderNode(node)) {
                        items.add(node.getCell().getText());
                        filteredNodes.add(node);
                    }
                    ++n2;
                }
                if (items.size() <= 1 || MessageBox.showDeleteConfirmationMessage(items.toArray(new String[0]))) {
                    for (ITreeNode node : filteredNodes) {
                        tree.removeNode(node);
                    }
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
            }
        }

        @Order(value=30.0)
        public class RenameMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"RenameBookmarkFolderMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                FolderNode node = FolderNode.this;
                BookmarkFolder bmFolder = (BookmarkFolder)node.getCell().getValue();
                BookmarkFolderForm form = new BookmarkFolderForm();
                form.getNameField().setValue(bmFolder.getTitle());
                form.startModify();
                form.waitFor();
                if (form.isFormStored()) {
                    bmFolder.setTitle((String)form.getNameField().getValue());
                    FolderNode.this.getTree().updateNode(node);
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }
        }
    }

    @Order(value=10.0)
    public class Tree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredMultiSelect() {
            return true;
        }

        @Override
        protected boolean getConfiguredDragEnabled() {
            return true;
        }

        @Override
        protected int getConfiguredDragType() {
            return 2;
        }

        @Override
        protected int getConfiguredDropType() {
            return 2;
        }

        @Override
        protected void execNodeAction(ITreeNode node) throws ProcessingException {
            if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                Bookmark bm = (Bookmark)node.getCell().getValue();
                ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(bm, false);
            }
        }

        @Override
        protected TransferObject execDrag(ITreeNode node) {
            if (ACCESS.check((Permission)AbstractBookmarkTreeField.this.getUpdatePermission())) {
                if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                    return new JavaTransferObject((Object)node);
                }
                if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    return new JavaTransferObject((Object)node);
                }
            }
            return null;
        }

        @Override
        protected void execDrop(ITreeNode dropNode, TransferObject t) {
            if (t instanceof JavaTransferObject) {
                block21: {
                    try {
                        try {
                            ITreeNode dragNode;
                            AbstractBookmarkTreeField.this.getTree().setTreeChanging(true);
                            if (((JavaTransferObject)t).getLocalObject() instanceof ITreeNode && (dragNode = (ITreeNode)((JavaTransferObject)t).getLocalObject()) != dropNode && dragNode.getTree() == AbstractBookmarkTreeField.this.getTree()) {
                                if (AbstractBookmarkTreeField.isFolderNode(dragNode) && AbstractBookmarkTreeField.isBookmarkNode(dropNode)) {
                                    dropNode = dropNode.getParentNode();
                                }
                                if (AbstractBookmarkTreeField.isBookmarkNode(dragNode) && AbstractBookmarkTreeField.isFolderNode(dropNode)) {
                                    AbstractBookmarkTreeField.this.getTree().removeNode(dragNode);
                                    AbstractBookmarkTreeField.this.getTree().addChildNode(dropNode, dragNode);
                                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                                } else if (AbstractBookmarkTreeField.isBookmarkNode(dragNode) && AbstractBookmarkTreeField.isBookmarkNode(dropNode)) {
                                    AbstractBookmarkTreeField.this.getTree().removeNode(dragNode);
                                    int pos = dropNode.getChildNodeIndex();
                                    AbstractBookmarkTreeField.this.getTree().addChildNode(pos, dropNode.getParentNode(), dragNode);
                                } else if (AbstractBookmarkTreeField.isFolderNode(dragNode) && dropNode == null) {
                                    AbstractBookmarkTreeField.this.getTree().removeNode(dragNode);
                                    AbstractBookmarkTreeField.this.getTree().addChildNode(AbstractBookmarkTreeField.this.getTree().getRootNode(), dragNode);
                                } else if (AbstractBookmarkTreeField.isFolderNode(dragNode) && AbstractBookmarkTreeField.isFolderNode(dropNode)) {
                                    if (AbstractBookmarkTreeField.this.getTree().isAncestorNodeOf(dragNode, dropNode)) {
                                        ITreeNode dragParent = dragNode.getParentNode();
                                        if (dragParent != null) {
                                            int dragPos = dragNode.getChildNodeIndex();
                                            ITreeNode dropAncestor = dropNode;
                                            while (dropAncestor.getParentNode() != dragNode) {
                                                dropAncestor = dropAncestor.getParentNode();
                                            }
                                            AbstractBookmarkTreeField.this.getTree().removeNode(dropAncestor);
                                            AbstractBookmarkTreeField.this.getTree().removeNode(dragNode);
                                            AbstractBookmarkTreeField.this.getTree().addChildNode(dragPos, dragParent, dropAncestor);
                                            AbstractBookmarkTreeField.this.getTree().addChildNode(dropNode, dragNode);
                                        }
                                    } else {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(dragNode);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(dropNode, dragNode);
                                    }
                                }
                            }
                        }
                        catch (ProcessingException e) {
                            e.printStackTrace();
                            AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                        throw throwable;
                    }
                    AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                }
                try {
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
                catch (ProcessingException e) {
                    LOG.error(null, (Throwable)e);
                }
            }
        }

        private void addNewFolder(ITreeNode parentNode) throws ProcessingException {
            if (parentNode == null) {
                parentNode = this.getRootNode();
            }
            BookmarkFolderForm form = new BookmarkFolderForm();
            form.startModify();
            form.waitFor();
            if (form.isFormStored()) {
                FolderNode newNode = new FolderNode();
                BookmarkFolder bmFolder = new BookmarkFolder();
                bmFolder.setTitle((String)form.getNameField().getValue());
                newNode.getCellForUpdate().setValue(bmFolder);
                ITreeNode lastFolderNode = null;
                ITreeNode[] iTreeNodeArray = parentNode.getChildNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode tmp = iTreeNodeArray[n2];
                    if (!AbstractBookmarkTreeField.isFolderNode(tmp)) break;
                    lastFolderNode = tmp;
                    ++n2;
                }
                int pos = lastFolderNode != null ? lastFolderNode.getChildNodeIndex() + 1 : 0;
                AbstractBookmarkTreeField.this.getTree().addChildNode(pos, parentNode, newNode);
                AbstractBookmarkTreeField.this.rebuildBookmarkModel();
            }
        }

        @Order(value=40.0)
        public class DeleteKeyStroke
        extends AbstractKeyStroke {
            @Override
            protected String getConfiguredKeyStroke() {
                return "DELETE";
            }

            @Override
            protected void execAction() throws ProcessingException {
                ITreeNode node = Tree.this.getSelectedNode();
                if (node != null) {
                    IMenu[] iMenuArray = node.getMenus();
                    int n = iMenuArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMenu m = iMenuArray[n2];
                        if (m.getClass().getSimpleName().equals("DeleteMenu")) {
                            m.prepareAction();
                            if (!m.isVisible() || !m.isEnabled()) break;
                            m.doAction();
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }

        @Order(value=11.0)
        public class NewChildFolderMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"NewBookmarkFolderMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                Tree.this.addNewFolder(Tree.this.getSelectedNode());
            }
        }

        @Order(value=10.0)
        public class NewRootFolderMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"NewBookmarkFolderMenu", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredSingleSelectionAction() {
                return false;
            }

            @Override
            protected boolean getConfiguredEmptySpaceAction() {
                return true;
            }

            @Override
            protected void execPrepareAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                Tree.this.addNewFolder(null);
            }
        }

        @Order(value=20.0)
        public class Separator1Menu
        extends MenuSeparator {
        }
    }
}

