/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.internal;

import java.security.Permission;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceEvent;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.AbstractBookmarkTreeField;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.security.DeleteGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.DeleteUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.ReadUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.service.SERVICES;

public class ManageBookmarksForm
extends AbstractForm
implements BookmarkServiceListener {
    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"Bookmarks", (String[])new String[0]);
    }

    @Override
    public void bookmarksChanged(BookmarkServiceEvent e) {
        this.getGlobalBookmarkTreeField().setBookmarkRootFolder(e.getBookmarkService().getBookmarkData().getGlobalBookmarks());
        this.getUserBookmarkTreeField().setBookmarkRootFolder(e.getBookmarkService().getBookmarkData().getUserBookmarks());
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GlobalBox getGlobalBox() {
        return this.getFieldByClass(MainBox.GlobalBox.class);
    }

    public MainBox.UserBox getUserBox() {
        return this.getFieldByClass(MainBox.UserBox.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public MainBox.UserBox.UserBookmarkTreeField getUserBookmarkTreeField() {
        return this.getFieldByClass(MainBox.UserBox.UserBookmarkTreeField.class);
    }

    public MainBox.GlobalBox.GlobalBookmarkTreeField getGlobalBookmarkTreeField() {
        return this.getFieldByClass(MainBox.GlobalBox.GlobalBookmarkTreeField.class);
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {

        @Order(value=50.0)
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=11.0)
        public class GlobalBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"GlobalBookmarks", (String[])new String[0]);
            }

            @Override
            protected void execInitField() throws ProcessingException {
                this.setVisiblePermission((Permission)new UpdateGlobalBookmarkPermission());
            }

            @Order(value=10.0)
            public class GlobalBookmarkTreeField
            extends AbstractBookmarkTreeField {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Override
                protected Permission getDeletePermission() {
                    return new DeleteGlobalBookmarkPermission();
                }

                @Override
                protected Permission getUpdatePermission() {
                    return new UpdateGlobalBookmarkPermission();
                }
            }
        }

        @Order(value=40.0)
        public class OkButton
        extends AbstractOkButton {
        }

        @Order(value=20.0)
        public class UserBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"Bookmarks", (String[])new String[0]);
            }

            @Override
            protected void execInitField() throws ProcessingException {
                this.setVisiblePermission((Permission)new ReadUserBookmarkPermission());
            }

            @Order(value=10.0)
            public class UserBookmarkTreeField
            extends AbstractBookmarkTreeField {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Override
                protected Permission getDeletePermission() {
                    return new DeleteUserBookmarkPermission();
                }

                @Override
                protected Permission getUpdatePermission() {
                    return new UpdateUserBookmarkPermission();
                }
            }
        }
    }

    @Order(value=20.0)
    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
            service.addBookmarkServiceListener(ManageBookmarksForm.this);
            service.loadBookmarks();
            ManageBookmarksForm.this.getGlobalBookmarkTreeField().setBookmarkRootFolder(service.getBookmarkData().getGlobalBookmarks());
            ManageBookmarksForm.this.getUserBookmarkTreeField().setBookmarkRootFolder(service.getBookmarkData().getUserBookmarks());
            ManageBookmarksForm.this.getGlobalBookmarkTreeField().populateTree();
            ManageBookmarksForm.this.getUserBookmarkTreeField().populateTree();
        }

        @Override
        public void execPostLoad() throws ProcessingException {
            ManageBookmarksForm.this.touch();
        }

        @Override
        public void execStore() throws ProcessingException {
            ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).storeBookmarks();
        }

        @Override
        public void execDiscard() throws ProcessingException {
            ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).loadBookmarks();
        }

        @Override
        protected void execFinally() throws ProcessingException {
            IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
            service.removeBookmarkServiceListener(ManageBookmarksForm.this);
        }
    }
}

