/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.internal;

import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;

public class VirtualDesktop
implements IDesktop {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(VirtualDesktop.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private final Map<String, EventListenerList> m_propertyChangeListenerMap = new HashMap<String, EventListenerList>();
    private final Map<Object, EventListenerList> m_dataChangeListenerMap = new HashMap<Object, EventListenerList>();

    public DesktopListener[] getDesktopListeners() {
        return (DesktopListener[])this.m_listenerList.getListeners(DesktopListener.class);
    }

    public Map<Object, EventListenerList> getDataChangeListenerMap() {
        return this.m_dataChangeListenerMap;
    }

    public Map<String, EventListenerList> getPropertyChangeListenerMap() {
        return this.m_propertyChangeListenerMap;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        EventListenerList list = this.m_propertyChangeListenerMap.get(null);
        if (list == null) {
            list = new EventListenerList();
            this.m_propertyChangeListenerMap.put(null, list);
        }
        list.add(PropertyChangeListener.class, (EventListener)listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        EventListenerList list = this.m_propertyChangeListenerMap.get(propertyName);
        if (list == null) {
            list = new EventListenerList();
            this.m_propertyChangeListenerMap.put(propertyName, list);
        }
        list.add(PropertyChangeListener.class, (EventListener)listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Iterator<EventListenerList> it = this.m_dataChangeListenerMap.values().iterator();
        while (it.hasNext()) {
            EventListenerList list = it.next();
            list.remove(PropertyChangeListener.class, (EventListener)listener);
            if (list.getListenerCount(DataChangeListener.class) != 0) continue;
            it.remove();
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Iterator<EventListenerList> it = this.m_dataChangeListenerMap.values().iterator();
        while (it.hasNext()) {
            EventListenerList list = it.next();
            list.remove(PropertyChangeListener.class, (EventListener)listener);
            if (list.getListenerCount(DataChangeListener.class) != 0) continue;
            it.remove();
        }
    }

    @Override
    public void addDesktopListener(DesktopListener l) {
        this.m_listenerList.add(DesktopListener.class, (EventListener)l);
    }

    @Override
    public void removeDesktopListener(DesktopListener l) {
        this.m_listenerList.remove(DesktopListener.class, (EventListener)l);
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener, Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            EventListenerList list = this.m_dataChangeListenerMap.get(null);
            if (list == null) {
                list = new EventListenerList();
                this.m_dataChangeListenerMap.put(null, list);
            }
            list.add(DataChangeListener.class, (EventListener)listener);
        } else {
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object dataType = objectArray[n2];
                if (dataType != null) {
                    EventListenerList list = this.m_dataChangeListenerMap.get(dataType);
                    if (list == null) {
                        list = new EventListenerList();
                        this.m_dataChangeListenerMap.put(dataType, list);
                    }
                    list.add(DataChangeListener.class, (EventListener)listener);
                }
                ++n2;
            }
        }
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener, Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            Iterator<EventListenerList> it = this.m_dataChangeListenerMap.values().iterator();
            while (it.hasNext()) {
                EventListenerList list = it.next();
                list.remove(DataChangeListener.class, (EventListener)listener);
                if (list.getListenerCount(DataChangeListener.class) != 0) continue;
                it.remove();
            }
        } else {
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventListenerList list;
                Object dataType = objectArray[n2];
                if (dataType != null && (list = this.m_dataChangeListenerMap.get(dataType)) != null) {
                    list.remove(DataChangeListener.class, (EventListener)listener);
                    if (list.getListenerCount(DataChangeListener.class) == 0) {
                        this.m_dataChangeListenerMap.remove(dataType);
                    }
                }
                ++n2;
            }
        }
    }

    private UnsupportedOperationException createUnsupportedOperationException() {
        return new UnsupportedOperationException("The desktop is currently loading. This method must be called after the desktop has loaded and is set onto the session");
    }

    @Override
    public boolean isTrayVisible() {
        return false;
    }

    @Override
    public void setTrayVisible(boolean b) {
    }

    @Override
    public boolean isShowing(IForm form) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public boolean isAutoPrefixWildcardForTextSearch() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setAutoPrefixWildcardForTextSearch(boolean b) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void activateBookmark(Bookmark bm, boolean forceReload) throws ProcessingException {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void addFileChooser(IFileChooser fc) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void addForm(IForm form) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void addKeyStrokes(IKeyStroke ... keyStrokes) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void addMessageBox(IMessageBox mb) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void closeInternal() throws ProcessingException {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public Bookmark createBookmark() throws ProcessingException {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void dataChanged(Object ... dataTypes) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void ensureViewStackVisible() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void ensureVisible(IForm form) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IForm> T findForm(Class<T> formType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IForm> T[] findForms(Class<T> formType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IOutline> T findOutline(Class<T> outlineType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IAction> T findAction(Class<T> actionType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IViewButton> T findViewButton(Class<T> viewButtonType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IToolButton> T findToolButton(Class<T> toolButtonType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IForm> T findLastActiveForm(Class<T> formType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IOutline[] getAvailableOutlines() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setAvailableOutlines(IOutline[] availableOutlines) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IForm[] getDialogStack() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IFormField getFocusOwner() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IKeyStroke[] getKeyStrokes() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IMenu[] getMenus() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public <T extends IMenu> T getMenu(Class<? extends T> searchType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IMessageBox[] getMessageBoxStack() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IOutline getOutline() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IForm getPageSearchForm() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setPageSearchForm(IForm f) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IForm getPageDetailForm() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setPageDetailForm(IForm f) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public ITable getPageDetailTable() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setPageDetailTable(ITable t) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setOutlineTableForm(IOutlineTableForm f) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IOutlineTableForm getOutlineTableForm() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public boolean isOutlineTableFormVisible() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setOutlineTableFormVisible(boolean b) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IForm[] getSimilarViewForms(IForm form) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IProcessingStatus getStatus() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public String getTitle() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IAction[] getActions() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IViewButton[] getViewButtons() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IToolButton[] getToolButtons() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IDesktopUIFacade getUIFacade() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public IForm[] getViewStack() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void initDesktop() throws ProcessingException {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public boolean isOpened() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public boolean isGuiAvailable() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void prepareAllMenus() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void printDesktop(PrintDevice device, Map<String, Object> parameters) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void refreshPages(Class ... pageTypes) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void releaseUnusedPages() {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void afterTablePageLoaded(IPageWithTable<?> page) throws ProcessingException {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void removeForm(IForm form) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void removeKeyStrokes(IKeyStroke ... keyStrokes) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setKeyStrokes(IKeyStroke[] ks) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setOutline(IOutline outline) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setOutline(Class<? extends IOutline> outlineType) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setStatus(IProcessingStatus status) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setStatusText(String s) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void setTitle(String s) {
        throw this.createUnsupportedOperationException();
    }

    @Override
    public void changeVisibilityAfterOfflineSwitch() {
    }
}

