/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNodeBuilder;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class SmartTreeForm
extends AbstractSmartFieldProposalForm {
    private P_ActiveNodesFilter m_activeNodesFilter;
    private P_MatchingNodesFilter m_matchingNodesFilter;

    public SmartTreeForm(ISmartField<?> smartField) throws ProcessingException {
        super(smartField);
    }

    @Override
    public void forceProposalSelection() throws ProcessingException {
        ITree tree = this.getResultTreeField().getTree();
        tree.selectNextNode();
    }

    @Override
    protected void execInitForm() throws ProcessingException {
        this.m_activeNodesFilter = new P_ActiveNodesFilter();
        this.m_matchingNodesFilter = new P_MatchingNodesFilter();
        this.getResultTreeField().getTree().setIconId(this.getSmartField().getBrowseIconId());
        this.getResultTreeField().getTree().addTreeListener(new TreeAdapter(){

            @Override
            public void treeChanged(TreeEvent e) {
                switch (e.getType()) {
                    case 100: 
                    case 101: {
                        SmartTreeForm.this.structureChanged(SmartTreeForm.this.getResultTreeField());
                    }
                }
            }
        });
    }

    @ConfigOperation
    @Order(value=100.0)
    protected Pattern execCreatePatternForTreeFilter(String filterText) {
        String s = filterText;
        if (s == null) {
            s = "";
        }
        s = s.toLowerCase();
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop != null && desktop.isAutoPrefixWildcardForTextSearch()) {
            s = "*" + s;
        }
        if (!s.endsWith("*")) {
            s = String.valueOf(s) + "*";
        }
        s = StringUtility.toRegExPattern((String)s);
        return Pattern.compile(s, 32);
    }

    @ConfigOperation
    @Order(value=110.0)
    protected boolean execAcceptNodeByTreeFilter(Pattern filterPattern, ITreeNode node, int level) {
        ISmartField<? extends Object> sf = this.getSmartField();
        LookupRow row = (LookupRow)node.getCell().getValue();
        if (node.isChildrenLoaded() && row != null) {
            String q1 = node.getTree().getPathText(node, "\n");
            String q2 = node.getTree().getPathText(node, " ");
            if (q1 != null && q2 != null) {
                String[] path;
                String[] stringArray = path = (String.valueOf(q1) + "\n" + q2).split("\n");
                int n = path.length;
                int n2 = 0;
                while (n2 < n) {
                    String pathText = stringArray[n2];
                    if (pathText != null && filterPattern.matcher(pathText.toLowerCase()).matches() && sf.acceptBrowseHierarchySelection(row.getKey(), level - 1, node.isLeaf())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return true;
    }

    @ConfigOperation
    @Order(value=120.0)
    protected LookupRow execGetSingleMatch() {
        if (this.getSmartField().isBrowseLoadIncremental()) {
            try {
                LookupRow[] rows = this.getSmartField().callTextLookup(this.getSearchText(), 2);
                if (rows.length == 1) {
                    return rows[0];
                }
                return null;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                return null;
            }
        }
        final ArrayList foundLeafs = new ArrayList();
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                LookupRow row;
                if (node.isEnabled() && node.isLeaf() && (row = (LookupRow)node.getCell().getValue()) != null && row.isEnabled()) {
                    foundLeafs.add(row);
                }
                return foundLeafs.size() <= 2;
            }
        };
        this.getResultTreeField().getTree().visitVisibleTree(v);
        if (foundLeafs.size() == 1) {
            return (LookupRow)foundLeafs.get(0);
        }
        return null;
    }

    @Override
    public void update(boolean selectCurrentValue, boolean synchonous) throws ProcessingException {
        ITree tree = this.getResultTreeField().getTree();
        try {
            tree.setTreeChanging(true);
            this.m_matchingNodesFilter.update(this.getSearchText());
            tree.addNodeFilter(this.m_matchingNodesFilter);
        }
        finally {
            tree.setTreeChanging(false);
        }
        Object statusText = null;
        this.getStatusField().setValue(statusText);
        this.getStatusField().setVisible(statusText != null);
        if (this.getNewButton().isEnabled()) {
            this.getNewButton().setVisible(this.execGetSingleMatch() == null);
        }
        if (selectCurrentValue && tree.getSelectedNodeCount() == 0) {
            this.selectCurrentValueInternal();
        }
        this.structureChanged(this.getResultTreeField());
    }

    private void updateActiveFilter() {
        ITree tree = this.getResultTreeField().getTree();
        try {
            tree.setTreeChanging(true);
            if (this.getSmartField().isActiveFilterEnabled()) {
                this.m_activeNodesFilter.update(this.getSmartField().getActiveFilter());
            } else {
                this.m_activeNodesFilter.update(TriState.TRUE);
            }
            tree.addNodeFilter(this.m_activeNodesFilter);
        }
        finally {
            tree.setTreeChanging(false);
        }
        this.structureChanged(this.getResultTreeField());
    }

    @Override
    public LookupRow getAcceptedProposal() throws ProcessingException {
        LookupRow row = null;
        ITreeNode node = this.getResultTreeField().getTree().getSelectedNode();
        if (node != null && node.isFilterAccepted() && node.isEnabled()) {
            row = (LookupRow)node.getCell().getValue();
        }
        if (row != null && row.isEnabled()) {
            return row;
        }
        if (this.getSmartField().isAllowCustomText()) {
            return null;
        }
        return this.execGetSingleMatch();
    }

    @Override
    public void startForm() throws ProcessingException {
        this.startInternal(new FormHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.ResultTreeField getResultTreeField() {
        return this.getFieldByClass(MainBox.ResultTreeField.class);
    }

    public MainBox.ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(MainBox.ActiveStateRadioButtonGroup.class);
    }

    public MainBox.StatusField getStatusField() {
        return this.getFieldByClass(MainBox.StatusField.class);
    }

    public MainBox.NewButton getNewButton() {
        return this.getFieldByClass(MainBox.NewButton.class);
    }

    private boolean selectCurrentValueInternal() throws ProcessingException {
        final Object selectedKey = this.getSmartField().getValue();
        if (selectedKey != null) {
            ITree tree = this.getResultTreeField().getTree();
            final ArrayList matchingNodes = new ArrayList();
            tree.visitTree(new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    Object val = node.getCell().getValue();
                    if (val instanceof LookupRow && CompareUtility.equals((Object)selectedKey, (Object)((LookupRow)val).getKey())) {
                        matchingNodes.add(node);
                    }
                    return true;
                }
            });
            if (matchingNodes.size() > 0) {
                tree.selectNode((ITreeNode)matchingNodes.get(0));
                int i = 1;
                while (i < matchingNodes.size()) {
                    ITreeNode node = (ITreeNode)matchingNodes.get(i);
                    tree.setNodeExpanded(node, true);
                    tree.ensureVisible((ITreeNode)matchingNodes.get(i));
                    ++i;
                }
                return true;
            }
            ITreeNode node = this.loadNodeWithKey(selectedKey);
            if (node != null) {
                tree.selectNode(node);
                return true;
            }
        }
        return false;
    }

    private ITreeNode loadNodeWithKey(Object key) throws ProcessingException {
        ArrayList<LookupRow> path = new ArrayList<LookupRow>();
        Object t = key;
        while (t != null) {
            LookupRow row = this.getLookupRowFor(t);
            if (row != null) {
                path.add(0, row);
                t = row.getParentKey();
                continue;
            }
            t = null;
        }
        ITree tree = this.getResultTreeField().getTree();
        ITreeNode parentNode = tree.getRootNode();
        int i = 0;
        while (i < path.size() && parentNode != null) {
            parentNode.ensureChildrenLoaded();
            parentNode.setExpanded(true);
            Object childKey = ((LookupRow)path.get(i)).getKey();
            ITreeNode nextNode = null;
            ITreeNode[] iTreeNodeArray = parentNode.getChildNodes();
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode n3 = iTreeNodeArray[n2];
                if (n3.getCell().getValue() instanceof LookupRow && CompareUtility.equals((Object)((LookupRow)n3.getCell().getValue()).getKey(), (Object)childKey)) {
                    nextNode = n3;
                    break;
                }
                ++n2;
            }
            parentNode = nextNode;
            ++i;
        }
        return parentNode;
    }

    private LookupRow getLookupRowFor(Object key) throws ProcessingException {
        ISmartField<? extends Object> sf;
        LookupRow[] lookupRowArray;
        if (key instanceof Number && ((Number)key).longValue() == 0L) {
            key = null;
        }
        if (key != null && (lookupRowArray = (sf = this.getSmartField()).callKeyLookup(key)).length != 0) {
            LookupRow row = lookupRowArray[0];
            return row;
        }
        return null;
    }

    private class FormHandler
    extends AbstractFormHandler {
        private FormHandler() {
        }

        @Override
        protected void execLoad() throws ProcessingException {
            SmartTreeForm.this.getActiveStateRadioButtonGroup().setVisible(SmartTreeForm.this.getSmartField().isActiveFilterEnabled());
            SmartTreeForm.this.getActiveStateRadioButtonGroup().setValue(SmartTreeForm.this.getSmartField().getActiveFilter());
            SmartTreeForm.this.getNewButton().setEnabled(SmartTreeForm.this.getSmartField().getBrowseNewText() != null);
            SmartTreeForm.this.getNewButton().setLabel(SmartTreeForm.this.getSmartField().getBrowseNewText());
            SmartTreeForm.this.getResultTreeField().loadRootNode();
            SmartTreeForm.this.updateActiveFilter();
            SmartTreeForm.this.update(false, true);
            if (SmartTreeForm.this.getSmartField().isBrowseAutoExpandAll() && !SmartTreeForm.this.getSmartField().isBrowseLoadIncremental()) {
                ITree tree = SmartTreeForm.this.getResultTreeField().getTree();
                tree.expandAll(SmartTreeForm.this.getResultTreeField().getTree().getRootNode());
            }
        }

        @Override
        protected boolean execValidate() throws ProcessingException {
            return SmartTreeForm.this.getAcceptedProposal() != null;
        }
    }

    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Override
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        @Order(value=20.0)
        public class ActiveStateRadioButtonGroup
        extends AbstractRadioButtonGroup<TriState> {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected void execChangedValue() throws ProcessingException {
                if (this.isVisible() && !SmartTreeForm.this.isFormLoading()) {
                    SmartTreeForm.this.getSmartField().setActiveFilter((TriState)this.getValue());
                    SmartTreeForm.this.updateActiveFilter();
                }
            }

            @Order(value=3.0)
            public class ActiveAndInactiveButton
            extends AbstractButton {
                @Override
                protected int getConfiguredDisplayStyle() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveAndInactiveStates", (String[])new String[0]);
                }

                @Override
                protected Object getConfiguredRadioValue() {
                    return TriState.UNDEFINED;
                }
            }

            @Order(value=1.0)
            public class ActiveButton
            extends AbstractButton {
                @Override
                protected int getConfiguredDisplayStyle() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"ActiveStates", (String[])new String[0]);
                }

                @Override
                protected Object getConfiguredRadioValue() {
                    return TriState.TRUE;
                }
            }

            @Order(value=2.0)
            public class InactiveButton
            extends AbstractButton {
                @Override
                protected int getConfiguredDisplayStyle() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"InactiveStates", (String[])new String[0]);
                }

                @Override
                protected Object getConfiguredRadioValue() {
                    return TriState.FALSE;
                }
            }
        }

        @Order(value=25.0)
        public class NewButton
        extends AbstractButton {
            @Override
            protected boolean getConfiguredVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredEnabled() {
                return false;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredFillHorizontal() {
                return false;
            }

            @Override
            protected int getConfiguredDisplayStyle() {
                return 3;
            }

            @Override
            protected boolean getConfiguredProcessButton() {
                return false;
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                SmartTreeForm.this.getSmartField().doBrowseNew(SmartTreeForm.this.getSearchText());
            }
        }

        @Order(value=10.0)
        public class ResultTreeField
        extends AbstractTreeField {
            @Override
            protected boolean getConfiguredAutoLoad() {
                return false;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }

            @Override
            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected void execLoadChildNodes(ITreeNode parentNode) throws ProcessingException {
                ITreeNode[] subTree;
                ISmartField<? extends Object> sf = SmartTreeForm.this.getSmartField();
                if (sf.isBrowseLoadIncremental()) {
                    LookupRow b = (LookupRow)(parentNode != null ? parentNode.getCell().getValue() : null);
                    LookupRow[] data = sf.callSubTreeLookup(b != null ? b.getKey() : null, TriState.UNDEFINED);
                    subTree = new P_TreeNodeBuilder().createTreeNodes(data, 0, false);
                } else if (parentNode == this.getTree().getRootNode()) {
                    LookupRow[] data = sf.callBrowseLookup("*", 100000, TriState.UNDEFINED);
                    subTree = new P_TreeNodeBuilder().createTreeNodes(data, 0, true);
                } else {
                    subTree = parentNode.getChildNodes();
                }
                this.getTree().removeAllChildNodes(parentNode);
                this.getTree().addChildNodes(parentNode, subTree);
                if (this.isAutoExpandAll()) {
                    this.getTree().expandAll(parentNode);
                }
            }

            private class P_TreeNodeBuilder
            extends AbstractTreeNodeBuilder {
                private P_TreeNodeBuilder() {
                }

                @Override
                protected ITreeNode createEmptyTreeNode() throws ProcessingException {
                    ITreeNode node = ResultTreeField.this.createTreeNode();
                    if (ResultTreeField.this.getTree().getIconId() != null) {
                        Cell cell = node.getCellForUpdate();
                        cell.setIconId(ResultTreeField.this.getTree().getIconId());
                    }
                    return node;
                }
            }

            @Order(value=4.0)
            public class Tree
            extends AbstractTree {
                @Override
                protected boolean getConfiguredMultiSelect() {
                    return false;
                }

                @Override
                protected boolean getConfiguredRootNodeVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredScrollToSelection() {
                    return true;
                }

                @Override
                protected void execNodeClick(ITreeNode node) throws ProcessingException {
                    SmartTreeForm.this.doOk();
                }
            }
        }

        @Order(value=30.0)
        public class StatusField
        extends AbstractLabelField {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }
        }
    }

    private class P_ActiveNodesFilter
    implements ITreeNodeFilter {
        private TriState m_ts;

        public void update(TriState ts) {
            this.m_ts = ts;
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            if (this.m_ts.isUndefined()) {
                return true;
            }
            LookupRow row = (LookupRow)node.getCell().getValue();
            if (row != null) {
                return row.isActive() == this.m_ts.equals((Object)TriState.TRUE);
            }
            return true;
        }
    }

    private class P_MatchingNodesFilter
    implements ITreeNodeFilter {
        private Pattern m_searchPattern;

        public void update(String text) {
            this.m_searchPattern = SmartTreeForm.this.execCreatePatternForTreeFilter(text);
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            return SmartTreeForm.this.execAcceptNodeByTreeFilter(this.m_searchPattern, node, level);
        }
    }
}

