/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNodeBuilder;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBoxFilterBox;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ActiveOrCheckedNodesFilter;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.CheckedNodesFilter;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBoxUIFacade;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTreeBox<T>
extends AbstractValueField<T[]>
implements ITreeBox<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTreeBox.class);
    private ITree m_tree;
    private LookupCall m_lookupCall;
    private Class<? extends ICodeType> m_codeTypeClass;
    private boolean m_valueTreeSyncActive;
    private boolean m_autoExpandAll;
    private boolean m_loadIncremental;
    private ITreeBoxUIFacade m_uiFacade;
    private ITreeNodeFilter m_activeNodesFilter;
    private ITreeNodeFilter m_checkedNodesFilter;
    private IFormField[] m_fields;

    @ConfigOperation
    @Order(value=240.0)
    protected void execLoadChildNodes(ITreeNode parentNode) throws ProcessingException {
        ITreeNode[] children = this.isLoadIncremental() ? this.callChildLookup(parentNode) : this.callCompleteTreeLookup();
        this.m_tree.removeAllChildNodes(parentNode);
        this.m_tree.addChildNodes(parentNode, children);
        parentNode.setChildrenLoaded(true);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="lookupCall")
    protected Class<? extends LookupCall> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredLoadIncremental() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAutoExpandAll() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=290.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredFilterActiveNodes() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFilterCheckedNodes() {
        return false;
    }

    @Override
    @ConfigPropertyValue(value="1.0")
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    private Class<? extends IFormField>[] getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IFormField.class);
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execPrepareLookup(LookupCall call, ITreeNode parent) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execFilterLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execFilterNewNode(ITreeNode newNode, int treeLevel) throws ProcessingException {
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.length == 1) {
            return f[0];
        }
        Class[] classArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.getDeclaringClass() != AbstractTreeBox.class) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
        this.loadRootNode();
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = this.createUIFacade();
        this.m_fields = new IFormField[0];
        super.initConfig();
        this.setFilterActiveNodes(this.getConfiguredFilterActiveNodes());
        this.setFilterActiveNodesValue(TriState.TRUE);
        this.setFilterCheckedNodes(this.getConfiguredFilterCheckedNodes());
        this.setFilterCheckedNodesValue(this.getConfiguredFilterCheckedNodes());
        this.setAutoExpandAll(this.getConfiguredAutoExpandAll());
        this.setLoadIncremental(this.getConfiguredLoadIncremental());
        try {
            this.m_tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTree());
            this.m_tree.setRootNode(this.getTreeNodeBuilder().createTreeNode(new LookupRow(null, "Root"), 0, false));
            this.m_tree.setAutoDiscardOnDelete(false);
            this.updateActiveNodesFilter();
            this.updateCheckedNodesFilter();
            this.m_tree.addTreeListener(new TreeAdapter(){

                @Override
                public void treeChanged(TreeEvent e) {
                    switch (e.getType()) {
                        case 40: {
                            if (AbstractTreeBox.this.getTree().isCheckable()) break;
                            AbstractTreeBox.this.syncTreeToValue();
                            break;
                        }
                        case 20: {
                            if (!AbstractTreeBox.this.getTree().isCheckable()) break;
                            AbstractTreeBox.this.syncTreeToValue();
                        }
                    }
                }
            });
            this.m_tree.setEnabled(this.isEnabled());
            if (this.getConfiguredIconId() != null) {
                this.m_tree.setIconId(this.getConfiguredIconId());
            }
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
        if (this.getConfiguredLookupCall() != null) {
            try {
                LookupCall call = this.getConfiguredLookupCall().newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractTreeBox.this.m_tree != null) {
                    String name = e.getPropertyName();
                    if ("enabled".equals(name)) {
                        AbstractTreeBox.this.m_tree.setEnabled(AbstractTreeBox.this.isEnabled());
                    } else if ("filterCheckedNodesValue".equals(name)) {
                        AbstractTreeBox.this.updateCheckedNodesFilter();
                    } else if ("filterActiveNodesValue".equals(name)) {
                        AbstractTreeBox.this.updateActiveNodesFilter();
                    }
                }
            }
        });
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        Class<IFormField>[] fieldArray = this.getConfiguredFields();
        int i = 0;
        while (i < fieldArray.length) {
            try {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldArray[i]);
                fieldList.add(f);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("field: " + fieldArray[i].getName(), t));
            }
            ++i;
        }
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        this.m_fields = fieldList.toArray(new IFormField[0]);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTree().initTree();
        if (this.getConfiguredAutoLoad()) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.loadRootNode();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTree().disposeTree();
    }

    public TreeBoxFilterBox getTreeBoxFilterBox() {
        return this.getFieldByClass((Class)TreeBoxFilterBox.class);
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    protected ITreeBoxUIFacade createUIFacade() {
        return new P_TreeBoxUIFacade();
    }

    @Override
    public ITreeBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void loadRootNode() throws ProcessingException {
        this.loadChildNodes(this.m_tree.getRootNode());
    }

    @Override
    public final void loadChildNodes(ITreeNode parentNode) throws ProcessingException {
        if (this.m_tree != null) {
            try {
                this.m_valueTreeSyncActive = true;
                this.m_tree.setTreeChanging(true);
                this.execLoadChildNodes(parentNode);
                if (!this.isLoadIncremental()) {
                    ITreeVisitor v = new ITreeVisitor(){

                        @Override
                        public boolean visit(ITreeNode node) {
                            if (node.getChildNodeCount() == 0) {
                                node.setLeafInternal(true);
                            } else {
                                node.setLeafInternal(false);
                            }
                            return true;
                        }
                    };
                    this.getTree().visitNode(this.getTree().getRootNode(), v);
                }
                if (this.isAutoExpandAll()) {
                    this.m_tree.expandAll(parentNode);
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
                this.m_valueTreeSyncActive = false;
            }
            this.syncValueToTree();
        }
    }

    public AbstractTreeNodeBuilder getTreeNodeBuilder() {
        return new P_TreeNodeBuilder();
    }

    private void prepareLookupCall(LookupCall call, ITreeNode parent) throws ProcessingException {
        this.prepareLookupCallInternal(call, parent);
        this.execPrepareLookup(call, parent);
    }

    private void prepareLookupCallInternal(LookupCall call, ITreeNode parent) {
        if (parent != null) {
            call.setRec(parent.getPrimaryKey());
        } else {
            call.setRec(null);
        }
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    @Override
    public final LookupCall getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(LookupCall call) {
        this.m_lookupCall = call;
    }

    @Override
    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = new CodeLookupCall(this.m_codeTypeClass);
        }
    }

    @Override
    public ITreeNode[] callChildLookup(ITreeNode parentNode) throws ProcessingException {
        LookupRow[] data = null;
        LookupCall call = this.getLookupCall();
        if (call != null) {
            call = (LookupCall)call.clone();
            this.prepareLookupCall(call, parentNode);
            data = call.getDataByRec();
            data = this.filterLookupResult(call, data);
            ITreeNode[] subTree = this.getTreeNodeBuilder().createTreeNodes(data, 0, false);
            this.filterNewNodesRec(subTree, parentNode != null ? parentNode.getTreeLevel() + 1 : 0);
            return subTree;
        }
        return new ITreeNode[0];
    }

    @Override
    public ITreeNode[] callCompleteTreeLookup() throws ProcessingException {
        LookupRow[] data = null;
        LookupCall call = this.getLookupCall();
        if (call != null) {
            call = (LookupCall)call.clone();
            this.prepareLookupCall(call, null);
            data = call.getDataByAll();
            data = this.filterLookupResult(call, data);
            if (data != null && data.length > 1000) {
                LOG.warn("TreeBox " + this.getClass().getSimpleName() + " has loadIncremental=false but produced more than 1000 rows; check if this is intended.");
            }
            ITreeNode[] subTree = this.getTreeNodeBuilder().createTreeNodes(data, 0, true);
            this.filterNewNodesRec(subTree, 0);
            return subTree;
        }
        return new ITreeNode[0];
    }

    private LookupRow[] filterLookupResult(LookupCall call, LookupRow[] data) throws ProcessingException {
        ArrayList<Object> result = data != null ? new ArrayList<LookupRow>(Arrays.asList(data)) : new ArrayList();
        this.execFilterLookupResult(call, result);
        int len = 0;
        for (LookupRow r : result) {
            if (r == null) continue;
            ++len;
        }
        LookupRow[] a = new LookupRow[len];
        int index = 0;
        for (LookupRow r : result) {
            if (r == null) continue;
            a[index] = r;
            ++index;
        }
        return a;
    }

    private void filterNewNodesRec(ITreeNode[] nodes, int level) throws ProcessingException {
        if (nodes != null) {
            ITreeNode[] iTreeNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode node = iTreeNodeArray[n2];
                if (node != null) {
                    this.execFilterNewNode(node, level);
                    this.filterNewNodesRec(node.getChildNodes(), level + 1);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToTree();
    }

    @Override
    protected String formatValueInternal(T[] validValue) {
        if (validValue == null || validValue.length == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        ITreeNode[] nodes = this.getTree().findNodes(validValue);
        int i = 0;
        while (i < nodes.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(nodes[i].getCell().getText());
            ++i;
        }
        return b.toString();
    }

    @Override
    protected T[] validateValueInternal(T[] rawValue) {
        ITree tree;
        Object[] validValue = rawValue;
        if (validValue != null && validValue.length == 0) {
            validValue = null;
        }
        if ((tree = this.getTree()) != null && validValue != null && (tree.isCheckable() && !tree.isMultiCheck() || !tree.isCheckable() && !tree.isMultiSelect()) && validValue.length > 1) {
            LOG.warn(String.valueOf(this.getClass().getName()) + " only accepts a single value. Got " + Arrays.toString(validValue) + ". Using only first value.");
            Object[] newArray = (Object[])Array.newInstance(validValue.getClass().getComponentType(), 1);
            newArray[0] = validValue[0];
            validValue = newArray;
        }
        return validValue;
    }

    @Override
    public T getSingleValue() {
        Object[] a = (Object[])this.getValue();
        if (a != null && a.length > 0) {
            return (T)a[0];
        }
        return null;
    }

    @Override
    public void setSingleValue(T value) {
        if (value == null) {
            this.setValue(null);
        } else {
            Object[] array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 1);
            array[0] = value;
            this.setValue(array);
        }
    }

    @Override
    public int getCheckedKeyCount() {
        Object[] keys = (Object[])this.getValue();
        if (keys != null) {
            return keys.length;
        }
        return 0;
    }

    @Override
    public T getCheckedKey() {
        T[] a = this.getCheckedKeys();
        if (a != null && a.length > 0) {
            return a[0];
        }
        return null;
    }

    @Override
    public T[] getCheckedKeys() {
        return (Object[])this.getValue();
    }

    @Override
    public LookupRow getCheckedLookupRow() {
        LookupRow[] a = this.getCheckedLookupRows();
        if (a != null && a.length > 0) {
            return a[0];
        }
        return null;
    }

    @Override
    public LookupRow[] getCheckedLookupRows() {
        LookupRow[] lookupRows = null;
        ITreeNode[] treeNodes = this.getTree().getCheckedNodes();
        if (treeNodes != null) {
            lookupRows = new LookupRow[treeNodes.length];
            int i = 0;
            while (i < treeNodes.length) {
                ITreeNode node = treeNodes[i];
                ICell cell = node.getCell();
                ITreeNode parentNode = node.getParentNode();
                lookupRows[i] = new LookupRow(node.getPrimaryKey(), cell.getText(), cell.getIconId(), cell.getTooltipText(), cell.getBackgroundColor(), cell.getForegroundColor(), cell.getFont(), cell.isEnabled(), parentNode != null ? parentNode.getPrimaryKey() : null, this.isNodeActive(node));
                ++i;
            }
        }
        return lookupRows;
    }

    @Override
    public void checkKey(T key) {
        if (key == null) {
            this.checkKeys(null);
        } else {
            Object[] array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 1);
            array[0] = key;
            this.checkKeys(array);
        }
    }

    @Override
    public void checkKeys(T[] keys) {
        this.setValue(keys);
    }

    @Override
    public void uncheckAllKeys() {
        this.checkKeys(null);
    }

    @Override
    public T[] getUncheckedKeys() {
        Object[] array;
        HashSet<Object> set = new HashSet<Object>();
        Object[] a = (Object[])this.getInitValue();
        if (a != null) {
            set.addAll(Arrays.asList(a));
        }
        if ((a = this.getCheckedKeys()) != null) {
            set.removeAll(Arrays.asList(a));
        }
        if ((a = set.toArray(array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 0))).length == 0) {
            a = null;
        }
        return a;
    }

    @Override
    public void checkAllKeys() {
        final HashSet keySet = new HashSet();
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.getPrimaryKey() != null) {
                    keySet.add(node.getPrimaryKey());
                }
                return true;
            }
        };
        this.m_tree.visitNode(this.m_tree.getRootNode(), v);
        Object[] array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 0);
        this.checkKeys(keySet.toArray(array));
    }

    @Override
    public boolean isLoadIncremental() {
        return this.m_loadIncremental;
    }

    @Override
    public void setLoadIncremental(boolean b) {
        this.m_loadIncremental = b;
    }

    @Override
    public boolean isAutoExpandAll() {
        return this.m_autoExpandAll;
    }

    @Override
    public void setAutoExpandAll(boolean b) {
        this.m_autoExpandAll = b;
    }

    @Override
    public boolean isNodeActive(ITreeNode node) {
        if (node instanceof P_InternalTreeNode) {
            return ((P_InternalTreeNode)node).isActive();
        }
        return false;
    }

    @Override
    public boolean isFilterActiveNodes() {
        return this.propertySupport.getPropertyBool("filterActiveNodes");
    }

    @Override
    public void setFilterActiveNodes(boolean b) {
        this.propertySupport.setPropertyBool("filterActiveNodes", b);
    }

    @Override
    public boolean getFilterCheckedNodesValue() {
        return this.propertySupport.getPropertyBool("filterCheckedNodesValue");
    }

    @Override
    public void setFilterCheckedNodesValue(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedNodesValue", b);
    }

    @Override
    public boolean isFilterCheckedNodes() {
        return this.propertySupport.getPropertyBool("filterCheckedNodes");
    }

    @Override
    public void setFilterCheckedNodes(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedNodes", b);
    }

    @Override
    public TriState getFilterActiveNodesValue() {
        return (TriState)this.propertySupport.getProperty("filterActiveNodesValue");
    }

    @Override
    public void setFilterActiveNodesValue(TriState t) {
        if (t == null) {
            t = TriState.TRUE;
        }
        this.propertySupport.setProperty("filterActiveNodesValue", (Object)t);
    }

    private void updateActiveNodesFilter() {
        try {
            this.m_tree.setTreeChanging(true);
            if (this.m_activeNodesFilter != null) {
                this.m_tree.removeNodeFilter(this.m_activeNodesFilter);
                this.m_activeNodesFilter = null;
            }
            this.m_activeNodesFilter = new ActiveOrCheckedNodesFilter(this, this.getFilterActiveNodesValue());
            this.m_tree.addNodeFilter(this.m_activeNodesFilter);
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    private void updateCheckedNodesFilter() {
        try {
            this.m_tree.setTreeChanging(true);
            if (this.m_checkedNodesFilter != null) {
                this.m_tree.removeNodeFilter(this.m_checkedNodesFilter);
                this.m_checkedNodesFilter = null;
            }
            if (this.getFilterCheckedNodesValue()) {
                this.m_checkedNodesFilter = new CheckedNodesFilter();
                this.m_tree.addNodeFilter(this.m_checkedNodesFilter);
            }
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    private void syncValueToTree() {
        if (this.m_valueTreeSyncActive) {
            return;
        }
        try {
            this.m_valueTreeSyncActive = true;
            this.getTree().setTreeChanging(true);
            Object[] checkedKeys = this.getCheckedKeys();
            ITreeNode[] checkedNodes = this.m_tree.findNodes(checkedKeys);
            this.getTree().visitTree(new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    node.setChecked(false);
                    return true;
                }
            });
            ITreeNode[] iTreeNodeArray = checkedNodes;
            int n = checkedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode node = iTreeNodeArray[n2];
                node.setChecked(true);
                ++n2;
            }
            if (!this.getTree().isCheckable()) {
                this.getTree().selectNodes(checkedNodes, false);
            }
        }
        finally {
            this.getTree().setTreeChanging(false);
            this.m_valueTreeSyncActive = false;
        }
    }

    private void syncTreeToValue() {
        if (this.m_valueTreeSyncActive) {
            return;
        }
        try {
            this.m_valueTreeSyncActive = true;
            this.getTree().setTreeChanging(true);
            Object[] checkedKeys = null;
            ITreeNode[] checkedNodes = this.getTree().isCheckable() ? this.m_tree.getCheckedNodes() : this.m_tree.getSelectedNodes();
            checkedKeys = (Object[])Array.newInstance(this.getHolderType().getComponentType(), checkedNodes.length);
            int i = 0;
            while (i < checkedNodes.length) {
                checkedKeys[i] = checkedNodes[i].getPrimaryKey();
                ++i;
            }
            this.checkKeys(checkedKeys);
            if (!this.getTree().isCheckable()) {
                this.getTree().visitTree(new ITreeVisitor(){

                    @Override
                    public boolean visit(ITreeNode node) {
                        node.setChecked(node.isSelectedNode());
                        return true;
                    }
                });
            }
        }
        finally {
            this.getTree().setTreeChanging(false);
            this.m_valueTreeSyncActive = false;
        }
        if (!this.m_tree.getUIFacade().isUIProcessing()) {
            this.updateActiveNodesFilter();
        }
        this.updateCheckedNodesFilter();
    }

    public <F extends IFormField> F getFieldByClass(final Class<F> c) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (F)((IFormField)found.getValue());
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    public <X extends IFormField> X getFieldById(final String id, final Class<X> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (X)((IFormField)found.getValue());
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.length;
    }

    @Override
    public int getFieldIndex(IFormField f) {
        int i = 0;
        while (i < this.m_fields.length) {
            if (this.m_fields[i] == f) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IFormField[] getFields() {
        IFormField[] a = new IFormField[this.m_fields.length];
        System.arraycopy(this.m_fields, 0, a, 0, a.length);
        return a;
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i] instanceof ICompositeField ? !((ICompositeField)f[i]).visitFields(visitor, startLevel + 1) : !visitor.visitField(f[i], startLevel, index)) {
                return false;
            }
            ++index;
            ++i;
        }
        return true;
    }

    @Override
    public final int getGridColumnCount() {
        return 1;
    }

    @Override
    public final int getGridRowCount() {
        return 1;
    }

    @Override
    public void rebuildFieldGrid() {
    }

    @Order(value=10000.0)
    public class DefaultTreeBoxTree
    extends AbstractTree {
        @Override
        @ConfigPropertyValue(value="false")
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        @Override
        @ConfigPropertyValue(value="true")
        protected boolean getConfiguredCheckable() {
            return true;
        }

        @Override
        @ConfigPropertyValue(value="false")
        protected boolean getConfiguredRootNodeVisible() {
            return false;
        }
    }

    private class P_InternalTreeNode
    extends AbstractTreeNode {
        private boolean m_active;

        private P_InternalTreeNode() {
        }

        public boolean isActive() {
            return this.m_active;
        }

        public void setActive(boolean b) {
            this.m_active = b;
        }

        @Override
        public void loadChildren() throws ProcessingException {
            if (AbstractTreeBox.this.isLoadIncremental()) {
                AbstractTreeBox.this.loadChildNodes(this);
            } else {
                this.setChildrenLoaded(true);
            }
        }
    }

    protected class P_TreeBoxUIFacade
    implements ITreeBoxUIFacade {
        protected P_TreeBoxUIFacade() {
        }
    }

    private class P_TreeNodeBuilder
    extends AbstractTreeNodeBuilder {
        private P_TreeNodeBuilder() {
        }

        @Override
        protected ITreeNode createEmptyTreeNode() throws ProcessingException {
            return new P_InternalTreeNode();
        }

        @Override
        public ITreeNode createTreeNode(LookupRow lookupRow, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
            P_InternalTreeNode treeNode = (P_InternalTreeNode)super.createTreeNode(lookupRow, nodeStatus, markChildrenLoaded);
            treeNode.setActive(lookupRow.isActive());
            return treeNode;
        }
    }

    @Order(value=1.0)
    public class TreeBoxFilterBox
    extends AbstractTreeBoxFilterBox {
        @Override
        protected ITreeBox getTreeBox() {
            return AbstractTreeBox.this;
        }
    }
}

