/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.wsdl.WSDLException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.jaxws.AbstractWebServiceNewOperation;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.core.s.util.maven.Pom;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.ResourceTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebServiceNewWizardPage
extends AbstractWizardPage {
    public static final String PROP_WEB_SERVICE_TYPE = "webServiceType";
    public static final String PROP_CONSUMER_WSDL_URL = "consumerWsdlUrl";
    public static final String PROP_PROVIDER_WSDL_URL = "providerWsdlUrl";
    public static final String PROP_PROVIDER_WSDL_NAME = "providerWsdlName";
    public static final String PROP_IS_CREATE_NEW_PROJECT = "isCreateNewProject";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_EXISTING_JAXWS_PROJECT = "jaxwsProject";
    public static final String PROP_SERVER_PROJECT = "serverProject";
    public static final String PROP_ARTIFACT_ID = "artifactId";
    private ResourceTextField m_consumerWsdlUrlField;
    private ResourceTextField m_providerWsdlUrlField;
    private ProposalTextField m_existingJaxWsProjectField;
    private ProposalTextField m_packageField;
    private ProposalTextField m_serverProjectField;
    private StyledTextField m_artifactIdField;
    private StyledTextField m_providerWsdlNameField;
    private Button m_createConsumer;
    private Button m_createProviderFromExistingWsdl;
    private Button m_createProviderFromEmptyWsdl;
    private Button m_createNewProjectButton;
    private Button m_addToExistingProjectButton;
    private URL m_lastParsedWsdlUrl;
    private IStatus m_lastParsedWsdlUrlStatus;
    private boolean m_packageChanged;

    public WebServiceNewWizardPage() {
        super(WebServiceNewWizardPage.class.getName());
        this.setTitle("Create a new Web Service");
        this.setDescription(this.getTitle());
        this.initDefaults();
    }

    protected void initDefaults() {
        this.setPackageChanged(false);
        this.setIsCreateNewProjectInternal(true);
        this.setWebServiceTypeInternal(WebServiceType.CONSUMER_FROM_EXISTING_WSDL);
    }

    @Override
    protected void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        int labelWidth = 130;
        this.createTypeGroup(parent, labelWidth);
        this.createProjectGroup(parent, labelWidth);
        this.createAttributesGroup(parent, labelWidth);
        this.setViewState();
        this.m_consumerWsdlUrlField.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_webservice_page_context");
    }

    protected void createTypeGroup(Composite parent, int labelWidth) {
        Group typeGroupBox = FieldToolkit.createGroupBox(parent, "Type of Web Service");
        this.m_createConsumer = new Button((Composite)typeGroupBox, 16);
        this.m_createConsumer.setText("Create new Web Service Consumer");
        this.m_createConsumer.setSelection(WebServiceType.CONSUMER_FROM_EXISTING_WSDL == this.getWebServiceType());
        this.m_createConsumer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceNewWizardPage.this.setWebServiceTypeInternal(WebServiceType.CONSUMER_FROM_EXISTING_WSDL);
                WebServiceNewWizardPage.this.setViewState();
                WebServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_consumerWsdlUrlField = FieldToolkit.createResourceField((Composite)typeGroupBox, "WSDL URL", 1, labelWidth);
        this.m_consumerWsdlUrlField.setText(this.getConsumerWsdlUrl());
        this.m_consumerWsdlUrlField.addResourceChangedListener((newUrl, newFile) -> {
            String url = null;
            if (newUrl != null) {
                url = newUrl.toExternalForm();
            }
            this.setConsumerWsdlUrlInternal(url);
            this.pingStateChanging();
        });
        this.m_createProviderFromExistingWsdl = new Button((Composite)typeGroupBox, 16);
        this.m_createProviderFromExistingWsdl.setText("Create new Web Service Provider from existing WSDL");
        this.m_createProviderFromExistingWsdl.setSelection(WebServiceType.PROVIDER_FROM_EXISTING_WSDL == this.getWebServiceType());
        this.m_createProviderFromExistingWsdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceNewWizardPage.this.setWebServiceTypeInternal(WebServiceType.PROVIDER_FROM_EXISTING_WSDL);
                WebServiceNewWizardPage.this.setViewState();
                WebServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_providerWsdlUrlField = FieldToolkit.createResourceField((Composite)typeGroupBox, "WSDL URL", 1, labelWidth);
        this.m_providerWsdlUrlField.setText(this.getProviderWsdlUrl());
        this.m_providerWsdlUrlField.addResourceChangedListener((newUrl, newFile) -> {
            String url = null;
            if (newUrl != null) {
                url = newUrl.toExternalForm();
            }
            this.setProviderWsdlUrlInternal(url);
            this.pingStateChanging();
        });
        this.m_createProviderFromEmptyWsdl = new Button((Composite)typeGroupBox, 16);
        this.m_createProviderFromEmptyWsdl.setText("Create new Web Service Provider with empty WSDL");
        this.m_createProviderFromEmptyWsdl.setSelection(WebServiceType.PROVIDER_FROM_EMPTY_WSDL == this.getWebServiceType());
        this.m_createProviderFromEmptyWsdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceNewWizardPage.this.setWebServiceTypeInternal(WebServiceType.PROVIDER_FROM_EMPTY_WSDL);
                WebServiceNewWizardPage.this.setViewState();
                WebServiceNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_providerWsdlNameField = FieldToolkit.createStyledTextField((Composite)typeGroupBox, "Web Service Name", 1, labelWidth);
        this.m_providerWsdlNameField.setText(this.getWsdlName());
        this.m_providerWsdlNameField.setReadOnlySuffix("WebService");
        this.m_providerWsdlNameField.addModifyListener(e -> {
            this.setWsdlNameInternal(this.m_providerWsdlNameField.getText());
            this.pingStateChanging();
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)typeGroupBox);
        GridDataFactory.defaultsFor((Control)typeGroupBox).align(4, 0x1000000).grab(true, false).applyTo((Control)typeGroupBox);
        GridDataFactory.defaultsFor((Control)this.m_createConsumer).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createConsumer);
        GridDataFactory.defaultsFor((Control)this.m_consumerWsdlUrlField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_consumerWsdlUrlField);
        GridDataFactory.defaultsFor((Control)this.m_createProviderFromExistingWsdl).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createProviderFromExistingWsdl);
        GridDataFactory.defaultsFor((Control)this.m_providerWsdlUrlField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_providerWsdlUrlField);
        GridDataFactory.defaultsFor((Control)this.m_createProviderFromEmptyWsdl).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createProviderFromEmptyWsdl);
        GridDataFactory.defaultsFor((Control)this.m_providerWsdlNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_providerWsdlNameField);
    }

    protected void createProjectGroup(Composite parent, int labelWidth) {
        Group projectGroupBox = FieldToolkit.createGroupBox(parent, "Target Project");
        this.m_createNewProjectButton = new Button((Composite)projectGroupBox, 16);
        this.m_createNewProjectButton.setText("Create new project for this Web Service");
        this.m_createNewProjectButton.setSelection(this.isCreateNewProject());
        this.m_createNewProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceNewWizardPage.this.setIsCreateNewProjectInternal(true);
                WebServiceNewWizardPage.this.setViewState();
                WebServiceNewWizardPage.this.pingStateChanging();
            }
        });
        Predicate<IJavaProject> serverProjectsFilter = WebServiceNewWizardPage::isServerProject;
        this.m_serverProjectField = FieldToolkit.createProjectProposalField((Composite)projectGroupBox, "Add new Project to", serverProjectsFilter, labelWidth);
        this.m_serverProjectField.acceptProposal(this.getServerProject());
        this.m_serverProjectField.addProposalListener(proposal -> {
            IJavaProject jp = (IJavaProject)proposal;
            this.setServerProjectInternal(jp);
            this.pingStateChanging();
        });
        this.m_artifactIdField = FieldToolkit.createStyledTextField((Composite)projectGroupBox, "Artifact Id", 1, labelWidth);
        this.m_artifactIdField.setText(this.getArtifactId());
        this.m_artifactIdField.addModifyListener(e -> {
            this.setArtifactIdInternal(this.m_artifactIdField.getText());
            this.pingStateChanging();
        });
        this.m_addToExistingProjectButton = new Button((Composite)projectGroupBox, 16);
        this.m_addToExistingProjectButton.setText("Add Web Service to an existing Project");
        this.m_addToExistingProjectButton.setSelection(!this.isCreateNewProject());
        this.m_addToExistingProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceNewWizardPage.this.setIsCreateNewProjectInternal(false);
                WebServiceNewWizardPage.this.setViewState();
                WebServiceNewWizardPage.this.pingStateChanging();
            }
        });
        Predicate<IJavaProject> jaxwsProjectsFilter = WebServiceNewWizardPage::isJaxWsProject;
        this.m_existingJaxWsProjectField = FieldToolkit.createProjectProposalField((Composite)projectGroupBox, "Web Service Project", jaxwsProjectsFilter, labelWidth);
        this.m_existingJaxWsProjectField.acceptProposal(this.getExistingJaxWsProject());
        this.m_existingJaxWsProjectField.addProposalListener(proposal -> {
            IJavaProject javaProject = (IJavaProject)proposal;
            this.setExistingJaxWsProjectInternal(javaProject);
            this.pingStateChanging();
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)projectGroupBox);
        GridDataFactory.defaultsFor((Control)projectGroupBox).align(4, 0x1000000).grab(true, false).applyTo((Control)projectGroupBox);
        GridDataFactory.defaultsFor((Control)this.m_createNewProjectButton).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createNewProjectButton);
        GridDataFactory.defaultsFor((Control)this.m_serverProjectField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_serverProjectField);
        GridDataFactory.defaultsFor((Control)this.m_artifactIdField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_artifactIdField);
        GridDataFactory.defaultsFor((Control)this.m_addToExistingProjectButton).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_addToExistingProjectButton);
        GridDataFactory.defaultsFor((Control)this.m_existingJaxWsProjectField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_existingJaxWsProjectField);
    }

    protected void createAttributesGroup(Composite parent, int labelWidth) {
        Group attributesGroupBox = FieldToolkit.createGroupBox(parent, "Web Service Artifacts Package");
        this.m_packageField = FieldToolkit.createPackageField((Composite)attributesGroupBox, "Target Package", this.getExistingJaxWsProject(), labelWidth);
        this.m_packageField.setText(this.getTargetPackage());
        this.m_packageField.addModifyListener(e -> {
            if (!this.isPackageChanged() && !this.isStateChanging()) {
                this.setPackageChanged(true);
            }
            this.setTargetPackageInternal(this.m_packageField.getText());
            this.pingStateChanging();
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)attributesGroupBox);
        GridDataFactory.defaultsFor((Control)attributesGroupBox).align(4, 0x1000000).grab(true, false).applyTo((Control)attributesGroupBox);
        GridDataFactory.defaultsFor((Control)this.m_packageField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_packageField);
    }

    protected void guessArtifactId() {
        if (Strings.hasText((CharSequence)this.getArtifactId())) {
            return;
        }
        if (!this.isCreateNewProject()) {
            return;
        }
        if (!JdtUtils.exists((IJavaElement)this.getServerProject())) {
            return;
        }
        this.setArtifactId(String.valueOf(this.getServerProject().getElementName()) + ".ws");
    }

    protected void guessPackage() {
        String baseName;
        Document pom;
        if (this.isPackageChanged()) {
            return;
        }
        Optional groupId = Optional.empty();
        Optional<String> artifactId = Optional.empty();
        if (this.isCreateNewProject()) {
            if (Strings.hasText((CharSequence)this.getArtifactId()) && JdtUtils.exists((IJavaElement)this.getServerProject())) {
                pom = WebServiceNewWizardPage.getPomDocument(this.getServerProject());
                groupId = Pom.groupId((Document)pom);
                artifactId = Optional.ofNullable(this.getArtifactId());
            }
        } else if (JdtUtils.exists((IJavaElement)this.getExistingJaxWsProject())) {
            pom = WebServiceNewWizardPage.getPomDocument(this.getExistingJaxWsProject());
            groupId = Pom.groupId((Document)pom);
            artifactId = Pom.artifactId((Document)pom);
        }
        if (!artifactId.isPresent()) {
            return;
        }
        if (WebServiceType.PROVIDER_FROM_EMPTY_WSDL == this.getWebServiceType()) {
            baseName = this.getWsdlName();
            if (Strings.hasText((CharSequence)baseName)) {
                baseName = JaxWsUtils.removeCommonSuffixes((String)baseName.toLowerCase(Locale.ENGLISH));
            }
        } else {
            baseName = WebServiceType.PROVIDER_FROM_EXISTING_WSDL == this.getWebServiceType() ? WebServiceNewWizardPage.getWebServiceNameFromUrl(this.getProviderWsdlUrl()) : WebServiceNewWizardPage.getWebServiceNameFromUrl(this.getConsumerWsdlUrl());
        }
        if (Strings.isBlank((CharSequence)baseName)) {
            return;
        }
        StringBuilder pckBuilder = new StringBuilder();
        if (groupId.isPresent() && !artifactId.get().startsWith((String)groupId.get())) {
            pckBuilder.append((String)groupId.get());
            pckBuilder.append('.');
        }
        pckBuilder.append(artifactId.get());
        pckBuilder.append('.');
        pckBuilder.append(baseName);
        this.setTargetPackage(pckBuilder.toString());
    }

    protected static String getWebServiceNameFromUrl(String url) {
        if (Strings.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            String file = Paths.get(new URL(url).toURI()).getFileName().toString();
            if (Strings.hasText((CharSequence)file)) {
                int lastDotPos = (file = file.toLowerCase(Locale.ENGLISH)).lastIndexOf(46);
                if (lastDotPos > 0) {
                    file = file.substring(0, lastDotPos);
                }
                return JaxWsUtils.removeCommonSuffixes((String)file);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            SdkLog.debug((String)"Invalid URL passed.", (Object[])new Object[]{e});
        }
        return null;
    }

    protected static Document getPomDocument(IJavaProject project) {
        try {
            return S2eUtils.getPomDocument((IProject)project.getProject());
        }
        catch (RuntimeException e) {
            SdkLog.debug((String)"Unable to load pom of project '{}'.", (Object[])new Object[]{project.getElementName(), e});
            return null;
        }
    }

    protected static boolean isServerProject(IJavaProject jp) {
        try {
            return JdtUtils.exists((IJavaElement)jp.findType("org.eclipse.scout.rt.server.IServerSession")) && !jp.getProject().getFolder("src/main/webapp/WEB-INF").exists() && !Files.exists(AbstractWebServiceNewOperation.getWsdlRootFolder((Path)jp.getProject().getLocation().toFile().toPath()), new LinkOption[0]);
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Cannot check type of project '{}'. This project will be ignored.", (Object[])new Object[]{jp.getElementName(), e});
            return false;
        }
    }

    protected static boolean isJaxWsProject(IJavaProject jp) {
        Path wsdlFolder;
        IProject project;
        block11: {
            block10: {
                Optional primarySourceFolderOpt;
                block9: {
                    block8: {
                        Path projectPath;
                        block7: {
                            project = jp.getProject();
                            projectPath = project.getLocation().toFile().toPath();
                            wsdlFolder = AbstractWebServiceNewOperation.getWsdlRootFolder((Path)projectPath);
                            if (Files.isDirectory(wsdlFolder, new LinkOption[0])) break block7;
                            return false;
                        }
                        Path bindingFolder = AbstractWebServiceNewOperation.getBindingRootFolder((Path)projectPath);
                        if (Files.isDirectory(bindingFolder, new LinkOption[0])) break block8;
                        return false;
                    }
                    primarySourceFolderOpt = S2eUtils.primarySourceFolder((IJavaProject)jp);
                    if (primarySourceFolderOpt.isPresent()) break block9;
                    return false;
                }
                IPackageFragmentRoot primarySourceFolder = (IPackageFragmentRoot)primarySourceFolderOpt.get();
                if (JdtUtils.exists((IJavaElement)primarySourceFolder) && primarySourceFolder.getResource().getProjectRelativePath().toString().toLowerCase(Locale.ENGLISH).contains("java")) break block10;
                return false;
            }
            if (JdtUtils.exists((IJavaElement)jp.findType("org.eclipse.scout.rt.server.jaxws.consumer.AbstractWebServiceClient"))) break block11;
            return false;
        }
        try {
            String prefix = "p";
            String p = String.valueOf(prefix) + ':';
            StringBuilder bindingFilesXpathBuilder = new StringBuilder();
            bindingFilesXpathBuilder.append(p).append("project").append('/').append(p).append("build").append('/').append(p).append("plugins").append('/').append(p).append("plugin").append("[./").append(p).append("groupId").append("='").append("com.helger.maven").append("' and ./").append(p).append(PROP_ARTIFACT_ID).append("='").append("jaxws-maven-plugin").append("']");
            List elements = Xml.evaluateXPath((String)bindingFilesXpathBuilder.toString(), (Node)S2eUtils.getPomDocument((IProject)project), (String)prefix, (String)"http://maven.apache.org/POM/4.0.0");
            return !elements.isEmpty() || !WebServiceNewWizardPage.containsWsdls(wsdlFolder);
        }
        catch (XPathExpressionException | JavaModelException e) {
            SdkLog.warning((String)"Cannot check type of project '{}'. This project will be ignored.", (Object[])new Object[]{jp.getElementName(), e});
            return false;
        }
    }

    protected static boolean containsWsdls(Path wsdlFolder) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> paths = Files.walk(wsdlFolder, new FileVisitOption[0]);){
                return paths.filter(p -> p.getFileName().toString().endsWith(".wsdl")).filter(path -> Files.isRegularFile(path, new LinkOption[0])).anyMatch(Files::isReadable);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            SdkLog.warning((String)"Unable to search WSDL files in folder '{}'.", (Object[])new Object[]{wsdlFolder, e});
            return false;
        }
    }

    protected void setViewState() {
        this.m_artifactIdField.setEnabled(this.isCreateNewProject());
        this.m_serverProjectField.setEnabled(this.isCreateNewProject());
        this.m_existingJaxWsProjectField.setEnabled(!this.isCreateNewProject());
        this.m_consumerWsdlUrlField.setEnabled(WebServiceType.CONSUMER_FROM_EXISTING_WSDL == this.getWebServiceType());
        this.m_providerWsdlUrlField.setEnabled(WebServiceType.PROVIDER_FROM_EXISTING_WSDL == this.getWebServiceType());
        this.m_providerWsdlNameField.setEnabled(WebServiceType.PROVIDER_FROM_EMPTY_WSDL == this.getWebServiceType());
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusWsdlUrl());
        multiStatus.add(this.getStatusWsdlName());
        multiStatus.add(this.getStatusServerProject());
        multiStatus.add(this.getStatusArtifactId());
        multiStatus.add(this.getStatusExistingJaxWsProject());
        multiStatus.add(this.getStatusPackage());
    }

    protected IStatus getStatusPackage() {
        return CompilationUnitNewWizardPage.validatePackageName(this.getTargetPackage());
    }

    protected IStatus getStatusWsdlName() {
        if (WebServiceType.PROVIDER_FROM_EMPTY_WSDL != this.getWebServiceType()) {
            return Status.OK_STATUS;
        }
        return CompilationUnitNewWizardPage.validateJavaName(this.getWsdlName(), this.m_providerWsdlNameField.getReadOnlySuffix());
    }

    protected IStatus getStatusExistingJaxWsProject() {
        if (this.isCreateNewProject()) {
            return Status.OK_STATUS;
        }
        if (!JdtUtils.exists((IJavaElement)this.getExistingJaxWsProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose the project in which the new Web Service should be created.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusServerProject() {
        if (!this.isCreateNewProject()) {
            return Status.OK_STATUS;
        }
        if (!JdtUtils.exists((IJavaElement)this.getServerProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose for which server project a new Web Service project should be created.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusArtifactId() {
        if (!this.isCreateNewProject()) {
            return Status.OK_STATUS;
        }
        String msg = ScoutProjectNewHelper.getMavenArtifactIdErrorMessage((String)this.getArtifactId());
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().equalsIgnoreCase(this.getArtifactId())) {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in the workspace.");
            }
            ++n2;
        }
        if (JdtUtils.exists((IJavaElement)this.getServerProject())) {
            Path serverProjectFolder = this.getServerProject().getProject().getLocation().makeAbsolute().toFile().toPath();
            Path targetDir = serverProjectFolder.getParent();
            if (targetDir != null) {
                if (Files.isDirectory(targetDir.resolve(this.getArtifactId()), new LinkOption[0])) {
                    return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in this target directory.");
                }
            } else {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "Invalid project location.");
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusWsdlUrl() {
        String wsdlUrl;
        ResourceTextField fieldToCheck;
        if (WebServiceType.CONSUMER_FROM_EXISTING_WSDL == this.getWebServiceType()) {
            fieldToCheck = this.m_consumerWsdlUrlField;
            wsdlUrl = this.getConsumerWsdlUrl();
        } else if (WebServiceType.PROVIDER_FROM_EXISTING_WSDL == this.getWebServiceType()) {
            fieldToCheck = this.m_providerWsdlUrlField;
            wsdlUrl = this.getProviderWsdlUrl();
        } else {
            return Status.OK_STATUS;
        }
        if (Strings.isBlank((CharSequence)wsdlUrl)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please specify a WSDL URL.");
        }
        try {
            final URL url = new URL(wsdlUrl);
            if (Objects.equals(this.m_lastParsedWsdlUrl, url)) {
                return this.m_lastParsedWsdlUrlStatus;
            }
            fieldToCheck.setEnabled(false);
            AbstractJob parseRemoteWsdl = new AbstractJob("parse WSDL"){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        String msg = WebServiceNewWizardPage.validateWsdl(url);
                        WebServiceNewWizardPage.this.m_lastParsedWsdlUrl = url;
                        if (msg == null) {
                            WebServiceNewWizardPage.this.m_lastParsedWsdlUrlStatus = Status.OK_STATUS;
                        } else {
                            WebServiceNewWizardPage.this.m_lastParsedWsdlUrlStatus = (IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", msg);
                        }
                    }
                    finally {
                        if (!fieldToCheck.isDisposed()) {
                            fieldToCheck.getDisplay().asyncExec(() -> {
                                if (!fieldToCheck.isDisposed()) {
                                    WebServiceNewWizardPage.this.revalidate();
                                    fieldToCheck.setEnabled(true);
                                }
                            });
                        }
                    }
                }
            };
            parseRemoteWsdl.setSystem(true);
            parseRemoteWsdl.setUser(false);
            parseRemoteWsdl.schedule();
        }
        catch (MalformedURLException e) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The given WSDL URL is not valid.", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String validateWsdl(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = url.openStream();){
                ParsedWsdl info = ParsedWsdl.create((URI)url.toURI(), (InputStream)in, (boolean)false);
                if (!info.isEmpty()) return null;
                return "Either this Web Service uses SOAP encoding (use=encoded) or contains no operations. Ensure the Web Service uses literal encoding.";
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | WSDLException e) {
            SdkLog.debug((Object[])new Object[]{e});
            return "The given WSDL cannot be parsed.";
        }
    }

    public boolean isCreateNewProject() {
        return this.getPropertyBool(PROP_IS_CREATE_NEW_PROJECT);
    }

    public void setIsCreateNewProject(boolean createNewProject) {
        this.setPropertyWithChangingControl(this.m_createNewProjectButton, () -> this.setIsCreateNewProjectInternal(createNewProject), field -> {
            field.setSelection(createNewProject);
            this.m_addToExistingProjectButton.setSelection(!createNewProject);
        });
    }

    protected boolean setIsCreateNewProjectInternal(boolean createNewProject) {
        return this.setProperty(PROP_IS_CREATE_NEW_PROJECT, createNewProject);
    }

    public String getTargetPackage() {
        return this.getProperty(PROP_TARGET_PACKAGE, String.class);
    }

    public void setTargetPackage(String targetPackage) {
        this.setPropertyWithChangingControl(this.m_packageField, () -> this.setTargetPackageInternal(targetPackage), field -> field.setText(targetPackage));
    }

    protected boolean setTargetPackageInternal(String targetPackage) {
        return this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }

    public IJavaProject getExistingJaxWsProject() {
        return this.getProperty(PROP_EXISTING_JAXWS_PROJECT, IJavaProject.class);
    }

    public void setExistingJaxWsProject(IJavaProject jp) {
        this.setPropertyWithChangingControl(this.m_existingJaxWsProjectField, () -> this.setExistingJaxWsProjectInternal(jp), field -> field.acceptProposal(jp));
    }

    protected boolean setExistingJaxWsProjectInternal(IJavaProject jp) {
        if (this.setProperty(PROP_EXISTING_JAXWS_PROJECT, jp)) {
            if (this.isControlCreated()) {
                ((PackageContentProvider)this.m_packageField.getContentProvider()).setJavaProject(jp);
            }
            this.guessPackage();
            return true;
        }
        return false;
    }

    public String getConsumerWsdlUrl() {
        return this.getProperty(PROP_CONSUMER_WSDL_URL, String.class);
    }

    public void setConsumerWsdlUrl(String wsdlUrl) {
        this.setPropertyWithChangingControl(this.m_consumerWsdlUrlField, () -> this.setConsumerWsdlUrlInternal(wsdlUrl), field -> field.setText(wsdlUrl));
    }

    protected boolean setConsumerWsdlUrlInternal(String wsdlUrl) {
        if (this.setProperty(PROP_CONSUMER_WSDL_URL, wsdlUrl)) {
            this.guessPackage();
            return true;
        }
        return false;
    }

    public String getArtifactId() {
        return this.getPropertyString(PROP_ARTIFACT_ID);
    }

    public void setArtifactId(String s) {
        this.setPropertyWithChangingControl(this.m_artifactIdField, () -> this.setArtifactIdInternal(s), field -> field.setText(s));
    }

    protected boolean setArtifactIdInternal(String s) {
        if (this.setPropertyString(PROP_ARTIFACT_ID, s)) {
            this.guessPackage();
            return true;
        }
        return false;
    }

    public IJavaProject getServerProject() {
        return this.getProperty(PROP_SERVER_PROJECT, IJavaProject.class);
    }

    public void setServerProject(IJavaProject jp) {
        this.setPropertyWithChangingControl(this.m_serverProjectField, () -> this.setServerProjectInternal(jp), field -> field.acceptProposal(jp));
    }

    protected boolean setServerProjectInternal(IJavaProject jp) {
        if (this.setProperty(PROP_SERVER_PROJECT, jp)) {
            this.guessArtifactId();
            this.guessPackage();
            return true;
        }
        return false;
    }

    public WebServiceType getWebServiceType() {
        return this.getProperty(PROP_WEB_SERVICE_TYPE, WebServiceType.class);
    }

    public void setWebServiceType(WebServiceType type) {
        this.setPropertyWithChangingControl(this.m_createConsumer, () -> this.setWebServiceTypeInternal(type), field -> {
            field.setSelection(WebServiceType.CONSUMER_FROM_EXISTING_WSDL == type);
            this.m_createProviderFromExistingWsdl.setSelection(WebServiceType.PROVIDER_FROM_EXISTING_WSDL == type);
            this.m_createProviderFromEmptyWsdl.setSelection(WebServiceType.PROVIDER_FROM_EMPTY_WSDL == type);
        });
    }

    protected boolean setWebServiceTypeInternal(WebServiceType type) {
        return this.setProperty(PROP_WEB_SERVICE_TYPE, (Object)type);
    }

    public String getWsdlName() {
        return this.getPropertyString(PROP_PROVIDER_WSDL_NAME);
    }

    public void setWsdlName(String s) {
        this.setPropertyWithChangingControl(this.m_providerWsdlNameField, () -> this.setWsdlNameInternal(s), field -> field.setText(s));
    }

    protected boolean setWsdlNameInternal(String s) {
        if (this.setPropertyString(PROP_PROVIDER_WSDL_NAME, s)) {
            this.guessPackage();
            return true;
        }
        return false;
    }

    public String getProviderWsdlUrl() {
        return this.getProperty(PROP_PROVIDER_WSDL_URL, String.class);
    }

    public void setProviderWsdlUrl(String wsdlUrl) {
        this.setPropertyWithChangingControl(this.m_providerWsdlUrlField, () -> this.setProviderWsdlUrlInternal(wsdlUrl), field -> field.setText(wsdlUrl));
    }

    protected boolean setProviderWsdlUrlInternal(String wsdlUrl) {
        if (this.setProperty(PROP_PROVIDER_WSDL_URL, wsdlUrl)) {
            this.guessPackage();
            return true;
        }
        return false;
    }

    protected boolean isPackageChanged() {
        return this.m_packageChanged;
    }

    protected void setPackageChanged(boolean packageChanged) {
        this.m_packageChanged = packageChanged;
    }

    public static enum WebServiceType {
        CONSUMER_FROM_EXISTING_WSDL,
        PROVIDER_FROM_EXISTING_WSDL,
        PROVIDER_FROM_EMPTY_WSDL;

    }
}

