/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.sdk.core.util.PropertySupport;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWizardPage
extends WizardPage {
    private IStatus m_status = Status.OK_STATUS;
    private Composite m_content;
    private int m_stateChangingCounter;
    private boolean m_excludePage;
    private final PropertySupport m_propertySupport = new PropertySupport((Object)this);

    protected AbstractWizardPage(String pageName) {
        super(pageName, null, null);
    }

    public final void createControl(Composite parent) {
        this.m_content = new Composite(parent, 0);
        this.m_content.setLayout((Layout)new FillLayout());
        this.createContent(this.m_content);
        this.setControl((Control)this.m_content);
        this.revalidate();
    }

    protected boolean isControlCreated() {
        return super.isControlCreated() && !this.getControl().isDisposed();
    }

    protected abstract void createContent(Composite var1);

    public Composite getControl() {
        return this.m_content;
    }

    public void setVisible(boolean visible) {
        this.m_content.setVisible(visible);
    }

    protected void setStatus(IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.isOK()) {
            this.setMessage(this.getDescription(), 0);
        } else {
            int messagetype;
            IStatus highestSeverityStatus = AbstractWizardPage.getHighestSeverityStatus(status);
            switch (highestSeverityStatus.getSeverity()) {
                case 1: {
                    messagetype = 1;
                    break;
                }
                case 2: {
                    messagetype = 2;
                    break;
                }
                case 4: {
                    messagetype = 3;
                    break;
                }
                default: {
                    messagetype = 0;
                }
            }
            String message = highestSeverityStatus.getMessage();
            this.setMessage(message, messagetype);
        }
        this.setPageComplete(!status.matches(4));
        this.m_status = status;
    }

    public static IStatus getHighestSeverityStatus(IStatus status) {
        return AbstractWizardPage.getHighestSeverityStatus(status, Status.OK_STATUS);
    }

    private static IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            for (IStatus child : status.getChildren()) {
                highestSeverity = AbstractWizardPage.getHighestSeverityStatus(child, highestSeverity);
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }

    public void pingStateChanging() {
        if (this.m_stateChangingCounter <= 0) {
            this.m_stateChangingCounter = 0;
            this.revalidate();
        }
    }

    protected void setStateChanging(boolean changing) {
        this.m_stateChangingCounter = changing ? ++this.m_stateChangingCounter : --this.m_stateChangingCounter;
        this.pingStateChanging();
    }

    protected boolean isStateChanging() {
        return this.m_stateChangingCounter > 0;
    }

    protected final void revalidate() {
        this.setStatus((IStatus)this.computePageStatus());
    }

    protected final MultiStatus computePageStatus() {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.scout.sdk.s2e.ui", -1, "multi status", null);
        this.validatePage(multiStatus);
        return multiStatus;
    }

    protected void validatePage(MultiStatus multiStatus) {
    }

    public boolean performFinish() {
        return true;
    }

    protected IStatus getStatus() {
        return this.m_status;
    }

    public void setExcludePage(boolean excludePage) {
        this.m_excludePage = excludePage;
    }

    public boolean isExcludePage() {
        return this.m_excludePage;
    }

    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.m_propertySupport.getProperty(key, type);
    }

    public boolean getPropertyBool(String name) {
        return this.getPropertyBool(name, false);
    }

    public boolean getPropertyBool(String name, boolean defaultValue) {
        return this.m_propertySupport.getPropertyBool(name, defaultValue);
    }

    public double getPropertyDouble(String name) {
        return this.m_propertySupport.getPropertyDouble(name, 0.0);
    }

    public int getPropertyInt(String name) {
        return this.m_propertySupport.getPropertyInt(name, 0);
    }

    public long getPropertyLong(String name) {
        return this.m_propertySupport.getPropertyLong(name, 0L);
    }

    public String getPropertyString(String name) {
        return this.m_propertySupport.getPropertyString(name);
    }

    public boolean setProperty(String name, Object newValue) {
        return this.m_propertySupport.setProperty(name, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Control> boolean setPropertyWithChangingControl(T controlToChange, BooleanSupplier propertyChanger, Consumer<T> controlChanger) {
        try {
            this.setStateChanging(true);
            boolean changed = propertyChanger.getAsBoolean();
            if (changed && controlToChange != null && this.isControlCreated()) {
                controlChanger.accept(controlToChange);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.m_propertySupport.setPropertyBool(name, b);
    }

    public boolean setPropertyDouble(String name, double d) {
        return this.m_propertySupport.setPropertyDouble(name, d);
    }

    public boolean setPropertyInt(String name, int i) {
        return this.m_propertySupport.setPropertyInt(name, i);
    }

    public boolean setPropertyLong(String name, long i) {
        return this.m_propertySupport.setPropertyLong(name, i);
    }

    public boolean setPropertyString(String name, String s) {
        return this.m_propertySupport.setPropertyString(name, s);
    }
}

