/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class FactoryPathGenerator
implements ISourceGenerator<ISourceBuilder<?>> {
    private String m_rtVersion;
    private IScoutVariousApi.JaxWsConstants m_jaxWsConstants;

    public void generate(ISourceBuilder<?> builder) {
        String scoutVersion = this.rtVersion().orElseThrow(() -> Ensure.newFail((CharSequence)"No Scout version provided", (Object[])new Object[0]));
        IScoutVariousApi.JaxWsConstants jaxWsConstants = this.jaxWsConstants().orElseThrow(() -> Ensure.newFail((CharSequence)"No JaxWs constants provided", (Object[])new Object[0]));
        builder.append("<factorypath>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/eclipse/scout/rt/org.eclipse.scout.jaxws.apt/").append(scoutVersion).append("/org.eclipse.scout.jaxws.apt-").append(scoutVersion).append(".jar\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/").append(jaxWsConstants.codeModelFactoryPath()).append("\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/eclipse/scout/rt/org.eclipse.scout.rt.platform/").append(scoutVersion).append("/org.eclipse.scout.rt.platform-").append(scoutVersion).append(".jar\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/eclipse/scout/rt/org.eclipse.scout.rt.server.jaxws/").append(scoutVersion).append("/org.eclipse.scout.rt.server.jaxws-").append(scoutVersion).append(".jar\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/").append(jaxWsConstants.servletFactoryPath()).append("\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/").append(jaxWsConstants.slf4jFactoryPath()).append("\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/").append(jaxWsConstants.jwsFactoryPath()).append("\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/jakarta/annotation/jakarta.annotation-api/1.3.5/jakarta.annotation-api-1.3.5.jar\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/jakarta/xml/ws/jakarta.xml.ws-api/2.3.3/jakarta.xml.ws-api-2.3.3.jar\" enabled=\"true\" runInBatchMode=\"false\"/>").nl();
        builder.append("</factorypath>").nl();
    }

    public Optional<String> rtVersion() {
        return Strings.notBlank((CharSequence)this.m_rtVersion);
    }

    public FactoryPathGenerator withRtVersion(String rtVersion) {
        this.m_rtVersion = rtVersion;
        return this;
    }

    public Optional<IScoutVariousApi.JaxWsConstants> jaxWsConstants() {
        return Optional.ofNullable(this.m_jaxWsConstants);
    }

    public FactoryPathGenerator withJaxWsConstants(IScoutVariousApi.JaxWsConstants jaxWsConstants) {
        this.m_jaxWsConstants = jaxWsConstants;
        return this;
    }
}

