/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsModuleNewHelper;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class JaxWsModuleNewOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private IJavaProject m_serverModule;
    private String m_artifactId;
    private IProject m_createdProject;

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress progress) {
        Ensure.isTrue((boolean)JdtUtils.exists((IJavaElement)this.getServerModule()), (CharSequence)"Target module pom file could not be found.", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getArtifactId());
        progress.init(100, this.toString(), new Object[0]);
        try {
            IFile pomFile = this.getServerModule().getProject().getFile("pom.xml");
            if (!pomFile.isAccessible()) {
                throw new SdkException((CharSequence)"{} could not be found in module '{}'.", new Object[]{"pom.xml", this.getServerModule().getElementName()});
            }
            progress.worked(5);
            Path createdProjectDir = JaxWsModuleNewHelper.createModule((Path)pomFile.getLocation().toFile().toPath(), (String)this.getArtifactId(), (IEnvironment)env, (IProgress)progress.newChild(10));
            IProject createdProject = JaxWsModuleNewOperation.importIntoWorkspace(createdProjectDir, progress.newChild(70));
            this.setCreatedProject(createdProject);
            S2eUtils.mavenUpdate(Collections.singleton(createdProject), false, true, false, true, (IProgressMonitor)progress.newChild(15).monitor());
        }
        catch (IOException | CoreException e) {
            throw new SdkException((CharSequence)"Unable to create Jax-Ws Module.", new Object[]{e});
        }
    }

    protected static IProject importIntoWorkspace(Path createdProjectDir, EclipseProgress progress) throws CoreException {
        Set<MavenProjectInfo> projects = Collections.singleton(new MavenProjectInfo(createdProjectDir.getFileName().toString(), createdProjectDir.resolve("pom.xml").toFile(), null, null));
        List importedProjects = MavenPlugin.getProjectConfigurationManager().importProjects(projects, new ProjectImportConfiguration(), (IProgressMonitor)progress.monitor());
        if (importedProjects == null || importedProjects.isEmpty()) {
            throw Ensure.newFail((CharSequence)"Unable to import newly created project into workspace.", (Object[])new Object[0]);
        }
        return ((IMavenProjectImportResult)importedProjects.iterator().next()).getProject();
    }

    public IJavaProject getServerModule() {
        return this.m_serverModule;
    }

    public void setServerModule(IJavaProject serverModule) {
        this.m_serverModule = serverModule;
    }

    public IProject getCreatedProject() {
        return this.m_createdProject;
    }

    protected void setCreatedProject(IProject createdProject) {
        this.m_createdProject = createdProject;
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }

    public String toString() {
        return "Create new JAX-WS Module";
    }
}

