/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.wellform;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.structured.Wellformer;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.SourceFormatOperation;
import org.eclipse.text.edits.ReplaceEdit;

public class WellformScoutTypeOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private final Set<org.eclipse.jdt.core.IType> m_types;
    private final boolean m_recursive;

    public WellformScoutTypeOperation(Set<org.eclipse.jdt.core.IType> types, boolean recursive) {
        this.m_types = new HashSet<org.eclipse.jdt.core.IType>(types);
        this.m_recursive = recursive;
    }

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress progress) {
        SubMonitor monitor = progress.monitor();
        monitor.beginTask("Wellform classes...", this.m_types.size());
        for (org.eclipse.jdt.core.IType t : this.m_types) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Wellform '" + t.getElementName() + "'.");
            try {
                this.wellformType(t, env);
            }
            catch (JavaModelException e) {
                SdkLog.warning((CharSequence)"Unable to wellform type '{}'.", (Object[])new Object[]{t.getFullyQualifiedName(), e});
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void wellformType(org.eclipse.jdt.core.IType type, EclipseEnvironment env) throws JavaModelException {
        ISourceRange typeRange = type.getSourceRange();
        if (!SourceRange.isAvailable((ISourceRange)typeRange)) {
            return;
        }
        ICompilationUnit icu = type.getCompilationUnit();
        String lineSeparator = icu.findRecommendedLineSeparator();
        Wellformer w = new Wellformer(lineSeparator, this.isRecursive());
        StringBuilder sourceBuilder = new StringBuilder(typeRange.getLength() * 2);
        IType scoutType = env.toScoutType(type);
        if (scoutType == null) {
            SdkLog.warning((CharSequence)"Type '{}' could not be found. Wellforming skipped.", (Object[])new Object[]{type});
            return;
        }
        boolean success = w.buildSource(scoutType, sourceBuilder);
        if (success) {
            try {
                WorkingCopyManager.currentWorkingCopyManager().register(icu, null);
                ReplaceEdit edit = new ReplaceEdit(typeRange.getOffset(), typeRange.getLength(), sourceBuilder.toString());
                IBuffer icuBuffer = icu.getBuffer();
                Document sourceDoc = new Document(icuBuffer.getContents());
                edit.apply((IDocument)sourceDoc);
                new SourceFormatOperation(type.getJavaProject(), sourceDoc).accept(null);
                icuBuffer.setContents(sourceDoc.get());
            }
            catch (JavaModelException | BadLocationException e) {
                SdkLog.warning((CharSequence)"Could not wellform type '{}'.", (Object[])new Object[]{type.getFullyQualifiedName(), e});
            }
        } else {
            SdkLog.warning((CharSequence)"Unable to get source of type '{}'. Skipping wellform for this type.", (Object[])new Object[]{type.getFullyQualifiedName()});
        }
    }

    public boolean isRecursive() {
        return this.m_recursive;
    }

    public String toString() {
        return "Wellform Scout Types";
    }
}

