/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.QuotingRequirements;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExampleCommandLineArgument
implements Serializable {
    private static final long serialVersionUID = 2468880329239320437L;
    private final String rawForm;
    private final String unixForm;
    private final String windowsForm;

    private ExampleCommandLineArgument(String rawForm, String unixForm, String windowsForm) {
        this.rawForm = rawForm;
        this.unixForm = unixForm;
        this.windowsForm = windowsForm;
    }

    public String getRawForm() {
        return this.rawForm;
    }

    public String getUnixForm() {
        return this.unixForm;
    }

    public String getWindowsForm() {
        return this.windowsForm;
    }

    public String getLocalForm() {
        if (StaticUtils.isWindows()) {
            return this.getWindowsForm();
        }
        return this.getUnixForm();
    }

    public static ExampleCommandLineArgument getCleanArgument(String argument) {
        return new ExampleCommandLineArgument(argument, ExampleCommandLineArgument.getUnixForm(argument), ExampleCommandLineArgument.getWindowsForm(argument));
    }

    public static String getUnixForm(String argument) {
        Validator.ensureNotNull(argument);
        QuotingRequirements requirements = ExampleCommandLineArgument.getRequiredUnixQuoting(argument);
        String quotedArgument = argument;
        if (requirements.requiresSingleQuotesOnUnix()) {
            if (requirements.includesSingleQuote()) {
                quotedArgument = quotedArgument.replace("'", "'\"'\"'");
            }
            quotedArgument = "'" + quotedArgument + "'";
        } else if (requirements.requiresDoubleQuotesOnUnix()) {
            quotedArgument = "\"" + quotedArgument + "\"";
        }
        return quotedArgument;
    }

    public static String getWindowsForm(String argument) {
        Validator.ensureNotNull(argument);
        QuotingRequirements requirements = ExampleCommandLineArgument.getRequiredUnixQuoting(argument);
        String quotedArgument = argument;
        if (requirements.requiresSingleQuotesOnUnix() || requirements.requiresDoubleQuotesOnUnix()) {
            if (requirements.includesDoubleQuote()) {
                quotedArgument = quotedArgument.replace("\"", "\"\"");
            }
            quotedArgument = "\"" + quotedArgument + "\"";
        }
        return quotedArgument;
    }

    public static List<String> parseExampleCommandLine(String exampleCommandLine) {
        Validator.ensureNotNull(exampleCommandLine);
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder currentArg = new StringBuilder();
        boolean inArg = false;
        for (int i = 0; i < exampleCommandLine.length(); ++i) {
            Character c = Character.valueOf(exampleCommandLine.charAt(i));
            Character nextChar = null;
            if (i < exampleCommandLine.length() - 1) {
                nextChar = Character.valueOf(exampleCommandLine.charAt(i + 1));
            }
            if (inDoubleQuote) {
                if (c.charValue() == '\"') {
                    if (nextChar != null && nextChar.charValue() == '\"') {
                        currentArg.append('\"');
                        ++i;
                        continue;
                    }
                    inDoubleQuote = false;
                    continue;
                }
                currentArg.append(c);
                continue;
            }
            if (inSingleQuote) {
                if (c.charValue() == '\'') {
                    inSingleQuote = false;
                    continue;
                }
                currentArg.append(c);
                continue;
            }
            if (c.charValue() == '\"') {
                inDoubleQuote = true;
                inArg = true;
                continue;
            }
            if (c.charValue() == '\'') {
                inSingleQuote = true;
                inArg = true;
                continue;
            }
            if (c.charValue() == ' ' || c.charValue() == '\t') {
                if (!inArg) continue;
                args.add(currentArg.toString());
                currentArg = new StringBuilder();
                inArg = false;
                continue;
            }
            currentArg.append(c);
            inArg = true;
        }
        if (inArg) {
            args.add(currentArg.toString());
        }
        return args;
    }

    private static QuotingRequirements getRequiredUnixQuoting(String argument) {
        boolean requiresDoubleQuotes = false;
        boolean requiresSingleQuotes = false;
        boolean includesDoubleQuote = false;
        boolean includesSingleQuote = false;
        if (argument.length() == 0) {
            requiresDoubleQuotes = true;
        }
        block7: for (int i = 0; i < argument.length(); ++i) {
            char c = argument.charAt(i);
            switch (c) {
                case '\"': {
                    includesDoubleQuote = true;
                    requiresSingleQuotes = true;
                    continue block7;
                }
                case '!': 
                case '$': 
                case '*': 
                case '@': 
                case '\\': 
                case '`': {
                    requiresSingleQuotes = true;
                    continue block7;
                }
                case '\'': {
                    includesSingleQuote = true;
                    requiresDoubleQuotes = true;
                    continue block7;
                }
                case ' ': 
                case '&': 
                case '(': 
                case ')': 
                case ';': 
                case '<': 
                case '>': 
                case '|': {
                    requiresDoubleQuotes = true;
                    continue block7;
                }
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '_': {
                    continue block7;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue block7;
                    requiresDoubleQuotes = true;
                }
            }
        }
        if (requiresSingleQuotes) {
            requiresDoubleQuotes = false;
        }
        return new QuotingRequirements(requiresSingleQuotes, requiresDoubleQuotes, includesSingleQuote, includesDoubleQuote);
    }
}

