/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Geodaten;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMH System</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Geodaten.GeodatenPackage#getENUMHSystem()
 * @model extendedMetaData="name='ENUMHSystem'"
 * @generated
 */
public enum ENUMHSystem implements Enumerator {
	/**
	 * The '<em><b>ENUMH System DBRH 2003</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DBRH_2003_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_DBRH_2003(0, "ENUMHSystem_DBRH_2003", "DBRH_2003"),

	/**
	 * The '<em><b>ENUMH System DBRH 2016</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DBRH_2016_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_DBRH_2016(1, "ENUMHSystem_DBRH_2016", "DBRH_2016"),

	/**
	 * The '<em><b>ENUMH System DHHN 12</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_12_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_DHHN_12(2, "ENUMHSystem_DHHN_12", "DHHN_12"),

	/**
	 * The '<em><b>ENUMH System DHHN 2016</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_2016_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_DHHN_2016(3, "ENUMHSystem_DHHN_2016", "DHHN_2016"),

	/**
	 * The '<em><b>ENUMH System DHHN 85</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_85_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_DHHN_85(4, "ENUMHSystem_DHHN_85", "DHHN_85"),

	/**
	 * The '<em><b>ENUMH System DHHN 92</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_92_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_DHHN_92(5, "ENUMHSystem_DHHN_92", "DHHN_92"),

	/**
	 * The '<em><b>ENUMH System HN 56</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_HN_56_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_HN_56(6, "ENUMHSystem_HN_56", "HN_56"),

	/**
	 * The '<em><b>ENUMH System HN 76</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_HN_76_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_HN_76(7, "ENUMHSystem_HN_76", "HN_76"),

	/**
	 * The '<em><b>ENUMH System sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMH_SYSTEM_SONSTIGE(8, "ENUMHSystem_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUMH System DBRH 2003</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DBRH_2003
	 * @model name="ENUMHSystem_DBRH_2003" literal="DBRH_2003"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_DBRH_2003_VALUE = 0;

	/**
	 * The '<em><b>ENUMH System DBRH 2016</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DBRH_2016
	 * @model name="ENUMHSystem_DBRH_2016" literal="DBRH_2016"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_DBRH_2016_VALUE = 1;

	/**
	 * The '<em><b>ENUMH System DHHN 12</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_12
	 * @model name="ENUMHSystem_DHHN_12" literal="DHHN_12"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_DHHN_12_VALUE = 2;

	/**
	 * The '<em><b>ENUMH System DHHN 2016</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_2016
	 * @model name="ENUMHSystem_DHHN_2016" literal="DHHN_2016"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_DHHN_2016_VALUE = 3;

	/**
	 * The '<em><b>ENUMH System DHHN 85</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_85
	 * @model name="ENUMHSystem_DHHN_85" literal="DHHN_85"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_DHHN_85_VALUE = 4;

	/**
	 * The '<em><b>ENUMH System DHHN 92</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_DHHN_92
	 * @model name="ENUMHSystem_DHHN_92" literal="DHHN_92"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_DHHN_92_VALUE = 5;

	/**
	 * The '<em><b>ENUMH System HN 56</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_HN_56
	 * @model name="ENUMHSystem_HN_56" literal="HN_56"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_HN_56_VALUE = 6;

	/**
	 * The '<em><b>ENUMH System HN 76</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_HN_76
	 * @model name="ENUMHSystem_HN_76" literal="HN_76"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_HN_76_VALUE = 7;

	/**
	 * The '<em><b>ENUMH System sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMH_SYSTEM_SONSTIGE
	 * @model name="ENUMHSystem_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMH_SYSTEM_SONSTIGE_VALUE = 8;

	/**
	 * An array of all the '<em><b>ENUMH System</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMHSystem[] VALUES_ARRAY =
		new ENUMHSystem[] {
			ENUMH_SYSTEM_DBRH_2003,
			ENUMH_SYSTEM_DBRH_2016,
			ENUMH_SYSTEM_DHHN_12,
			ENUMH_SYSTEM_DHHN_2016,
			ENUMH_SYSTEM_DHHN_85,
			ENUMH_SYSTEM_DHHN_92,
			ENUMH_SYSTEM_HN_56,
			ENUMH_SYSTEM_HN_76,
			ENUMH_SYSTEM_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMH System</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMHSystem> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMH System</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMHSystem get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMHSystem result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMH System</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMHSystem getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMHSystem result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMH System</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMHSystem get(int value) {
		switch (value) {
			case ENUMH_SYSTEM_DBRH_2003_VALUE: return ENUMH_SYSTEM_DBRH_2003;
			case ENUMH_SYSTEM_DBRH_2016_VALUE: return ENUMH_SYSTEM_DBRH_2016;
			case ENUMH_SYSTEM_DHHN_12_VALUE: return ENUMH_SYSTEM_DHHN_12;
			case ENUMH_SYSTEM_DHHN_2016_VALUE: return ENUMH_SYSTEM_DHHN_2016;
			case ENUMH_SYSTEM_DHHN_85_VALUE: return ENUMH_SYSTEM_DHHN_85;
			case ENUMH_SYSTEM_DHHN_92_VALUE: return ENUMH_SYSTEM_DHHN_92;
			case ENUMH_SYSTEM_HN_56_VALUE: return ENUMH_SYSTEM_HN_56;
			case ENUMH_SYSTEM_HN_76_VALUE: return ENUMH_SYSTEM_HN_76;
			case ENUMH_SYSTEM_SONSTIGE_VALUE: return ENUMH_SYSTEM_SONSTIGE;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMHSystem(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMHSystem
