/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.gmf.runtime.draw2d.ui.figures.SiriusPolylineConnectionEx;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractEdgesZOrderAction
implements IObjectActionDelegate,
Disposable {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Object nextSelected;
        IStructuredSelection structuredSelection;
        HashSet<Object> minimizedSelection;
        if (this.selection instanceof IStructuredSelection && (minimizedSelection = new HashSet<Object>(Arrays.asList((structuredSelection = (IStructuredSelection)this.selection).toArray()))).size() > 0 && (nextSelected = minimizedSelection.iterator().next()) instanceof IDiagramEdgeEditPart) {
            DDiagramEditor diagramEditor = (DDiagramEditor)((EditPart)nextSelected).getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            List<IDiagramEdgeEditPart> selectedEdges = this.objectsListToEdgeEditPart(Arrays.asList(structuredSelection.toArray()));
            Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)diagramEditor.getEditingDomain().getResourceSet());
            IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
            try {
                Command a = this.buildZOrderCommand(emfCommandFactory, selectedEdges);
                ((TransactionalEditingDomain)diagramEditor.getAdapter(EditingDomain.class)).getCommandStack().execute(a);
            }
            catch (UnsupportedOperationException e) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractEdgesZOrderAction_noExecutioninformationDialogTitle, (String)e.getMessage());
            }
        }
    }

    protected abstract Command getCommandToExecute(IDiagramCommandFactory var1, List<IDiagramEdgeEditPart> var2) throws UnsupportedOperationException;

    protected List<Edge> partsToEdge(List<IDiagramEdgeEditPart> edgeEditParts) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (IDiagramEdgeEditPart edgeEditPart : edgeEditParts) {
            View gmfView = edgeEditPart.getNotationView();
            if (!(gmfView instanceof Edge)) continue;
            result.add((Edge)gmfView);
        }
        return result;
    }

    protected List<SiriusPolylineConnectionEx> partsToConnection(List<IDiagramEdgeEditPart> edgeEditParts) {
        ArrayList<SiriusPolylineConnectionEx> result = new ArrayList<SiriusPolylineConnectionEx>();
        for (IDiagramEdgeEditPart edgeEditPart : edgeEditParts) {
            if (!(edgeEditPart.getFigure() instanceof SiriusPolylineConnectionEx)) continue;
            result.add((SiriusPolylineConnectionEx)edgeEditPart.getFigure());
        }
        return result;
    }

    private List<IDiagramEdgeEditPart> objectsListToEdgeEditPart(List<Object> aList) {
        return aList.stream().filter(IDiagramEdgeEditPart.class::isInstance).map(IDiagramEdgeEditPart.class::cast).collect(Collectors.toList());
    }

    public void selectionChanged(IAction action, ISelection s) {
        this.selection = s;
    }

    public void dispose() {
        this.selection = null;
    }

    private Command buildZOrderCommand(IDiagramCommandFactory commandFactory, List<IDiagramEdgeEditPart> edgesToMove) {
        View firstView = edgesToMove.iterator().next().getNotationView();
        EObject container = firstView.eContainer();
        if (container instanceof Diagram) {
            if (PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container).canEditInstance(container) && PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container).canEditInstance(((Diagram)container).getElement())) {
                return this.getCommandToExecute(commandFactory, edgesToMove);
            }
            throw new UnsupportedOperationException("This z-order action can not be launched as the diagram can not be modified.");
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected int computeNextCrossingEdgeIndex(List<IDiagramEdgeEditPart> selectedEdges, boolean above) {
        int result = above ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        List<SiriusPolylineConnectionEx> connections = this.partsToConnection(selectedEdges);
        for (SiriusPolylineConnectionEx connection : connections) {
            int newIndex = this.getIndexOfFirstIntersection(connection, above, connections);
            int n = result = above ? Math.max(result, newIndex) : Math.min(result, newIndex);
        }
        if (result == Integer.MIN_VALUE || result == Integer.MAX_VALUE) {
            result = -1;
        }
        return result;
    }

    private int getIndexOfFirstIntersection(SiriusPolylineConnectionEx connection, boolean above, List<SiriusPolylineConnectionEx> connectionsToIgnore) {
        IFigure pParent = connection.getParent();
        PointList tmpLine = connection.getSmoothPoints();
        List children = pParent.getChildren();
        int nIndex = children.indexOf(connection);
        ListIterator childIter = children.listIterator(nIndex);
        while (!(above ? !childIter.hasNext() : !childIter.hasPrevious())) {
            PointList distances;
            PointList intersections;
            IFigure figure;
            IFigure iFigure = figure = above ? (IFigure)childIter.next() : (IFigure)childIter.previous();
            if (connectionsToIgnore.contains(figure)) continue;
            PointList checkLine = null;
            if (figure instanceof SiriusPolylineConnectionEx) {
                checkLine = ((SiriusPolylineConnectionEx)figure).getSmoothPoints();
            } else if (figure instanceof Connection) {
                checkLine = PointListUtilities.copyPoints((PointList)((Connection)figure).getPoints());
            }
            if (checkLine == null || !PointListUtilities.findIntersections((PointList)tmpLine, (PointList)checkLine, (PointList)(intersections = new PointList()), (PointList)(distances = new PointList())) || intersections.size() <= 0) continue;
            return children.indexOf(figure);
        }
        return -1;
    }
}

