/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore;

import java.util.List;
import org.eclipse.elk.alg.spore.SPOrEPhases;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.alg.spore.options.StructureExtractionStrategy;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class ShrinkTree {
    private AlgorithmAssembler<SPOrEPhases, Graph> algorithmAssembler = AlgorithmAssembler.create(SPOrEPhases.class);
    private List<ILayoutProcessor<Graph>> algorithm;

    public void shrink(Graph graph, IElkProgressMonitor progressMonitor) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)SPOrEPhases.P1_STRUCTURE, (ILayoutPhaseFactory)StructureExtractionStrategy.DELAUNAY_TRIANGULATION);
        this.algorithmAssembler.setPhase((Enum)SPOrEPhases.P2_PROCESSING_ORDER, (ILayoutPhaseFactory)graph.treeConstructionStrategy);
        this.algorithmAssembler.setPhase((Enum)SPOrEPhases.P3_EXECUTION, (ILayoutPhaseFactory)graph.compactionStrategy);
        this.algorithm = this.algorithmAssembler.build((Object)graph);
        progressMonitor.begin("Compaction by shrinking a tree", (float)this.algorithm.size());
        if (graph.vertices.size() > 1) {
            for (ILayoutProcessor<Graph> processor : this.algorithm) {
                processor.process((Object)graph, progressMonitor.subTask(1.0f));
            }
        }
        progressMonitor.done();
    }
}

