/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.sirius.properties.core.internal.migration.AnyTypeConverterRegistry;
import org.eclipse.sirius.properties.core.internal.migration.IAnyTypeConverter;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.FixedColor;

public class DefaultAnyTypeConverter
implements IAnyTypeConverter {
    private static final String IDENTIFIER = "identifier";

    @Override
    public boolean canConvert(Resource resource, AnyType anyType, EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    @Override
    public Optional<EObject> convert(Resource resource, AnyType anyType, EClass eClass) {
        EFactory eFactory = eClass.getEPackage().getEFactoryInstance();
        Optional<EObject> optionalEObject = Optional.ofNullable(eFactory.create(eClass));
        optionalEObject.ifPresent(eObject -> {
            anyType.getAnyAttribute().forEach(entry -> this.convertAnyAttribute(resource, (EObject)eObject, (FeatureMap.Entry)entry));
            anyType.getMixed().forEach(entry -> this.convertMixed(resource, (EObject)eObject, (FeatureMap.Entry)entry));
        });
        return optionalEObject;
    }

    protected void convertAnyAttribute(Resource resource, EObject eObject, FeatureMap.Entry entry) {
        if (IDENTIFIER.equals(entry.getEStructuralFeature().getName()) && DescriptionPackage.Literals.IDENTIFIED_ELEMENT.isInstance((Object)eObject) && entry.getValue() instanceof String) {
            eObject.eSet((EStructuralFeature)DescriptionPackage.Literals.IDENTIFIED_ELEMENT__NAME, entry.getValue());
        }
        Optional.ofNullable(eObject.eClass().getEStructuralFeature(entry.getEStructuralFeature().getName())).ifPresent(eStructuralFeature -> {
            if (eStructuralFeature instanceof EReference && DescriptionPackage.Literals.COLOR_DESCRIPTION == ((EReference)eStructuralFeature).getEReferenceType() && entry.getValue() instanceof String) {
                FixedColor colorDescription = DescriptionFactory.eINSTANCE.createFixedColor();
                if (colorDescription instanceof InternalEObject) {
                    InternalEObject internalEObject = (InternalEObject)colorDescription;
                    internalEObject.eSetProxyURI(resource.getURI().appendFragment((String)entry.getValue()));
                }
                eObject.eSet(eStructuralFeature, (Object)colorDescription);
            } else if (eStructuralFeature instanceof EAttribute && entry.getValue() instanceof String) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                EDataType eDataType = eAttribute.getEAttributeType();
                String stringValue = (String)entry.getValue();
                eObject.eSet(eStructuralFeature, EcoreUtil.createFromString((EDataType)eDataType, (String)stringValue));
            } else {
                eObject.eSet(eStructuralFeature, entry.getValue());
            }
        });
    }

    protected void convertMixed(Resource resource, EObject eObject, FeatureMap.Entry entry) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(entry.getEStructuralFeature().getName());
        if (eStructuralFeature instanceof EReference) {
            Object value;
            EReference eReference = (EReference)eStructuralFeature;
            if (!eReference.isMany() && entry.getValue() instanceof AnyType) {
                this.convertMonoValuedReference(resource, eObject, eReference, (AnyType)entry.getValue());
            } else if (eReference.isMany() && entry.getValue() instanceof AnyType) {
                this.convertMultiValuedReference(resource, eObject, eReference, (AnyType)entry.getValue());
            } else if (!eReference.isMany() && eReference.getEReferenceType().isInstance(entry.getValue())) {
                eObject.eSet((EStructuralFeature)eReference, (Object)EcoreUtil.copy((EObject)((EObject)entry.getValue())));
            } else if (eReference.isMany() && eReference.getEReferenceType().isInstance(entry.getValue()) && (value = eObject.eGet((EStructuralFeature)eReference)) instanceof Collection) {
                ArrayList<EObject> objects = new ArrayList<EObject>();
                Collection values = (Collection)value;
                values.forEach(objects::add);
                objects.add(EcoreUtil.copy((EObject)((EObject)entry.getValue())));
                eObject.eSet((EStructuralFeature)eReference, objects);
            }
        }
    }

    protected void convertMonoValuedReference(Resource resource, EObject eObject, EReference eReference, AnyType anyType) {
        EClass eClass = eReference.getEReferenceType();
        Optional<IAnyTypeConverter> optionalConverter = AnyTypeConverterRegistry.getConverter(resource, anyType, eClass);
        Optional optionalReferencedEObject = optionalConverter.flatMap(converter -> converter.convert(resource, anyType, eClass));
        optionalReferencedEObject.ifPresent(referencedEObject -> eObject.eSet((EStructuralFeature)eReference, referencedEObject));
    }

    protected void convertMultiValuedReference(Resource resource, EObject eObject, EReference eReference, AnyType anyType) {
        EClass eClass = eReference.getEReferenceType();
        Optional<IAnyTypeConverter> optionalConverter = AnyTypeConverterRegistry.getConverter(resource, anyType, eClass);
        Optional optionalReferencedEObject = optionalConverter.flatMap(converter -> converter.convert(resource, anyType, eClass));
        optionalReferencedEObject.ifPresent(referencedEObject -> {
            Object value = eObject.eGet((EStructuralFeature)eReference);
            if (value instanceof Collection) {
                ArrayList<EObject> objects = new ArrayList<EObject>();
                Collection values = (Collection)value;
                values.forEach(objects::add);
                objects.add((EObject)referencedEObject);
                eObject.eSet((EStructuralFeature)eReference, objects);
            }
        });
    }
}

