/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction.oned;

import com.google.common.math.DoubleMath;

public final class CompareFuzzy {
    public static final double TOLERANCE = 1.0E-4;

    private CompareFuzzy() {
    }

    public static boolean eq(double d1, double d2) {
        return DoubleMath.fuzzyEquals((double)d1, (double)d2, (double)1.0E-4);
    }

    public static boolean gt(double d1, double d2) {
        return DoubleMath.fuzzyCompare((double)d1, (double)d2, (double)1.0E-4) > 0;
    }

    public static boolean lt(double d1, double d2) {
        return DoubleMath.fuzzyCompare((double)d1, (double)d2, (double)1.0E-4) < 0;
    }

    public static boolean ge(double d1, double d2) {
        return DoubleMath.fuzzyCompare((double)d1, (double)d2, (double)1.0E-4) >= 0;
    }

    public static boolean le(double d1, double d2) {
        return DoubleMath.fuzzyCompare((double)d1, (double)d2, (double)1.0E-4) <= 0;
    }
}

