/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.sirius.business.api.color.AbstractColorUpdater;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class SiriusAssert
extends Assert {
    public static void assertNotEquals(String message, Object expected, Object actual) {
        if (Objects.equal((Object)expected, (Object)actual)) {
            SiriusAssert.failEquals(message, expected, actual);
        }
    }

    public static void assertNotEquals(Object expected, Object actual) {
        SiriusAssert.assertNotEquals(null, expected, actual);
    }

    public static void failEquals(String message, Object expected, Object actual) {
        throw new ComparisonFailure(message, String.valueOf(expected), String.valueOf(actual));
    }

    public static void assertSameRGB(String message, RGBValues expected, RGBValues actual) {
        if (!AbstractColorUpdater.areEquals((RGBValues)expected, (RGBValues)actual)) {
            throw new ComparisonFailure(message, String.valueOf(expected), String.valueOf(actual));
        }
    }

    public static void assertFileExists(String wksPath) {
        IFile fileToTest = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(wksPath));
        try {
            fileToTest.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((String)("The file \"" + wksPath + "\" does not exist."), (boolean)fileToTest.exists());
    }

    public static void assertNoSiriusCorePreferenceChangedinSiriusUIStore(String preferenceKey) {
        ArrayList<SiriusPreferencesKeys> coreKeys = new ArrayList<SiriusPreferencesKeys>(Arrays.asList(SiriusPreferencesKeys.values()));
        Function<SiriusPreferencesKeys, String> prefToName = new Function<SiriusPreferencesKeys, String>(){

            public String apply(SiriusPreferencesKeys input) {
                return input.name();
            }
        };
        TestCase.assertFalse((String)("The DesignerPreferenceKey named " + preferenceKey + " should not be modified in the UI store."), (boolean)Lists.newArrayList((Iterable)Iterables.transform(coreKeys, (Function)prefToName)).contains(preferenceKey));
    }

    public static void assertNoDiagramCorePreferenceChangedinDiagramUIStore(String preferenceKey) {
        SiriusDiagramInternalPreferencesKeys key;
        ArrayList<String> coreKeys = new ArrayList<String>();
        SiriusDiagramInternalPreferencesKeys[] siriusDiagramInternalPreferencesKeysArray = SiriusDiagramInternalPreferencesKeys.values();
        int n = siriusDiagramInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        siriusDiagramInternalPreferencesKeysArray = SiriusDiagramPreferencesKeys.values();
        n = siriusDiagramInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        coreKeys.add("Viewpoint.Connectors.enableOverride");
        coreKeys.add("Viewpoint.Connectors.lineStyle");
        SiriusAssert.assertFalse((String)("The Diagram core preference named " + preferenceKey + " should not be modified in the Diagram UI store."), (boolean)coreKeys.contains(preferenceKey));
    }

    public static void assertNoDiagramUIPreferenceChangedinDiagramCoreStore(String preferenceKey) {
        SiriusDiagramUiInternalPreferencesKeys key;
        ArrayList<String> uiKeys = new ArrayList<String>();
        SiriusDiagramUiInternalPreferencesKeys[] siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiInternalPreferencesKeys.values();
        int n = siriusDiagramUiInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiPreferencesKeys.values();
        n = siriusDiagramUiInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        SiriusAssert.assertFalse((String)("The Diagram UI preference named " + preferenceKey + " should not be modified in the Diagram core store."), (boolean)uiKeys.contains(preferenceKey));
    }
}

