/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.navigator;

import java.util.Collection;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.CommonItem;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.swt.graphics.Image;

public class GroupingItem
implements CommonItem,
ItemDecorator {
    private final int fOffset;
    private Object parent;
    private Collection<Object> children;
    private Image imageCache;
    private String labelSuffix;

    public GroupingItem(int offset, Object parent, Collection<Object> children) {
        this(offset, parent, children, "");
    }

    public GroupingItem(int offset, Object parent, Collection<Object> children, String labelSuffix) {
        this.fOffset = offset;
        this.parent = parent;
        this.children = children;
        this.labelSuffix = labelSuffix;
    }

    @Override
    public Collection<?> getChildren() {
        return this.children;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public String getText() {
        int childrenSize = 0;
        if (this.children != null && this.children.size() > 0) {
            childrenSize = this.children.size() - 1;
        }
        return "[" + this.fOffset + ".." + (this.fOffset + childrenSize) + "]" + this.labelSuffix;
    }

    @Override
    public Image getImage() {
        if (this.imageCache == null) {
            this.imageCache = SiriusTransPlugin.INSTANCE.getBundledImage("org.eclipse.sirius.common.ui/icons/ArrayPartition.gif");
        }
        return this.imageCache;
    }
}

